/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.util.Map;
import java.util.Objects;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;

public class SetParameters
extends ConsoleCommand {
    @Override
    public String getName() {
        return "set";
    }

    @Override
    public String getHelpShort() {
        return "Allows various console parameters to be set";
    }

    @Override
    public String getHelpLong() {
        StringBuilder builder = new StringBuilder(this.settings.size() * 80);
        for (ConsoleSetting setting : this.settings.values()) {
            builder.append(setting.getHelpLong());
        }
        return "Usage:\nset                            Shows all parameter values\n" + builder.toString();
    }

    public SetParameters(ConsoleIO consoleIO, ConsoleState state, Map<String, ConsoleSetting> settings) {
        super(consoleIO, state, settings);
    }

    @Override
    public void execute(String ... tokens) {
        switch (tokens.length) {
            case 0: {
                this.writeln(this.getHelpLong());
                break;
            }
            case 1: {
                for (String setting : this.settings.keySet()) {
                    this.showSetting(setting);
                }
                break;
            }
            default: {
                String param = tokens[1];
                int eqIdx = param.indexOf(61);
                if (eqIdx < 0) {
                    this.showSetting(param);
                    break;
                }
                String key = param.substring(0, eqIdx);
                String values = String.join((CharSequence)" ", tokens);
                eqIdx = values.indexOf(61);
                this.setParameter(key, values.substring(eqIdx + 1));
            }
        }
    }

    private void showSetting(String key) {
        String str = key.toLowerCase();
        ConsoleSetting setting = (ConsoleSetting)this.settings.get(str);
        if (setting != null) {
            String s = setting.getAsString();
            if (s.length() > 70 && s.contains(",")) {
                StringBuilder builder = new StringBuilder();
                for (String val : s.split(",")) {
                    builder.append("\n    ").append(val);
                }
                s = builder.toString();
            }
            this.writeln(key + ": " + s);
        } else {
            this.writeError("Unknown parameter: " + key);
        }
    }

    private void setParameter(String key, String value) {
        Objects.requireNonNull(key, "parameter key was missing");
        Objects.requireNonNull(value, "parameter value was missing");
        String str = key.toLowerCase();
        ConsoleSetting setting = (ConsoleSetting)this.settings.get(str);
        if (setting != null) {
            try {
                setting.setFromString(value);
            }
            catch (IllegalArgumentException iae) {
                this.writeError(iae.getMessage());
            }
        } else {
            this.writeError("Unknown parameter: " + key);
        }
    }
}

