/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SetFilterNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValuesBackedNode;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class TargetNode
extends Target {
    private final TreeSet<Value> targetNodes;
    private final Resource[] sourceContexts;

    public TargetNode(TreeSet<Value> targetNodes, Resource[] sourceContexts) {
        this.targetNodes = targetNodes;
        assert (!this.targetNodes.isEmpty());
        this.sourceContexts = sourceContexts;
    }

    @Override
    public IRI getPredicate() {
        return SHACL.TARGET_NODE;
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        return new ValuesBackedNode(this.targetNodes, scope, this.sourceContexts);
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNode parent) {
        return new SetFilterNode(this.targetNodes, parent, 0, true);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        this.targetNodes.forEach(t -> model.add(subject, this.getPredicate(), (Value)t, new Resource[0]));
    }

    @Override
    public SparqlFragment getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, Set<String> inheritedVarNames) {
        assert (subject == null);
        StringBuilder sb = new StringBuilder();
        sb.append("VALUES ( ").append(object.asSparqlVariable()).append(" ) {\n");
        this.targetNodes.stream().map(targetNode -> {
            if (targetNode.isResource()) {
                return "<" + targetNode + ">";
            }
            if (targetNode.isLiteral()) {
                IRI datatype = ((Literal)targetNode).getDatatype();
                if (datatype == null) {
                    return "\"" + targetNode.stringValue() + "\"";
                }
                if (((Literal)targetNode).getLanguage().isPresent()) {
                    return "\"" + targetNode.stringValue() + "\"@" + ((Literal)targetNode).getLanguage().get();
                }
                return "\"" + targetNode.stringValue() + "\"^^<" + datatype.stringValue() + ">";
            }
            throw new IllegalStateException(targetNode.getClass().getSimpleName());
        }).forEach(targetNode -> sb.append("( ").append((String)targetNode).append(" )\n"));
        sb.append("}");
        return SparqlFragment.bgp(List.of(), sb.toString());
    }

    @Override
    public Set<Namespace> getNamespaces() {
        return Set.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetNode that = (TargetNode)o;
        return this.targetNodes.equals(that.targetNodes);
    }

    public int hashCode() {
        return Objects.hash(this.targetNodes);
    }
}

