/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.paths;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclAstLists;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class AlternativePath
extends Path {
    private final Resource alternativePathId;
    private final List<Path> paths;

    public AlternativePath(Resource id, Resource paths, ShapeSource shapeSource) {
        super(id);
        this.alternativePathId = paths;
        this.paths = ShaclAstLists.toList(shapeSource, paths, Resource.class).stream().map(p -> Path.buildPath(shapeSource, p)).collect(Collectors.toList());
    }

    public AlternativePath(Resource id, Resource alternativePathId, List<Path> paths) {
        super(id);
        this.alternativePathId = alternativePathId;
        this.paths = paths;
    }

    public String toString() {
        return "AlternativePath{ " + this.paths + " }";
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.ALTERNATIVE_PATH, (Value)this.alternativePathId, new Resource[0]);
        List values = this.paths.stream().map(Path::getId).collect(Collectors.toList());
        if (!model.contains(this.alternativePathId, null, null, new Resource[0])) {
            ShaclAstLists.listToRdf(values, this.alternativePathId, model);
        }
        this.paths.forEach(p -> p.toModel(p.getId(), null, model, cycleDetection));
    }

    @Override
    public PlanNode getAllAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        return this.paths.stream().map(p -> p.getAllAdded(connectionsGroup, dataGraph, planNodeWrapper)).reduce((xva$0, xva$1) -> UnionNode.getInstance(xva$0, xva$1)).orElse(EmptyNode.getInstance());
    }

    @Override
    public PlanNode getAnyAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        return this.getAllAdded(connectionsGroup, dataGraph, planNodeWrapper);
    }

    @Override
    public boolean isSupported() {
        for (Path path : this.paths) {
            if (path.isSupported()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toSparqlPathString() {
        return "(" + this.paths.stream().map(Path::toSparqlPathString).collect(Collectors.joining(" | ")) + ")";
    }

    @Override
    public SparqlFragment getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, Set<String> inheritedVarNames) {
        inheritedVarNames = inheritedVarNames.isEmpty() ? Set.of(subject.getName()) : Sets.union(inheritedVarNames, Set.of(subject.getName()));
        ArrayList<SparqlFragment> sparqlFragments = new ArrayList<SparqlFragment>(this.paths.size());
        for (Path path2 : this.paths) {
            SparqlFragment targetQueryFragment = path2.getTargetQueryFragment(subject, object, rdfsSubClassOfReasoner, stableRandomVariableProvider, (Set<String>)inheritedVarNames);
            sparqlFragments.add(targetQueryFragment);
        }
        return SparqlFragment.union(sparqlFragments, (connectionsGroup, dataGraph, path, currentStatementMatcher, currentStatements) -> sparqlFragments.stream().flatMap(sparqlFragment -> sparqlFragment.getRoot(connectionsGroup, dataGraph, path, currentStatementMatcher, currentStatements)).filter(EffectiveTarget.StatementsAndMatcher::hasStatements));
    }
}

