/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

@InternalUseOnly
public class ShaclAstLists {
    public static void listToRdf(Collection<? extends Value> values, Resource head, Model model) {
        Iterator<? extends Value> iter = values.iterator();
        while (iter.hasNext()) {
            Value value = iter.next();
            model.add(head, RDF.FIRST, value, new Resource[0]);
            if (iter.hasNext()) {
                BNode next = Values.bnode();
                model.add(head, RDF.REST, (Value)next, new Resource[0]);
                head = next;
                continue;
            }
            model.add(head, RDF.REST, (Value)RDF.NIL, new Resource[0]);
        }
    }

    private static List<Value> toList(ShapeSource shapeSource, Resource head) {
        ArrayList<Value> ret = new ArrayList<Value>();
        while (!RDF.NIL.equals((Object)head)) {
            Value value = shapeSource.getRdfFirst(head);
            ret.add(value);
            head = shapeSource.getRdfRest(head);
        }
        return ret;
    }

    public static <T extends Value> List<T> toList(ShapeSource shapeSource, Resource head, Class<T> type) {
        if (type == Value.class) {
            return ShaclAstLists.toList(shapeSource, head);
        }
        ArrayList<Value> ret = new ArrayList<Value>();
        while (!RDF.NIL.equals((Object)head)) {
            Value value = shapeSource.getRdfFirst(head);
            if (!type.isInstance(value)) {
                if (value == null) {
                    throw new IllegalStateException("RDF list node " + head + " does not have a value for rdf:first");
                }
                throw new IllegalStateException("RDF list should contain only type " + type.getSimpleName() + ", but found " + value.getClass().getSimpleName());
            }
            ret.add(value);
            head = shapeSource.getRdfRest(head);
        }
        return ret;
    }
}

