/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.config;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;

public class SPARQLRepositoryConfig
extends AbstractRepositoryImplConfig {
    private static final boolean USE_CONFIG = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.model.vocabulary.experimental.enableConfig"));
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final String NAMESPACE = "http://www.openrdf.org/config/repository/sparql#";
    public static final IRI QUERY_ENDPOINT = vf.createIRI("http://www.openrdf.org/config/repository/sparql#query-endpoint");
    public static final IRI UPDATE_ENDPOINT = vf.createIRI("http://www.openrdf.org/config/repository/sparql#update-endpoint");
    public static final IRI PASS_THROUGH_ENABLED = vf.createIRI("http://www.openrdf.org/config/repository/sparql#pass-through-enabled");
    private String queryEndpointUrl;
    private String updateEndpointUrl;
    private Boolean passThroughEnabled;

    public SPARQLRepositoryConfig() {
        super("openrdf:SPARQLRepository");
    }

    public SPARQLRepositoryConfig(String queryEndpointUrl) {
        this();
        this.setQueryEndpointUrl(queryEndpointUrl);
    }

    public SPARQLRepositoryConfig(String queryEndpointUrl, String updateEndpointUrl) {
        this(queryEndpointUrl);
        this.setUpdateEndpointUrl(updateEndpointUrl);
    }

    public String getQueryEndpointUrl() {
        return this.queryEndpointUrl;
    }

    public void setQueryEndpointUrl(String url) {
        this.queryEndpointUrl = url;
    }

    public String getUpdateEndpointUrl() {
        return this.updateEndpointUrl;
    }

    public void setUpdateEndpointUrl(String url) {
        this.updateEndpointUrl = url;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.getQueryEndpointUrl() == null) {
            throw new RepositoryConfigException("No endpoint URL specified for SPARQL repository");
        }
    }

    public Resource export(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace("sparql", NAMESPACE);
        if (this.getQueryEndpointUrl() != null) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Sparql.queryEndpoint, (Value)vf.createIRI(this.getQueryEndpointUrl()), new Resource[0]);
            } else {
                m.add(implNode, QUERY_ENDPOINT, (Value)vf.createIRI(this.getQueryEndpointUrl()), new Resource[0]);
            }
        }
        if (this.getUpdateEndpointUrl() != null) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Sparql.updateEndpoint, (Value)vf.createIRI(this.getUpdateEndpointUrl()), new Resource[0]);
            } else {
                m.add(implNode, UPDATE_ENDPOINT, (Value)vf.createIRI(this.getUpdateEndpointUrl()), new Resource[0]);
            }
        }
        if (this.getPassThroughEnabled() != null) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Sparql.passThroughEnabled, (Value)BooleanLiteral.valueOf((boolean)this.getPassThroughEnabled()), new Resource[0]);
            } else {
                m.add(implNode, PASS_THROUGH_ENABLED, (Value)BooleanLiteral.valueOf((boolean)this.getPassThroughEnabled()), new Resource[0]);
            }
        }
        return implNode;
    }

    public void parse(Model m, Resource implNode) throws RepositoryConfigException {
        super.parse(m, implNode);
        try {
            Configurations.getIRIValue((Model)m, (Resource)implNode, (IRI)CONFIG.Sparql.queryEndpoint, (IRI)QUERY_ENDPOINT).ifPresent(iri -> this.setQueryEndpointUrl(iri.stringValue()));
            Configurations.getIRIValue((Model)m, (Resource)implNode, (IRI)CONFIG.Sparql.updateEndpoint, (IRI)UPDATE_ENDPOINT).ifPresent(iri -> this.setUpdateEndpointUrl(iri.stringValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Sparql.passThroughEnabled, (IRI)PASS_THROUGH_ENABLED).ifPresent(lit -> this.setPassThroughEnabled(lit.booleanValue()));
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean getPassThroughEnabled() {
        return this.passThroughEnabled;
    }

    public void setPassThroughEnabled(Boolean passThroughEnabled) {
        this.passThroughEnabled = passThroughEnabled;
    }
}

