/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class ExternalFilterTargetIsSubject
extends FilterPlanNode {
    private final SailConnection connection;

    public ExternalFilterTargetIsSubject(SailConnection connection, PlanNode parent) {
        super(parent);
        this.connection = connection;
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value target = t.getActiveTarget();
        if (target.isResource()) {
            return this.connection.hasStatement((Resource)target, null, null, true, new Resource[0]);
        }
        return false;
    }

    @Override
    public String toString() {
        return "ExternalFilterTargetIsSubject{}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalFilterTargetIsSubject that = (ExternalFilterTargetIsSubject)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail());
        }
        return this.connection.equals(that.connection);
    }

    @Override
    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(super.hashCode(), ((MemoryStoreConnection)this.connection).getSail());
        }
        return Objects.hash(super.hashCode(), this.connection);
    }
}

