/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.Severity;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationReportNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;

public class ValidationQuery {
    private String query;
    private ConstraintComponent.Scope scope;
    private ConstraintComponent.Scope scope_validationReport;
    private final List<StatementMatcher.Variable> variables;
    private int targetIndex;
    private int valueIndex;
    private boolean propertyShapeWithValue;
    private boolean propertyShapeWithValue_validationReport;
    private int targetIndex_validationReport;
    private int valueIndex_validationReport;
    private SourceConstraintComponent constraintComponent;
    private SourceConstraintComponent constraintComponent_validationReport;
    private Severity severity;
    private Shape shape;

    public ValidationQuery(String query, List<StatementMatcher.Variable> targets, StatementMatcher.Variable value, ConstraintComponent.Scope scope, SourceConstraintComponent constraintComponent, Severity severity, Shape shape) {
        this.query = query;
        ArrayList<StatementMatcher.Variable> variables = new ArrayList<StatementMatcher.Variable>(targets);
        if (value != null) {
            variables.add(value);
        }
        this.variables = Collections.unmodifiableList(variables);
        if (scope == ConstraintComponent.Scope.propertyShape) {
            this.targetIndex = targets.size() - 1;
            if (value != null) {
                this.propertyShapeWithValue = true;
                this.valueIndex = variables.size() - 1;
            } else {
                this.propertyShapeWithValue = false;
                this.valueIndex = variables.size();
            }
        } else {
            this.targetIndex = variables.size() - 1;
            this.valueIndex = variables.size() - 1;
        }
        this.scope = scope;
        this.constraintComponent = constraintComponent;
        this.severity = severity;
        this.shape = shape;
    }

    public ValidationQuery(String query, ConstraintComponent.Scope scope, List<StatementMatcher.Variable> variables, int targetIndex, int valueIndex) {
        this.query = query;
        this.scope = scope;
        this.variables = Collections.unmodifiableList(variables);
        this.targetIndex = targetIndex;
        this.valueIndex = valueIndex;
    }

    public static ValidationQuery union(ValidationQuery a, ValidationQuery b) {
        if (a == Deactivated.instance) {
            return b;
        }
        if (b == Deactivated.instance) {
            return a;
        }
        assert (a.getTargetVariable(false).equals(b.getTargetVariable(false)));
        assert (a.getValueVariable(false).equals(b.getValueVariable(false)));
        assert (a.scope == b.scope);
        assert (a.targetIndex == b.targetIndex);
        assert (a.valueIndex == b.valueIndex);
        String unionQuery = "{\n" + a.getQuery() + "\n} UNION {\n" + b.query + "\n}";
        ValidationQuery validationQuery = new ValidationQuery(unionQuery, a.scope, a.variables.subList(0, a.valueIndex + 1), a.targetIndex, a.valueIndex);
        return validationQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public PlanNode getValidationPlan(SailConnection baseConnection) {
        assert (this.query != null);
        StringBuilder fullQuery = new StringBuilder();
        fullQuery.append("select distinct ");
        fullQuery.append("?").append(this.getTargetVariable(true)).append(" ");
        if (this.scope_validationReport == ConstraintComponent.Scope.propertyShape && this.propertyShapeWithValue_validationReport) {
            fullQuery.append("?").append(this.getValueVariable(true)).append(" ");
        }
        fullQuery.append("{\n").append(this.query).append("\n}");
        Select select = new Select(baseConnection, fullQuery.toString(), null, bindings -> {
            if (this.scope_validationReport == ConstraintComponent.Scope.propertyShape) {
                if (this.propertyShapeWithValue_validationReport) {
                    return new ValidationTuple(bindings.getValue(this.getTargetVariable(true)), bindings.getValue(this.getValueVariable(true)), this.scope_validationReport, true);
                }
                return new ValidationTuple(bindings.getValue(this.getTargetVariable(true)), this.scope_validationReport, false);
            }
            return new ValidationTuple(bindings.getValue(this.getTargetVariable(true)), this.scope_validationReport, true);
        });
        return new ValidationReportNode(select, t -> new ValidationResult(t.getActiveTarget(), t.getValue(), this.shape, this.constraintComponent_validationReport, this.severity, t.getScope()));
    }

    private String getValueVariable(boolean forValidationReport) {
        if (forValidationReport) {
            return this.variables.get((int)this.valueIndex_validationReport).name;
        }
        return this.variables.get((int)this.valueIndex).name;
    }

    private String getTargetVariable(boolean forValidationReport) {
        if (forValidationReport) {
            return this.variables.get((int)this.targetIndex_validationReport).name;
        }
        return this.variables.get((int)this.targetIndex).name;
    }

    public ValidationQuery withSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public ValidationQuery withShape(Shape shape) {
        this.shape = shape;
        return this;
    }

    public void popTargetChain() {
        assert (this.scope == ConstraintComponent.Scope.propertyShape);
        this.propertyShapeWithValue = true;
        --this.targetIndex;
        --this.valueIndex;
    }

    public void shiftToNodeShape() {
        this.scope = ConstraintComponent.Scope.nodeShape;
        this.propertyShapeWithValue = false;
        --this.valueIndex;
    }

    public void shiftToPropertyShape() {
        this.scope = ConstraintComponent.Scope.propertyShape;
        this.propertyShapeWithValue = true;
        --this.targetIndex;
    }

    public ValidationQuery withConstraintComponent(SourceConstraintComponent constraintComponent) {
        this.constraintComponent = constraintComponent;
        return this;
    }

    public void makeCurrentStateValidationReport() {
        this.valueIndex_validationReport = this.valueIndex;
        this.targetIndex_validationReport = this.targetIndex;
        this.scope_validationReport = this.scope;
        this.constraintComponent_validationReport = this.constraintComponent;
        this.propertyShapeWithValue_validationReport = this.propertyShapeWithValue;
    }

    static class Deactivated
    extends ValidationQuery {
        private static final Deactivated instance = new Deactivated();

        private Deactivated() {
            super("", Collections.emptyList(), null, null, null, null, null);
        }

        public static Deactivated getInstance() {
            return instance;
        }

        @Override
        public void setQuery(String query) {
            throw new IllegalStateException();
        }

        @Override
        public PlanNode getValidationPlan(SailConnection baseConnection) {
            return EmptyNode.getInstance();
        }

        @Override
        public ValidationQuery withSeverity(Severity severity) {
            return this;
        }

        @Override
        public ValidationQuery withShape(Shape shape) {
            return this;
        }

        @Override
        public void popTargetChain() {
        }

        @Override
        public void shiftToNodeShape() {
        }

        @Override
        public void shiftToPropertyShape() {
        }

        @Override
        public ValidationQuery withConstraintComponent(SourceConstraintComponent constraintComponent) {
            return this;
        }

        @Override
        public void makeCurrentStateValidationReport() {
        }
    }
}

