/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text.csv;

import com.opencsv.CSVReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.text.SPARQLResultsXSVMappingStrategy;

public class SPARQLResultsCSVMappingStrategy
extends SPARQLResultsXSVMappingStrategy {
    public SPARQLResultsCSVMappingStrategy(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public void captureHeader(CSVReader reader) throws IOException {
        this.bindingNames = Arrays.asList(reader.readNext());
    }

    public BindingSet populateNewBean(String[] line) {
        ArrayList<BNode> values = new ArrayList<BNode>(line.length);
        for (String valueString : line) {
            Value v = null;
            if (valueString.startsWith("_:")) {
                v = this.valueFactory.createBNode(valueString.substring(2));
            } else if (!"".equals(valueString)) {
                if (numberPattern.matcher(valueString).matches()) {
                    v = this.parseNumberPatternMatch(valueString);
                } else {
                    try {
                        v = this.valueFactory.createIRI(valueString);
                    }
                    catch (IllegalArgumentException e) {
                        v = this.valueFactory.createLiteral(valueString);
                    }
                }
            }
            values.add((BNode)v);
        }
        return new ListBindingSet((List<String>)this.bindingNames, values.toArray(new Value[values.size()]));
    }
}

