/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.ValueFactoryImpl;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.CrossProductIteration;

public class ZeroLengthPathIteration
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private static final int INITIAL_CAPACITY = 10000;
    private static final String ANON_SUBJECT_VAR = "zero-length-internal-start";
    private static final String ANON_PREDICATE_VAR = "zero-length-internal-pred";
    private static final String ANON_OBJECT_VAR = "zero-length-internal-end";
    private static final String ANON_SEQUENCE_VAR = "zero-length-internal-seq";
    private QueryBindingSet result;
    private Var subjectVar;
    private Var objVar;
    private Value subj;
    private Value obj;
    private BindingSet bindings;
    private CloseableIteration<BindingSet, QueryEvaluationException> iter;
    private Set<Value> reportedValues;
    private Var contextVar;
    private final EvaluationStrategy evaluationStrategy;

    public ZeroLengthPathIteration(EvaluationStrategy evaluationStrategyImpl, Var subjectVar, Var objVar, Value subj, Value obj, Var contextVar, BindingSet bindings) {
        this.evaluationStrategy = evaluationStrategyImpl;
        this.result = new QueryBindingSet(bindings);
        this.subjectVar = subjectVar;
        this.objVar = objVar;
        this.contextVar = contextVar;
        this.subj = subj;
        this.obj = obj;
        this.bindings = bindings;
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.subj == null && this.obj == null) {
            if (this.reportedValues == null) {
                this.reportedValues = this.makeSet();
            }
            if (this.iter == null) {
                QueryBindingSet bs1 = new QueryBindingSet(1);
                bs1.addBinding(ANON_SEQUENCE_VAR, ValueFactoryImpl.getInstance().createLiteral("subject"));
                QueryBindingSet bs2 = new QueryBindingSet(1);
                bs2.addBinding(ANON_SEQUENCE_VAR, ValueFactoryImpl.getInstance().createLiteral("object"));
                List<BindingSet> seqList = Arrays.asList(bs1, bs2);
                this.iter = new CrossProductIteration(this.createIteration(), seqList);
            }
            while (this.iter.hasNext()) {
                Value context;
                BindingSet bs;
                boolean isSubjOrObj = (bs = (BindingSet)this.iter.next()).getValue(ANON_SEQUENCE_VAR).stringValue().equals("subject");
                String endpointVarName = isSubjOrObj ? ANON_SUBJECT_VAR : ANON_OBJECT_VAR;
                Value v = bs.getValue(endpointVarName);
                if (!this.add(this.reportedValues, v)) continue;
                QueryBindingSet next = new QueryBindingSet(this.bindings);
                next.addBinding(this.subjectVar.getName(), v);
                next.addBinding(this.objVar.getName(), v);
                if (this.contextVar != null && (context = bs.getValue(this.contextVar.getName())) != null) {
                    next.addBinding(this.contextVar.getName(), context);
                }
                return next;
            }
            this.iter.close();
            this.reportedValues = null;
            return null;
        }
        if (this.result != null) {
            if (this.obj == null && this.subj != null) {
                this.result.addBinding(this.objVar.getName(), this.subj);
            } else if (this.subj == null && this.obj != null) {
                this.result.addBinding(this.subjectVar.getName(), this.obj);
            } else if (this.subj == null || !this.subj.equals(this.obj)) {
                this.result = null;
            }
        }
        QueryBindingSet next = this.result;
        this.result = null;
        return next;
    }

    protected boolean add(Set<Value> reportedValues2, Value v) throws QueryEvaluationException {
        return reportedValues2.add(v);
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
        Var startVar = this.createAnonVar(ANON_SUBJECT_VAR);
        Var predicate = this.createAnonVar(ANON_PREDICATE_VAR);
        Var endVar = this.createAnonVar(ANON_OBJECT_VAR);
        StatementPattern subjects = new StatementPattern(startVar, predicate, endVar);
        if (this.contextVar != null) {
            subjects.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
            subjects.setContextVar(this.contextVar);
        }
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluationStrategy.evaluate(subjects, this.bindings);
        return iter;
    }

    private Set<Value> makeSet() {
        return new HashSet<Value>(10000);
    }

    public Var createAnonVar(String varName) {
        Var var = new Var(varName);
        var.setAnonymous(true);
        return var;
    }
}

