/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class CompareOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new CompareVisitor());
    }

    protected static class CompareVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected CompareVisitor() {
        }

        @Override
        public void meet(Compare compare) {
            super.meet(compare);
            if (compare.getOperator() == Compare.CompareOp.EQ) {
                ValueExpr leftArg = compare.getLeftArg();
                ValueExpr rightArg = compare.getRightArg();
                boolean leftIsVar = this.isVar(leftArg);
                boolean rightIsVar = this.isVar(rightArg);
                boolean leftIsResource = this.isResource(leftArg);
                boolean rightIsResource = this.isResource(rightArg);
                if (leftIsVar && rightIsResource || leftIsResource && rightIsVar || leftIsResource && rightIsResource) {
                    SameTerm sameTerm = new SameTerm(leftArg, rightArg);
                    compare.replaceWith(sameTerm);
                }
            }
        }

        protected boolean isVar(ValueExpr valueExpr) {
            return valueExpr instanceof Var;
        }

        protected boolean isResource(ValueExpr valueExpr) {
            if (valueExpr instanceof ValueConstant) {
                Value value = ((ValueConstant)valueExpr).getValue();
                return value instanceof Resource;
            }
            if (valueExpr instanceof Var) {
                Value value = ((Var)valueExpr).getValue();
                return value instanceof Resource;
            }
            return false;
        }
    }
}

