/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;

public class ConsoleQueryResultWriter
extends AbstractQueryResultWriter {
    private final ConsoleIO consoleIO;
    private final int consoleWidth;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private List<String> bindingNames;
    private int columnWidth;
    private String separatorLine = "";
    private String header = "";
    private TupleQueryResultFormat queryResultFormat = new TupleQueryResultFormat("Console query result format", "application/x-dummy", "dummy", true);

    public ConsoleQueryResultWriter(ConsoleIO consoleIO, int consoleWidth) {
        this.consoleIO = consoleIO;
        this.consoleWidth = consoleWidth;
    }

    @Override
    public QueryResultFormat getQueryResultFormat() {
        return this.queryResultFormat;
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
        this.namespaces.put(uri, prefix);
    }

    @Override
    public void startDocument() throws QueryResultHandlerException {
    }

    @Override
    public void handleStylesheet(String stylesheetUrl) throws QueryResultHandlerException {
    }

    @Override
    public void startHeader() throws QueryResultHandlerException {
    }

    @Override
    public void endHeader() throws QueryResultHandlerException {
        this.consoleIO.writeln(this.separatorLine);
        this.consoleIO.writeln(this.header);
        this.consoleIO.writeln(this.separatorLine);
    }

    @Override
    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        this.consoleIO.writeln("Answer: " + value);
    }

    @Override
    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }

    @Override
    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        super.startQueryResult(bindingNames);
        this.bindingNames = bindingNames;
        int columns = bindingNames.size();
        this.columnWidth = (this.consoleWidth - 1) / columns - 3;
        StringBuilder builder = new StringBuilder(this.consoleWidth);
        for (int i = columns; i > 0; --i) {
            builder.append('+');
            StringUtil.appendN('-', this.columnWidth + 1, builder);
        }
        builder.append('+');
        this.separatorLine = builder.toString();
        builder = new StringBuilder(this.consoleWidth);
        for (String bindingName : bindingNames) {
            builder.append("| ").append(bindingName);
            StringUtil.appendN(' ', this.columnWidth - bindingName.length(), builder);
        }
        builder.append("|");
        this.header = builder.toString();
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        if (!this.separatorLine.isEmpty()) {
            this.consoleIO.writeln(this.separatorLine);
        }
    }

    @Override
    protected void handleSolutionImpl(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        StringBuilder builder = new StringBuilder(512);
        for (String bindingName : this.bindingNames) {
            Value value = bindingSet.getValue(bindingName);
            String valueStr = value != null ? Util.getPrefixedValue(value, this.namespaces) : "";
            builder.append("| ").append(valueStr);
            StringUtil.appendN(' ', this.columnWidth - valueStr.length(), builder);
        }
        builder.append("|");
        this.consoleIO.writeln(builder.toString());
    }
}

