/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.UnionSailDataset;

class UnionSailSource
implements SailSource {
    private final SailSource primary;
    private final SailSource additional;

    public UnionSailSource(SailSource primary, SailSource additional) {
        this.primary = primary;
        this.additional = additional;
    }

    public String toString() {
        return this.primary.toString() + "\n" + this.additional.toString();
    }

    @Override
    public void close() throws SailException {
        this.primary.close();
        this.additional.close();
    }

    @Override
    public SailSource fork() {
        return new UnionSailSource(this.primary.fork(), this.additional.fork());
    }

    @Override
    public void prepare() throws SailException {
        this.primary.prepare();
        this.additional.prepare();
    }

    @Override
    public void flush() throws SailException {
        this.primary.flush();
        this.additional.flush();
    }

    @Override
    public SailSink sink(IsolationLevel level) throws SailException {
        return this.primary.sink(level);
    }

    @Override
    public SailDataset dataset(IsolationLevel level) throws SailException {
        return new UnionSailDataset(this.primary.dataset(level), this.additional.dataset(level));
    }
}

