/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JSONLDHierarchicalProcessor {
    public static final String ID = "@id";
    public static final String GRAPH = "@graph";

    public static Object fromJsonLdObject(Object jsonLdObject) {
        return JSONLDHierarchicalProcessor.expandInDepth(jsonLdObject);
    }

    private static Object expandInDepth(Object input) {
        for (Map graph : (ArrayList)input) {
            if (!graph.containsKey(GRAPH)) continue;
            graph.compute(GRAPH, (key, o) -> JSONLDHierarchicalProcessor.expandContextInDepth(o));
        }
        return JSONLDHierarchicalProcessor.expandContextInDepth(input);
    }

    private static Object expandContextInDepth(Object input) {
        LinkedHashMap<String, Object> graph = new LinkedHashMap<String, Object>();
        ArrayList<Object> expanded = new ArrayList<Object>();
        for (Map jsonNode : (ArrayList)input) {
            if (jsonNode.containsKey(GRAPH)) {
                expanded.add(jsonNode);
                continue;
            }
            graph.put(jsonNode.get(ID).toString(), jsonNode);
        }
        LinkedList<TreeNode> frontier = new LinkedList<TreeNode>();
        HashSet<String> visited = new HashSet<String>();
        List<String> sortedNodes = JSONLDHierarchicalProcessor.getNodesOrder(graph);
        HashSet<String> children = new HashSet<String>();
        while (visited.size() < graph.size()) {
            Object rootNode = graph.get(JSONLDHierarchicalProcessor.getNextRoot(visited, sortedNodes));
            frontier.add(new TreeNode((Map)rootNode));
            expanded.add(rootNode);
            while (!frontier.isEmpty()) {
                TreeNode currentTreeNode = (TreeNode)frontier.removeLast();
                visited.add(currentTreeNode.getNodeID());
                Map currentNode = currentTreeNode.node;
                for (String predicate : currentNode.keySet()) {
                    Object object = currentNode.get(predicate);
                    if (!(object instanceof List)) continue;
                    ArrayList objectsPredSubjPairs = (ArrayList)object;
                    for (int i = 0; i < objectsPredSubjPairs.size(); ++i) {
                        String objectsPredId;
                        if (!(objectsPredSubjPairs.get(i) instanceof Map) || ((Map)objectsPredSubjPairs.get(i)).get(ID) == null || !graph.containsKey(objectsPredId = ((Map)objectsPredSubjPairs.get(i)).get(ID).toString()) || currentNode.get(ID).equals(objectsPredId) || currentTreeNode.hasPassedThrough(objectsPredId)) continue;
                        children.add(objectsPredId);
                        objectsPredSubjPairs.set(i, (Map)graph.get(objectsPredId));
                        frontier.add(new TreeNode((Map)objectsPredSubjPairs.get(i), currentTreeNode));
                    }
                }
            }
        }
        expanded.removeIf(o -> {
            if (o instanceof Map) {
                return children.contains(((Map)o).get(ID).toString());
            }
            return false;
        });
        return expanded;
    }

    private static String getNextRoot(Set<String> visited, List<String> sortedNodes) {
        while (!sortedNodes.isEmpty()) {
            String rootOffer = sortedNodes.remove(0);
            if (visited.contains(rootOffer)) continue;
            return rootOffer;
        }
        return null;
    }

    private static List<String> getNodesOrder(Map<String, Object> graph) {
        return graph.entrySet().stream().sorted(Map.Entry.comparingByValue((o1, o2) -> ((Map)o2).size() - ((Map)o1).size())).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
    }

    private static class TreeNode {
        private TreeNode parent;
        private Map<String, Object> node;

        public TreeNode(Map<String, Object> node) {
            this.node = node;
            this.parent = null;
        }

        public TreeNode(Map<String, Object> node, TreeNode parent) {
            this.parent = parent;
            this.node = node;
        }

        public String getNodeID() {
            return this.node.get(JSONLDHierarchicalProcessor.ID).toString();
        }

        public boolean hasPassedThrough(String nodeId) {
            TreeNode curr = this.parent;
            while (curr != null) {
                if (curr.getNodeID().equals(nodeId)) {
                    return true;
                }
                curr = curr.parent;
            }
            return false;
        }
    }
}

