/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iterator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.rdf4j.common.iterator.LookAheadIterator;
import org.eclipse.rdf4j.util.iterators.EmptyIterator;
import org.eclipse.rdf4j.util.iterators.Iterators;

public class UnionIterator<E>
extends LookAheadIterator<E> {
    private final Iterator<? extends Iterable<? extends E>> argIter;
    private volatile Iterator<? extends E> currentIter;

    public UnionIterator(Iterable<? extends E> ... args) {
        this((Iterable<Iterable<? extends E>>)Arrays.asList(args));
    }

    public UnionIterator(Iterable<? extends Iterable<? extends E>> args) {
        this.argIter = args.iterator();
        this.currentIter = new EmptyIterator<E>();
    }

    @Override
    protected E getNextElement() {
        if (this.currentIter.hasNext()) {
            return this.currentIter.next();
        }
        Iterators.closeSilently(this.currentIter);
        if (!this.argIter.hasNext()) {
            return null;
        }
        this.currentIter = this.argIter.next().iterator();
        return this.getNextElement();
    }

    @Override
    protected void handleClose() throws IOException {
        try {
            super.handleClose();
        }
        finally {
            Iterators.close(this.currentIter);
        }
    }
}

