/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.ecl.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class Q7EclParserPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.core.ecl.parser";
    private static Q7EclParserPlugin plugin;

    public static Q7EclParserPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static void log(IStatus status) {
        Q7EclParserPlugin.getDefault().getLog().log(status);
    }

    public static void log(CoreException e) {
        Q7EclParserPlugin.log(e.getStatus());
    }

    public static void logErr(String message, Throwable e) {
        Q7EclParserPlugin.log((IStatus)new Status(4, PLUGIN_ID, message, e));
    }

    public static void logErr(Throwable cause, String format, Object ... args) {
        Q7EclParserPlugin.log((IStatus)new Status(4, PLUGIN_ID, String.format(format, args)));
    }

    public static String readFile(String file) throws Exception {
        InputStream openStream = Q7EclParserPlugin.getInputStream(file);
        byte[] content = Q7EclParserPlugin.getContent(openStream);
        return new String(content).replace("\r\n", "\n");
    }

    public static InputStream getInputStream(String file) throws IOException {
        URL entry = Q7EclParserPlugin.getDefault().getBundle().getEntry(file);
        InputStream openStream = entry.openStream();
        return openStream;
    }

    public static byte[] getContent(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(100000);
        try (BufferedInputStream buffer = new BufferedInputStream(input);){
            byte[] bytes = new byte[8192];
            int length = 0;
            while ((length = buffer.read(bytes)) > 0) {
                output.write(bytes, 0, length);
            }
        }
        return output.toByteArray();
    }
}

