/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.builder;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.builder.IQ7Validator;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;

public class SameIDValidator
implements IQ7Validator {
    @Override
    public void validate(IQ7NamedElement element, IQ7ProblemReporter reporter, IProgressMonitor monitor) {
        try {
            IQ7NamedElement[] elements;
            String id = null;
            id = Q7SearchCore.findIDByDocument((IQ7Element)element);
            if (id == null) {
                id = element.getID();
            }
            if ((elements = Q7SearchCore.findById((String)id, (ISearchScope)new ReferencedProjectScope(element.getQ7Project()), (IProgressMonitor)monitor)) != null && elements.length > 1) {
                StringBuilder ress = new StringBuilder();
                reporter.reportProblem((IFile)element.getResource(), IQ7ProblemReporter.ProblemType.Error, "Duplicate IDs are detected: " + id + ress.toString(), 1, 0, 0, 0);
            }
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)e);
        }
    }

    @Override
    public void reconcile(IQ7NamedElement content, String eclCode, IQ7ProblemReporter reporter, IProgressMonitor nullProgressMonitor) {
    }
}

