/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.annotations;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.IStateDeltaListener;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={IClasspathContributor.class})
public class OSGiAnnotationsClasspathContributor
implements IClasspathContributor,
IStateDeltaListener {
    private static final int CHANGE_FLAGS = 7;
    private static final Collection<String> OSGI_ANNOTATIONS = List.of("org.osgi.annotation.versioning", "org.osgi.annotation.bundle", "org.osgi.service.component.annotations", "org.osgi.service.metatype.annotations");
    private final ConcurrentMap<String, Collection<IClasspathEntry>> entryMap = new ConcurrentHashMap<String, Collection<IClasspathEntry>>();

    @Override
    public List<IClasspathEntry> getInitialEntries(BundleDescription project) {
        IPluginModelBase projectModel = PluginRegistry.findModel((Resource)project);
        return OSGiAnnotationsClasspathContributor.annotations().map(bundleId -> this.entryMap.computeIfAbsent((String)bundleId, id -> ClasspathUtilCore.classpathEntriesForBundle(id).toList())).flatMap(Collection::stream).filter(Predicate.not(entry -> ClasspathUtilCore.isEntryForModel(entry, projectModel))).toList();
    }

    @Activate
    void registerListener() {
        PDECore.getDefault().getModelManager().addStateDeltaListener(this);
    }

    @Deactivate
    void undregisterListener() {
        PDECore.getDefault().getModelManager().removeStateDeltaListener(this);
    }

    public static Stream<String> annotations() {
        return OSGI_ANNOTATIONS.stream();
    }

    @Override
    public List<IClasspathEntry> getEntriesForDependency(BundleDescription project, BundleDescription addedDependency) {
        return Collections.emptyList();
    }

    @Override
    public void stateResolved(StateDelta delta) {
        if (delta == null) {
            this.stateChanged(null);
        } else {
            BundleDelta[] bundleDeltaArray = delta.getChanges(7, false);
            int n = bundleDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDelta bundleDelta = bundleDeltaArray[n2];
                this.entryMap.remove(bundleDelta.getBundle().getSymbolicName());
                ++n2;
            }
        }
    }

    @Override
    public void stateChanged(State newState) {
        this.entryMap.clear();
    }
}

