/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.model.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GetEditPartKind implements Enumerator
{
    PATH(0, "path", "by-path"),
    NAME(1, "name", "by-name"),
    CLASSNAME(2, "classname", "by-classname"),
    FEATURE(3, "feature", "by-feature");

    public static final int PATH_VALUE = 0;
    public static final int NAME_VALUE = 1;
    public static final int CLASSNAME_VALUE = 2;
    public static final int FEATURE_VALUE = 3;
    private static final GetEditPartKind[] VALUES_ARRAY;
    public static final List<GetEditPartKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GetEditPartKind[]{PATH, NAME, CLASSNAME, FEATURE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GetEditPartKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GetEditPartKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GetEditPartKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GetEditPartKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GetEditPartKind get(int value) {
        switch (value) {
            case 0: {
                return PATH;
            }
            case 1: {
                return NAME;
            }
            case 2: {
                return CLASSNAME;
            }
            case 3: {
                return FEATURE;
            }
        }
        return null;
    }

    private GetEditPartKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

