/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTreePart;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.ExportDestinationTab;
import org.eclipse.pde.internal.ui.wizards.exports.ExportOptionsTab;
import org.eclipse.pde.internal.ui.wizards.exports.JARSigningTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public abstract class BaseExportWizardPage
extends AbstractExportWizardPage {
    protected ExportPart fExportPart;
    private final IStructuredSelection fSelection;
    protected ExportDestinationTab fDestinationTab;
    protected ExportOptionsTab fOptionsTab;
    protected JARSigningTab fJARSiginingTab;
    protected TabFolder fTabFolder;

    public BaseExportWizardPage(IStructuredSelection selection, String name, String choiceLabel) {
        super(name);
        this.fSelection = selection;
        this.fExportPart = new ExportPart(choiceLabel, new String[]{PDEUIMessages.WizardCheckboxTablePart_selectAll, PDEUIMessages.WizardCheckboxTablePart_deselectAll, PDEUIMessages.ExportWizard_workingSet});
        this.setDescription(PDEUIMessages.ExportWizard_Plugin_description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.createViewer(container);
        this.fTabFolder = new TabFolder(container, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(768));
        this.createTabs(this.fTabFolder, this.getDialogSettings());
        this.initializeViewer();
        if (this.getErrorMessage() != null) {
            this.setMessage(this.getErrorMessage());
            this.setErrorMessage(null);
        }
        this.setControl((Control)container);
        this.hookHelpContext((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    protected void createTabs(TabFolder folder, IDialogSettings settings) {
        this.createDestinationTab(folder);
        this.createOptionsTab(folder);
        this.fDestinationTab.initialize(settings);
        this.fOptionsTab.initialize(settings);
        if (this.fOptionsTab.useJARFormat()) {
            this.createJARSigningTab(folder);
            this.fJARSiginingTab.initialize(settings);
        }
    }

    protected void createDestinationTab(TabFolder folder) {
        this.fDestinationTab = new ExportDestinationTab(this);
        TabItem item = new TabItem(folder, 0);
        item.setControl(this.fDestinationTab.createControl((Composite)folder));
        item.setText(PDEUIMessages.ExportWizard_destination);
    }

    protected void createOptionsTab(TabFolder folder) {
        this.fOptionsTab = new ExportOptionsTab(this);
        TabItem item = new TabItem(folder, 0);
        item.setControl(this.fOptionsTab.createControl((Composite)folder));
        item.setText(PDEUIMessages.ExportWizard_options);
    }

    protected void createJARSigningTab(TabFolder folder) {
        this.fJARSiginingTab = new JARSigningTab(this);
        TabItem item = new TabItem(folder, 0);
        item.setControl(this.fJARSiginingTab.createControl((Composite)folder));
        item.setText(PDEUIMessages.AdvancedPluginExportPage_signJar);
    }

    protected void createViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fExportPart.createControl(composite, 4, true);
        GridData gd = (GridData)this.fExportPart.getControl().getLayoutData();
        gd.heightHint = 125;
        gd.widthHint = 150;
        gd.horizontalSpan = 2;
        CachedCheckboxTreeViewer viewer = this.fExportPart.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new ExportListProvider());
        viewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        viewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        viewer.addDoubleClickListener(event -> {
            TreeItem firstTI = this.fExportPart.getTreeViewer().getTree().getSelection()[0];
            this.fExportPart.getTreeViewer().setChecked(firstTI.getData(), !firstTI.getChecked());
            this.fExportPart.updateCounterLabel();
        });
        Object input = this.getInput();
        if (input instanceof FeatureModelManager) {
            IFeatureModel[] models;
            FeatureModelManager fmm = (FeatureModelManager)input;
            IFeatureModel[] iFeatureModelArray = models = fmm.getWorkspaceModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureModel iFeatureModel = iFeatureModelArray[n2];
                if (iFeatureModel.getFeature().getId() == null) {
                    fmm.removeFromWorkspaceFeature(iFeatureModel);
                }
                ++n2;
            }
        }
        this.fExportPart.getTreeViewer().setInput(this.getInput());
    }

    protected abstract Object getInput();

    protected void initializeViewer() {
        HashSet<IModel> selected = new HashSet<IModel>();
        Object[] objectArray = this.fSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModel model;
            Object elem = objectArray[n2];
            IProject project = null;
            if (elem instanceof IFile) {
                IFile file = (IFile)elem;
                project = file.getProject();
            } else if (elem instanceof IProject) {
                project = (IProject)elem;
            } else if (elem instanceof IJavaProject) {
                project = ((IJavaProject)elem).getProject();
            }
            if (project != null && (model = this.findModelFor((IAdaptable)project)) != null && !selected.contains(model)) {
                selected.add(model);
            }
            ++n2;
        }
        ArrayList<IModel> checked = new ArrayList<IModel>(selected.size());
        Object[] objectArray2 = this.getListElements();
        int n3 = objectArray2.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray2[n];
            if (selected.contains(o)) {
                checked.add((IModel)o);
            }
            ++n;
        }
        this.fExportPart.setSelection(checked.toArray());
        if (!checked.isEmpty()) {
            this.fExportPart.getTreeViewer().reveal(checked.get(0));
        }
    }

    private void handleWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.getShell(), true);
        if (dialog.open() == 0) {
            IWorkingSet[] workingSets;
            HashSet<IModel> selected = new HashSet<IModel>();
            IWorkingSet[] iWorkingSetArray = workingSets = dialog.getSelection();
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable[] elements;
                IWorkingSet workingSet = iWorkingSetArray[n2];
                IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable element = iAdaptableArray[n4];
                    IModel model = this.findModelFor(element);
                    if (this.isValidModel(model)) {
                        selected.add(model);
                    }
                    ++n4;
                }
                ++n2;
            }
            ArrayList<IModel> checked = new ArrayList<IModel>(selected.size());
            Object[] objectArray = this.getListElements();
            int n5 = objectArray.length;
            n = 0;
            while (n < n5) {
                Object o = objectArray[n];
                if (selected.contains(o)) {
                    checked.add((IModel)o);
                }
                ++n;
            }
            this.fExportPart.setSelection(checked.toArray());
        }
    }

    public Object[] getSelectedItems() {
        return this.fExportPart.getSelection();
    }

    @Override
    protected void pageChanged() {
        String error;
        if (this.getMessage() != null) {
            this.setMessage(null);
        }
        if (this.fOptionsTab != null) {
            String path = this.fOptionsTab.getAntBuildFileName();
            String warningMessage = null;
            if (path != null && path.length() > 0 && "build.xml".equals(IPath.fromOSString((String)path).lastSegment())) {
                warningMessage = PDEUIMessages.ExportOptionsTab_antReservedMessage;
            }
            this.setMessage(warningMessage, 2);
        }
        String string = error = this.fExportPart.getSelectionCount() > 0 ? null : PDEUIMessages.ExportWizard_status_noselection;
        if (error == null) {
            error = this.validateTabs();
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    protected String validateTabs() {
        String message = this.fDestinationTab.validate();
        if (message == null) {
            message = this.fOptionsTab.validate();
        }
        if (message == null && this.fTabFolder.getItemCount() > 2) {
            message = this.fJARSiginingTab.validate();
        }
        return message;
    }

    protected abstract void hookHelpContext(Control var1);

    protected abstract boolean isValidModel(IModel var1);

    public abstract Object[] getListElements();

    protected abstract IModel findModelFor(IAdaptable var1);

    @Override
    protected void saveSettings(IDialogSettings settings) {
        this.fDestinationTab.saveSettings(settings);
        this.fOptionsTab.saveSettings(settings);
        if (this.fJARSiginingTab != null) {
            this.fJARSiginingTab.saveSettings(settings);
        }
    }

    protected boolean doExportToDirectory() {
        return this.fDestinationTab.doExportToDirectory();
    }

    protected String getFileName() {
        return this.fDestinationTab.getFileName();
    }

    protected String getDestination() {
        return this.fDestinationTab.getDestination();
    }

    protected boolean doInstall() {
        return this.fDestinationTab.doInstall();
    }

    protected boolean doExportSource() {
        return this.fOptionsTab.doExportSource();
    }

    protected boolean doExportSourceBundles() {
        return this.fOptionsTab.doExportSourceBundles();
    }

    protected boolean useJARFormat() {
        return this.fOptionsTab.useJARFormat();
    }

    protected boolean allowBinaryCycles() {
        return this.fOptionsTab.doBinaryCycles();
    }

    protected boolean useWorkspaceCompiledClasses() {
        return this.fOptionsTab.useWorkspaceCompiledClasses();
    }

    protected boolean doGenerateAntFile() {
        return this.fOptionsTab.doGenerateAntFile();
    }

    protected String getAntBuildFileName() {
        return this.fOptionsTab.getAntBuildFileName();
    }

    protected String getQualifier() {
        return this.fOptionsTab.getQualifier();
    }

    protected String[] getSigningInfo() {
        if (this.fJARSiginingTab == null || this.fTabFolder.getItemCount() < 3) {
            return null;
        }
        return this.fJARSiginingTab.getSigningInfo();
    }

    protected abstract void adjustAdvancedTabsVisibility();

    protected void adjustJARSigningTabVisibility() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.useJARFormat()) {
            if (this.fTabFolder.getItemCount() < 3) {
                this.createJARSigningTab(this.fTabFolder);
                this.fJARSiginingTab.initialize(settings);
            }
        } else if (this.fTabFolder.getItemCount() >= 3) {
            this.fJARSiginingTab.saveSettings(settings);
            this.fTabFolder.getItem(2).dispose();
        }
    }

    private class ExportListProvider
    implements ITreeContentProvider {
        private ExportListProvider() {
        }

        public Object[] getElements(Object parent) {
            return BaseExportWizardPage.this.getListElements();
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class ExportPart
    extends WizardCheckboxTreePart {
        public ExportPart(String label, String[] buttonLabels) {
            super(label, buttonLabels);
        }

        @Override
        public void updateCounterLabel() {
            super.updateCounterLabel();
            BaseExportWizardPage.this.pageChanged();
        }

        @Override
        protected void buttonSelected(Button button, int index) {
            switch (index) {
                case 0: {
                    this.handleSelectAll(true);
                    break;
                }
                case 1: {
                    this.handleSelectAll(false);
                    break;
                }
                case 2: {
                    BaseExportWizardPage.this.handleWorkingSets();
                }
            }
        }
    }
}

