/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import java.lang.reflect.Field;
import java.util.AbstractList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.core.protocol.GetPropertyValue;
import org.eclipse.rcptt.tesla.core.protocol.ObjectResponse;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.ecl.impl.rap.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.ecl.model.GetProperty;
import org.eclipse.rcptt.tesla.ecl.model.MessageBoxInfo;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.tesla.ecl.model.VerifyHandler;

public class GetPropertyService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        TeslaBridge.waitDelay();
        GetProperty gp = (GetProperty)command;
        EObject object = gp.getObject();
        if (object instanceof ControlHandler) {
            if (gp.isRaw()) {
                return this.serviceRawGet(gp, context);
            }
            VerifyHandler handler = TeslaFactory.eINSTANCE.createVerifyHandler();
            Element element = TeslaBridge.find((ControlHandler)object);
            handler.setElement(element);
            handler.setAttribute(gp.getName());
            handler.setIndex(gp.getIndex());
            context.getOutput().write((Object)handler);
            return Status.OK_STATUS;
        }
        if (object instanceof MessageBoxInfo) {
            MessageBoxInfo info = (MessageBoxInfo)object;
            try {
                Field field = info.getClass().getDeclaredField(gp.getName());
                field.setAccessible(true);
                context.getOutput().write((Object)field.get(info).toString());
            }
            catch (Exception exception) {
                return this.propertyGetError(gp.getName());
            }
            return Status.OK_STATUS;
        }
        return this.propertyGetError(gp.getName());
    }

    private IStatus propertyGetError(String name) {
        return TeslaImplPlugin.error(String.format("Failed to retrieve property '%s'", name));
    }

    private IStatus serviceRawGet(GetProperty gp, IProcess cx) throws CoreException {
        if (!(gp.getObject() instanceof ControlHandler)) {
            return this.propertyGetError(gp.getName());
        }
        GetPropertyValue gv = ProtocolFactory.eINSTANCE.createGetPropertyValue();
        gv.setElement(TeslaBridge.find((ControlHandler)gp.getObject()));
        gv.setIndex(gp.getIndex());
        gv.setName(gp.getName());
        gv.setAllowRawValues(Boolean.valueOf(true));
        Response response = TeslaBridge.getPlayer().safeExecuteCommand((org.eclipse.rcptt.tesla.core.protocol.raw.Command)gv);
        if (!(response instanceof ObjectResponse) || ((ObjectResponse)response).getResult() == null) {
            return this.propertyGetError(gp.getName());
        }
        ObjectResponse r = (ObjectResponse)response;
        if (r.getResult() instanceof IStatus) {
            return (IStatus)r.getResult();
        }
        if (r.getResult() instanceof AbstractList) {
            AbstractList data = (AbstractList)r.getResult();
            for (Object elem : data) {
                cx.getOutput().write(elem);
            }
        } else if (r.getResult() instanceof Object[]) {
            Object[] data;
            Object[] objectArray = data = (Object[])r.getResult();
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                Object elem = objectArray[n2];
                cx.getOutput().write(elem);
                ++n2;
            }
        } else {
            cx.getOutput().write(r.getResult());
        }
        cx.getOutput().close(Status.OK_STATUS);
        return Status.OK_STATUS;
    }
}

