/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.impl.rap;

import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.swt.dialogs.SWTDialogManager;
import org.eclipse.rcptt.tesla.ui.RWTUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class Utils {
    public static IStatus closeDialogs() {
        return Utils.doCloseDialogs();
    }

    private static IStatus doCloseDialogs() {
        SWTDialogManager.setCancelMessageBoxesDisplay((boolean)true);
        try {
            Display display = RWTUtils.findDisplay();
            IWorkbenchWindow[] windows = RWTUtils.getWorkbenchWindows();
            if (windows.length == 0) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            HashSet<Shell> windowShells = new HashSet<Shell>();
            IWorkbenchWindow[] iWorkbenchWindowArray = windows;
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                Shell shell = window.getShell();
                if (shell != null) {
                    windowShells.add(shell);
                }
                ++n2;
            }
            MultiStatus status = new MultiStatus("org.eclipse.rcptt.tesla.ecl.impl.rap", 0, "Failed to close dialogs", null);
            Shell[] shells = display.getShells();
            int i = shells.length - 1;
            while (i >= 0) {
                Shell shell = shells[i];
                if (!windowShells.contains(shell) && !shell.isDisposed() && shell.isVisible()) {
                    Object data = shell.getData();
                    if (data != null && data instanceof WizardDialog) {
                        try {
                            ProgressMonitorPart part;
                            WizardDialog dialog = (WizardDialog)data;
                            if (TeslaSWTAccess.getWizardDialogHasActiveOperations((WizardDialog)dialog) && (part = TeslaSWTAccess.getProgressMonitorPart((WizardDialog)dialog)) != null) {
                                part.setCanceled(true);
                                part.clearBlocked();
                            }
                            TeslaSWTAccess.setWizardDialogHasActiveOperations((WizardDialog)dialog, (long)0L);
                            dialog.close();
                        }
                        catch (Throwable e) {
                            TeslaCore.log((Throwable)e);
                        }
                    } else {
                        shell.close();
                    }
                    if (!shell.isDisposed() && shell.isVisible()) {
                        status.add((IStatus)new Status(4, "org.eclipse.rcptt.tesla.ecl.impl.rap", shell.getText()));
                    }
                }
                --i;
            }
            if (status.isOK()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            MultiStatus multiStatus = status;
            return multiStatus;
        }
        finally {
            SWTDialogManager.setCancelMessageBoxesDisplay((boolean)false);
        }
    }
}

