/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.workbench.impl.rap;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.scenario.Editor;
import org.eclipse.rcptt.core.scenario.FileEditor;
import org.eclipse.rcptt.core.scenario.ScenarioFactory;
import org.eclipse.rcptt.core.scenario.WorkbenchContext;
import org.eclipse.rcptt.ctx.workbench.impl.rap.Activator;
import org.eclipse.rcptt.tesla.ecl.impl.rap.UIRunnable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class ResourcesSupport {
    public static Object getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static void openEditors(IWorkbenchPage page, WorkbenchContext context) throws CoreException {
        for (Editor editor : context.getEditors()) {
            FileEditor fileEditor = (FileEditor)editor;
            Path path = new Path(fileEditor.getPath());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = (IFile)root.findMember((IPath)path);
            if (file == null) {
                IStatus status = Activator.createStatus("File '" + path + "' to open in editor wasn't found in workspace.", null);
                throw new CoreException(status);
            }
            UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                public Object run() throws CoreException {
                    return null;
                }
            });
        }
    }

    public static void fillEditors(IWorkbenchPage page, WorkbenchContext context) {
        IEditorReference[] editors;
        boolean closeOtherEditors = true;
        IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            FileEditor fileEditor = ResourcesSupport.createEditor(editor);
            if (fileEditor != null) {
                context.getEditors().add((Object)fileEditor);
            } else {
                closeOtherEditors = false;
            }
            ++n2;
        }
        context.setCloseEditors(closeOtherEditors);
    }

    private static FileEditor createEditor(IEditorReference editor) {
        IFile file = ResourcesSupport.getFile(editor);
        if (file == null) {
            return null;
        }
        FileEditor result = ScenarioFactory.eINSTANCE.createFileEditor();
        result.setPath(file.getFullPath().makeRelative().toString());
        return result;
    }

    private static IFile getFile(IEditorReference editor) {
        try {
            return ResourcesSupport.getFile(editor.getEditorInput());
        }
        catch (PartInitException e) {
            Activator.log(e);
            return null;
        }
    }

    private static IFile getFile(IEditorInput input) {
        try {
            return (IFile)input.getAdapter(IFile.class);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

