/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.IProgressMonitor;

public class PrintStreamMonitor
implements IProgressMonitor {
    private boolean isCanceled;
    private String prefix;
    private OutputStreamWriter out;
    private boolean stdoutDulicate = false;
    private String previousOutLine = "";

    public PrintStreamMonitor(boolean stdoutDuplicate) {
        this.prefix = "";
        this.stdoutDulicate = stdoutDuplicate;
    }

    public PrintStreamMonitor() {
        this.prefix = "";
        this.stdoutDulicate = false;
    }

    public PrintStreamMonitor(String prefix, File file) {
        this.prefix = prefix;
        if (file != null) {
            try {
                this.out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "utf-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void beginTask(String name, int totalWork) {
        if (name != null) {
            try {
                if (this.out != null) {
                    this.out.write("Begin task: " + this.prefix + name + "\n");
                    this.out.flush();
                }
                if (this.stdoutDulicate && this.filter(name)) {
                    System.out.println("Begin task: " + this.prefix + name);
                    this.previousOutLine = name;
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean filter(String name) {
        String nameVal = name.trim();
        if (nameVal.equals(this.previousOutLine)) {
            return false;
        }
        if (nameVal.length() == 0) {
            return false;
        }
        if (nameVal.contains("1 operation remaining.")) {
            return false;
        }
        if (nameVal.contains("from platform:///plugin/org.eclipse.rcptt.updates.")) {
            return false;
        }
        return !nameVal.contains("Fetching org.eclipse.rcptt") && !nameVal.contains("Downloading org.eclipse.rcptt");
    }

    private void print(String name) {
        if (name != null) {
            try {
                if (this.out != null) {
                    this.out.write("progress: " + this.prefix + name + "\n");
                    this.out.flush();
                }
                if (this.stdoutDulicate && this.filter(name)) {
                    System.out.println("progress: " + this.prefix + name);
                    this.previousOutLine = name;
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void done() {
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean value) {
        this.isCanceled = value;
    }

    public void setTaskName(String name) {
        this.print(name);
    }

    public void subTask(String name) {
        this.print(name);
    }

    public void worked(int work) {
    }
}

