/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.EclString;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.ecl.impl.rap.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.GetWidgetDetails;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.ui.PlatformUI;

public class GetWidgetDetailsService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        final GetWidgetDetails getPropertyNodes = (GetWidgetDetails)command;
        final IProcess finalContext = context;
        final IStatus[] resultStatus = new IStatus[]{Status.OK_STATUS};
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                EclString response = null;
                List processors = TeslaRecorder.getInstance().getProcessors(IRecordingProcessor.class);
                for (IRecordingProcessor processor : processors) {
                    IRecordingHelper recordingHelper = processor.getHelper();
                    if (recordingHelper == null) continue;
                    try {
                        String details = processor.getHelper().getWidgetDetails(getPropertyNodes.getElement());
                        if (details != null) {
                            response = BoxedValues.box((String)details);
                            break;
                        }
                    }
                    catch (Exception e) {
                        resultStatus[0] = TeslaImplPlugin.err("Failed to get widget details", e);
                        return;
                    }
                    if (response != null) break;
                }
                try {
                    if (response == null) {
                        finalContext.getOutput().write((Object)BoxedValues.box((String)""));
                    } else {
                        finalContext.getOutput().write(response);
                    }
                }
                catch (CoreException e) {
                    resultStatus[0] = TeslaImplPlugin.err("Write output error.", e);
                    TeslaBridge.makeScreenshot(true, resultStatus[0].getMessage());
                }
            }
        });
        return resultStatus[0];
    }
}

