/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;

public abstract class Subscriber {
    private List<ISubscriberChangeListener> listeners = new ArrayList<ISubscriberChangeListener>(1);

    public abstract String getName();

    public abstract boolean isSupervised(IResource var1) throws TeamException;

    public abstract IResource[] members(IResource var1) throws TeamException;

    public abstract IResource[] roots();

    public abstract SyncInfo getSyncInfo(IResource var1) throws TeamException;

    public abstract IResourceVariantComparator getResourceComparator();

    public abstract void refresh(IResource[] var1, int var2, IProgressMonitor var3) throws TeamException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISubscriberChangeListener listener) {
        List<ISubscriberChangeListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISubscriberChangeListener listener) {
        List<ISubscriberChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void collectOutOfSync(IResource[] resources, int depth, SyncInfoSet set, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, 100 * resources.length);
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 100);
                subMonitor.beginTask(null, -1);
                this.collect(resource, depth, set, subMonitor);
                subMonitor.done();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTeamResourceChange(final ISubscriberChangeEvent[] deltas) {
        ISubscriberChangeListener[] allListeners;
        List<ISubscriberChangeListener> list = this.listeners;
        synchronized (list) {
            allListeners = this.listeners.toArray(new ISubscriberChangeListener[this.listeners.size()]);
        }
        ISubscriberChangeListener[] iSubscriberChangeListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            final ISubscriberChangeListener listener = iSubscriberChangeListenerArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.subscriberResourceChanged(deltas);
                }
            });
            ++n2;
        }
    }

    private void collect(IResource resource, int depth, SyncInfoSet set, IProgressMonitor monitor) {
        Policy.checkCanceled(monitor);
        if (resource.getType() != 1 && depth != 0) {
            try {
                IResource[] members;
                IResource[] iResourceArray = members = this.members(resource);
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    this.collect(member, depth == 2 ? 2 : 0, set, monitor);
                    ++n2;
                }
            }
            catch (TeamException e) {
                set.addError(new TeamStatus(4, "org.eclipse.team.core", 2, NLS.bind((String)Messages.SubscriberEventHandler_8, (Object[])new String[]{resource.getFullPath().toString(), e.getMessage()}), (Throwable)((Object)e), resource));
            }
        }
        monitor.subTask(NLS.bind((String)Messages.SubscriberEventHandler_2, (Object[])new String[]{resource.getFullPath().toString()}));
        try {
            SyncInfo info = this.getSyncInfo(resource);
            if (info == null || info.getKind() == 0) {
                set.remove(resource);
            } else {
                set.add(info);
            }
        }
        catch (TeamException e) {
            set.addError(new TeamStatus(4, "org.eclipse.team.core", 1, NLS.bind((String)Messages.SubscriberEventHandler_9, (Object[])new String[]{resource.getFullPath().toString(), e.getMessage()}), (Throwable)((Object)e), resource));
        }
        monitor.worked(1);
    }

    public IDiff getDiff(IResource resource) throws CoreException {
        SyncInfo info = this.getSyncInfo(resource);
        if (info == null || info.getKind() == 0) {
            return null;
        }
        return SyncInfoToDiffConverter.getDefault().getDeltaFor(info);
    }

    public void accept(ResourceTraversal[] traversals, IDiffVisitor visitor) throws CoreException {
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            this.accept(traversal.getResources(), traversal.getDepth(), visitor);
            ++n2;
        }
    }

    public void accept(IResource[] resources, int depth, IDiffVisitor visitor) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.accept(resource, depth, visitor);
            ++n2;
        }
    }

    private void accept(IResource resource, int depth, IDiffVisitor visitor) throws CoreException {
        IDiff node = this.getDiff(resource);
        if (node != null && node.getKind() != 0 && !visitor.visit(node)) {
            return;
        }
        if (depth != 0) {
            IResource[] members = this.members(resource);
            int newDepth = depth == 2 ? 2 : 0;
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                this.accept(member, newDepth, visitor);
                ++n2;
            }
        }
    }

    public void refresh(ResourceTraversal[] traversals, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, 100 * traversals.length);
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            this.refresh(traversal.getResources(), traversal.getDepth(), Policy.subMonitorFor(monitor, 100));
            ++n2;
        }
        monitor.done();
    }

    public int getState(ResourceMapping mapping, int stateMask, IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] traversals = mapping.getTraversals((ResourceMappingContext)new SubscriberResourceMappingContext(this, true), monitor);
        int[] direction = new int[1];
        int[] kind = new int[1];
        this.accept(traversals, diff -> {
            if (diff instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)diff;
                nArray[0] = direction[0] | twd.getDirection();
            }
            int diffKind = diff.getKind();
            if (kind[0] == 0) {
                nArray2[0] = diffKind;
            }
            if (kind[0] != diffKind) {
                nArray2[0] = 4;
            }
            return diffKind == 4;
        });
        return (direction[0] | kind[0]) & stateMask;
    }
}

