/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import java.io.EOFException;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.ecl.core.model.CreateContext;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.ecl.core.model.SetQ7Features;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class ContextSnapshotAction
extends Action {
    private final IQ7Editor<Context> editor;
    private boolean join = false;
    private IStatus status = Status.OK_STATUS;

    public ContextSnapshotAction(IQ7Editor<Context> editor) {
        this.setImageDescriptor(Images.getImageDescriptor("icons/camera.png"));
        this.setToolTipText(Messages.ContextSnapshotAction_ToolTip);
        this.editor = editor;
    }

    public void run() {
        EObject contextParam;
        final AutLaunch aut = LaunchUtils.selectAutLaunch();
        try {
            contextParam = this.editor.getCreateParam(aut);
        }
        catch (CoreException ex) {
            this.status = ex.getStatus();
            return;
        }
        Job job = new Job(Messages.ContextSnapshotAction_Job){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", 2);
                IContext context = (IContext)ContextSnapshotAction.this.editor.getElement();
                try {
                    ContextType type = context.getType();
                    monitor.worked(1);
                    final Context newContext = ContextSnapshotAction.createSnapshot(aut, type.getId(), contextParam);
                    if (newContext != null) {
                        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                ContextSnapshotAction.this.editor.copyContentFrom(newContext, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(operation, monitor);
                        monitor.done();
                    }
                }
                catch (InterruptedException interruptedException) {
                    ContextSnapshotAction.this.status = Status.CANCEL_STATUS;
                    return ContextSnapshotAction.this.status;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                catch (Exception e) {
                    return Q7UIPlugin.createStatus(e);
                }
                ContextSnapshotAction.this.status = Status.OK_STATUS;
                return ContextSnapshotAction.this.status;
            }
        };
        job.setUser(true);
        job.schedule();
        if (this.isJoin()) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isEnabled() {
        IContext context = (IContext)this.editor.getElement();
        try {
            ContextType type = context.getType();
            return type.canCreate();
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
            return false;
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public static Context createSnapshot(AutLaunch aut, String contextType, EObject param) throws CoreException, InterruptedException {
        if (aut == null) {
            aut = LaunchUtils.selectAutLaunch();
        }
        if (aut == null) {
            return null;
        }
        if (!Q7LaunchManager.getInstance().cancelDebugExecution(aut, null)) {
            return null;
        }
        SetQ7Features setQ7Features = Q7CoreFactory.eINSTANCE.createSetQ7Features();
        TeslaFeatures.getInstance().storeValues((List)setQ7Features.getFeatures());
        Q7Features.getInstance().storeValues((List)setQ7Features.getFeatures());
        aut.execute((Command)setQ7Features);
        try {
            CreateContext cc = Q7CoreFactory.eINSTANCE.createCreateContext();
            cc.setType(contextType);
            cc.setParam(param);
            Object object = aut.execute((Command)cc);
            if (!(object instanceof Context)) {
                throw new CoreException(Q7UIPlugin.createStatus(Messages.bind((String)Messages.ContextSnapshotAction_UnexpectedObject, (Object)object)));
            }
            Context context = (Context)object;
            ContextType type = ContextTypeManager.getInstance().getTypeByContext(context);
            if (type == null || !contextType.equals(type.getId())) {
                throw new CoreException(Q7UIPlugin.createStatus(Messages.bind((String)Messages.ContextSnapshotAction_UnexpectedContextType, (Object)type, (Object)contextType)));
            }
            return context;
        }
        catch (CoreException e) {
            if (e.getStatus().getException() instanceof EOFException) {
                ContextSnapshotAction.showPossibleMemoryError();
                return null;
            }
            throw e;
        }
    }

    private static void showPossibleMemoryError() {
        Q7UIPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox msg = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
                msg.setText(Messages.ContextSnapshotAction_ErrorDialogTitle);
                msg.setMessage(Messages.ContextSnapshotAction_ErrorDialogMsg);
                msg.open();
            }
        });
    }
}

