/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.testrail;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.eclipse.rcptt.testrail.domain.TestRailTestCase;

public class TestRailParser {
    public static void parseTestCases(List<TestRailTestCase> testCases, JsonArray array) {
        for (JsonElement element : array) {
            TestRailTestCase testCase;
            if (!(element instanceof JsonObject)) continue;
            JsonObject object = (JsonObject)element;
            StringBuilder textSb = new StringBuilder();
            StringBuilder htmlSb = new StringBuilder();
            String id = "";
            for (Map.Entry entry : object.entrySet()) {
                JsonElement valueElement = (JsonElement)entry.getValue();
                if (valueElement == null || valueElement.toString().equals("") || valueElement.toString().equals("[]") || valueElement.toString().equals("null")) continue;
                String name = (String)entry.getKey();
                String value = valueElement.toString();
                block11 : switch (name) {
                    case "id": {
                        id = value;
                        break;
                    }
                    default: {
                        if (name.startsWith("custom_")) {
                            name = name.substring(7);
                        }
                        name = name.replaceAll("_", " ");
                        String firstChar = name.substring(0, 1);
                        firstChar = firstChar.toUpperCase();
                        name = String.valueOf(firstChar) + name.substring(1);
                        if (textSb.length() > 0) {
                            textSb.append("\n");
                        }
                        textSb.append(String.valueOf(name) + ": ");
                        if (htmlSb.length() > 0) {
                            htmlSb.append("<br>");
                        }
                        htmlSb.append("<b>");
                        htmlSb.append(String.valueOf(name) + ": ");
                        htmlSb.append("</b>");
                        switch (name) {
                            case "Created on": 
                            case "Updated on": {
                                DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm");
                                LocalDateTime localDate = LocalDateTime.ofInstant(Instant.ofEpochSecond(Integer.valueOf(value).intValue()), ZoneId.systemDefault());
                                value = dateFormatter.format(localDate);
                                textSb.append(value);
                                htmlSb.append(value);
                                break block11;
                            }
                        }
                        TestRailParser.parseTestCaseCustomAttribute(valueElement, textSb, htmlSb);
                    }
                    case "suite_id": 
                    case "type_id": 
                    case "updated_by": 
                    case "priority_id": 
                    case "section_id": 
                    case "milestone_id": 
                    case "created_by": 
                    case "template_id": 
                }
            }
            String testCaseId = id;
            if (textSb.length() <= 0 || htmlSb.length() <= 0 || testCaseId.equals("") || (testCase = (TestRailTestCase)testCases.stream().filter(tcase -> testCaseId.equals(tcase.getId())).findFirst().orElse(null)) == null) continue;
            testCase.setTextDescription(textSb.toString());
            testCase.setHTMLDescription(htmlSb.toString());
        }
    }

    private static String parseTestCaseCustomAttribute(JsonElement element, StringBuilder textSb, StringBuilder htmlSb) {
        if (element == null || element.toString().equals("") || element.toString().equals("null")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (element instanceof JsonPrimitive) {
            String value = element.toString();
            value = value.replaceAll("\"", "");
            value = value.replaceAll("\\\\r", "\r");
            if ((value = value.replaceAll("\\\\n", "\n")).contains("\n")) {
                textSb.append("\n");
            }
            textSb.append(value);
            value = value.replaceAll("\r", "");
            value = value.replaceAll("\n", "<br>");
            if (value.contains("<br>")) {
                htmlSb.append("<br>");
            }
            htmlSb.append(value);
        } else if (element instanceof JsonObject) {
            JsonObject object = (JsonObject)element;
            StringBuilder subTextSb = new StringBuilder();
            StringBuilder subHtmlSb = new StringBuilder();
            for (Map.Entry subEntry : object.entrySet()) {
                if (subEntry.getValue() == null) continue;
                if (subTextSb.length() > 0) {
                    subTextSb.append(", ");
                }
                subTextSb.append(String.valueOf(((String)subEntry.getKey()).toString()) + ": ");
                if (subHtmlSb.length() > 0) {
                    subHtmlSb.append(", ");
                }
                subHtmlSb.append("<i>");
                subHtmlSb.append(String.valueOf(((String)subEntry.getKey()).toString()) + ": ");
                subHtmlSb.append("</i>");
                TestRailParser.parseTestCaseCustomAttribute((JsonElement)subEntry.getValue(), subTextSb, subHtmlSb);
            }
            textSb.append(subTextSb.toString());
            htmlSb.append(subHtmlSb.toString());
        } else if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            int i = 1;
            htmlSb.append("<ol>");
            for (JsonElement subElement : array) {
                textSb.append("\n");
                textSb.append(String.valueOf(i) + ". ");
                htmlSb.append("<li>");
                TestRailParser.parseTestCaseCustomAttribute(subElement, textSb, htmlSb);
                ++i;
                htmlSb.append("</li>");
            }
            htmlSb.append("</ol>");
        }
        return sb.toString();
    }
}

