/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.tesla.core.ui.Image;
import org.eclipse.rcptt.tesla.core.utils.WidgetModels;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.verification.WidgetVerificationEditor;
import org.eclipse.rcptt.verifications.status.TreeItemVerificationError;
import org.eclipse.rcptt.verifications.tree.Cell;
import org.eclipse.rcptt.verifications.tree.Column;
import org.eclipse.rcptt.verifications.tree.Row;
import org.eclipse.rcptt.verifications.tree.Tree;
import org.eclipse.rcptt.verifications.tree.TreePackage;
import org.eclipse.rcptt.verifications.tree.TreeVerification;
import org.eclipse.rcptt.verifications.tree.TreeVerificationUtils;
import org.eclipse.rcptt.verifications.tree.VerifyStyleType;
import org.eclipse.rcptt.verifications.tree.VerifyTreeData;
import org.eclipse.rcptt.verifications.tree.ui.VerificationTreeContentProvider;
import org.eclipse.rcptt.verifications.tree.ui.VerificationTreeLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TreeVerificationEditor
extends WidgetVerificationEditor {
    public static final String ENABLED_COLUMNS_LABEL = "Enabled columns: %d/%d";
    Binding treeDataBinding = null;
    TreeTableObservable widgetObservable = null;
    Combo verifyStyleCombo = null;
    Label enabledColumnsLabel = null;

    public TreeVerification getVerificationElement() {
        try {
            return (TreeVerification)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        Section section = new SectionWithComposite("Widget Tree", 322).create(parent, toolkit);
        Composite client = (Composite)section.getClient();
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(-1, 16).applyTo(client);
        this.createWidgetControls(client, toolkit, site, header);
        Composite box = toolkit.createComposite(client);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)box);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(16, 4).applyTo(box);
        this.createControls(toolkit, box);
        header.getRecordButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Boolean defaultValue = (Boolean)TreePackage.Literals.VERIFY_TREE_DATA__ENABLE_VERIFY_STYLE.getDefaultValue();
                TreeVerificationEditor.this.getVerificationElement().setEnableVerifyStyle(defaultValue.booleanValue());
                TreeVerificationEditor.this.getVerificationElement().getExcludedColumns().clear();
                TreeVerificationEditor.this.enabledColumnsLabel.setText(TreeVerificationEditor.this.getEnabledColumnsLabel());
            }
        });
        return section;
    }

    private void createControls(FormToolkit toolkit, Composite client) {
        Composite propertiesComposite = toolkit.createComposite(client);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)propertiesComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(propertiesComposite);
        this.createPropertiesControls(toolkit, propertiesComposite);
        Composite controlsComposite = toolkit.createComposite(client);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)controlsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(controlsComposite);
        Label introLabel = toolkit.createLabel(controlsComposite, "Widget tree should be:");
        introLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        introLabel.setBackground(null);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)introLabel);
        this.enabledColumnsLabel = toolkit.createLabel(controlsComposite, this.getEnabledColumnsLabel());
        this.enabledColumnsLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.enabledColumnsLabel.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, false).align(131072, 0x1000000).applyTo((Control)this.enabledColumnsLabel);
        Composite treeComposite = toolkit.createComposite(client, 0x20000800);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeComposite);
        GridLayoutFactory.fillDefaults().applyTo(treeComposite);
        this.widgetObservable = new TreeTableObservable(treeComposite);
        this.treeDataBinding = this.dbc.bindValue((IObservableValue)this.widgetObservable, EMFObservables.observeValue((EObject)this.getVerificationElement(), (EStructuralFeature)TreePackage.Literals.COMMON_TREE_VERIFICATION_DATA__TREE));
    }

    private void createPropertiesControls(FormToolkit toolkit, Composite parent) {
        GridDataFactory align = GridDataFactory.fillDefaults().align(1, 0x1000000);
        Label verifyStyleLabel = toolkit.createLabel(parent, "Verify styles:");
        verifyStyleLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        verifyStyleLabel.setBackground(null);
        align.applyTo((Control)verifyStyleLabel);
        this.verifyStyleCombo = new Combo(parent, 12);
        int selectedStyleInd = 0;
        VerifyStyleType[] verifyStyleTypeArray = VerifyStyleType.values();
        int n = verifyStyleTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VerifyStyleType type = verifyStyleTypeArray[n2];
            this.verifyStyleCombo.add(type.getLiteral());
            if (type.getValue() == this.getVerificationElement().getVerifyStyle().getValue()) {
                selectedStyleInd = this.verifyStyleCombo.getItemCount() - 1;
            }
            ++n2;
        }
        this.verifyStyleCombo.select(selectedStyleInd);
        this.verifyStyleCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeVerificationEditor.this.getVerificationElement().setVerifyStyle(VerifyStyleType.get((String)TreeVerificationEditor.this.verifyStyleCombo.getText()));
                TreeVerificationEditor.this.widgetObservable.updateOutputFormat();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        align.applyTo((Control)this.verifyStyleCombo);
        Button unverifiedChildrenCheck = new Button(parent, 32);
        unverifiedChildrenCheck.setText("Allow uncaptured children");
        unverifiedChildrenCheck.setToolTipText("Tree items from verification without chirdren, may contain children in UI. This might happen when tree was not fully expanded during capturing.");
        this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)unverifiedChildrenCheck), EMFObservables.observeValue((EObject)this.getVerificationElement(), (EStructuralFeature)TreePackage.Literals.VERIFY_TREE_DATA__ALLOW_UNCAPTURED_CHILDREN));
        align.applyTo((Control)unverifiedChildrenCheck);
        Button verifyIconsCheck = new Button(parent, 32);
        verifyIconsCheck.setText("Verify icons");
        this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)verifyIconsCheck), EMFObservables.observeValue((EObject)this.getVerificationElement(), (EStructuralFeature)TreePackage.Literals.VERIFY_TREE_DATA__VERIFY_ICONS));
        verifyIconsCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeVerificationEditor.this.widgetObservable.updateOutputFormat();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        align.applyTo((Control)verifyIconsCheck);
    }

    public void select(Object data) {
        if (data instanceof TreeItemVerificationError) {
            TreeItemVerificationError err = (TreeItemVerificationError)data;
            this.widgetObservable.selectItemAt((List<Integer>)err.getItemIndexPath());
        }
    }

    public void setSelectionAtLine(int line) {
    }

    private String getEnabledColumnsLabel() {
        Tree tree = this.getVerificationElement().getTree();
        if (tree == null) {
            return String.format(ENABLED_COLUMNS_LABEL, 0, 0);
        }
        int totalColumnsCount = tree.getColumns().size();
        int excludedColumnsCount = this.getVerificationElement().getExcludedColumns().size();
        return String.format(ENABLED_COLUMNS_LABEL, totalColumnsCount - excludedColumnsCount, totalColumnsCount);
    }

    private static byte[] serializeImage(org.eclipse.swt.graphics.Image img) {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{img.getImageData()};
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        imageLoader.save((OutputStream)stream, 5);
        return stream.toByteArray();
    }

    private static org.eclipse.swt.graphics.Image deserializeImage(Display display, byte[] img) {
        ImageLoader imageLoader = new ImageLoader();
        ByteArrayInputStream stream = new ByteArrayInputStream(img);
        ImageData[] data = imageLoader.load((InputStream)stream);
        return new org.eclipse.swt.graphics.Image((Device)display, data[0]);
    }

    private class TreeTableObservable
    extends AbstractObservableValue {
        private Composite treeComposite = null;
        private TreeViewer viewer = null;
        private VerificationTreeLabelProvider labelProvider = null;
        private List<org.eclipse.swt.graphics.Image> columnImages = new ArrayList<org.eclipse.swt.graphics.Image>();

        public TreeTableObservable(Composite treeComposite) {
            this.treeComposite = treeComposite;
        }

        public void updateOutputFormat() {
            this.treeComposite.setRedraw(false);
            if (this.labelProvider != null) {
                this.labelProvider.setDrawIcons(TreeVerificationEditor.this.getVerificationElement().isVerifyIcons());
                this.labelProvider.setIgnoreStyle(TreeVerificationEditor.this.getVerificationElement().getVerifyStyle() == VerifyStyleType.IGNORE_STYLES);
                this.labelProvider.setSkipStyledText(TreeVerificationEditor.this.getVerificationElement().getVerifyStyle() == VerifyStyleType.IGNORE_STYLED_TEXT);
            }
            if (this.viewer != null) {
                TreeColumn[] cols = this.viewer.getTree().getColumns();
                if (TreeVerificationEditor.this.getVerificationElement().isVerifyIcons()) {
                    int i = 0;
                    while (i < cols.length) {
                        if (i < this.columnImages.size()) {
                            cols[i].setImage(this.columnImages.get(i));
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < cols.length) {
                        cols[i].setImage(null);
                        ++i;
                    }
                }
                this.viewer.refresh();
            }
            TreeVerificationEditor.this.verifyStyleCombo.setEnabled(TreeVerificationEditor.this.getVerificationElement().isEnableVerifyStyle());
            TreeVerificationEditor.this.enabledColumnsLabel.setText(TreeVerificationEditor.this.getEnabledColumnsLabel());
            this.treeComposite.setRedraw(true);
        }

        private TreePath toTreePath(List<Integer> indices) {
            List rows = (List)this.viewer.getInput();
            ArrayList<Row> segments = new ArrayList<Row>();
            for (int i : indices) {
                if (i < 0 || i >= rows.size()) break;
                Row curr = (Row)rows.get(i);
                segments.add(curr);
                rows = curr.getChildren();
            }
            return new TreePath(segments.toArray());
        }

        public void selectItemAt(List<Integer> itemIndexPath) throws IllegalArgumentException {
            if (this.viewer != null && this.viewer.getTree() != null && itemIndexPath.size() > 0) {
                TreePath treePath = this.toTreePath(itemIndexPath);
                this.viewer.setSelection((ISelection)new TreeSelection(treePath), true);
            }
        }

        public Object getValueType() {
            return null;
        }

        protected Object doGetValue() {
            return null;
        }

        protected void doSetValue(Object value) {
            if (value instanceof Tree) {
                Tree treeData = (Tree)value;
                Map<String, org.eclipse.swt.graphics.Image> images = this.deserializeImages(this.treeComposite.getDisplay(), (EMap<String, byte[]>)TreeVerificationEditor.this.getVerificationElement().getImages());
                this.treeComposite.setRedraw(false);
                this.viewer = this.createTreeWidget(this.treeComposite, treeData, images);
                if (treeData.getSortColumnInd() != -1) {
                    this.viewer.getTree().setSortColumn(this.viewer.getTree().getColumn(treeData.getSortColumnInd()));
                    this.viewer.getTree().setSortDirection(treeData.getSortDirection());
                }
                this.labelProvider = new VerificationTreeLabelProvider(images, TreeVerificationEditor.this.getVerificationElement().isVerifyIcons(), TreeVerificationEditor.this.getVerificationElement().getVerifyStyle() == VerifyStyleType.IGNORE_STYLES, TreeVerificationEditor.this.getVerificationElement().getVerifyStyle() == VerifyStyleType.IGNORE_STYLED_TEXT, (List<Integer>)TreeVerificationEditor.this.getVerificationElement().getExcludedColumns());
                this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
                this.viewer.setContentProvider((IContentProvider)new VerificationTreeContentProvider());
                this.viewer.setInput((Object)treeData.getRows());
                ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
                this.viewer.refresh();
                this.viewer.expandAll();
                TreeVerificationEditor.this.widgetObservable.updateOutputFormat();
                this.treeComposite.setRedraw(true);
            }
        }

        private Map<String, org.eclipse.swt.graphics.Image> deserializeImages(Display display, EMap<String, byte[]> images) {
            HashMap<String, org.eclipse.swt.graphics.Image> result = new HashMap<String, org.eclipse.swt.graphics.Image>();
            for (Map.Entry img : images.entrySet()) {
                result.put((String)img.getKey(), TreeVerificationEditor.deserializeImage(display, (byte[])img.getValue()));
            }
            return result;
        }

        private TreeViewer createTreeWidget(Composite parent, Tree treeData, Map<String, org.eclipse.swt.graphics.Image> images) {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            final TreeViewer viewer = new TreeViewer(parent, treeData.getStyle() | 0x10000);
            final org.eclipse.swt.widgets.Tree tree = viewer.getTree();
            tree.setEnabled(treeData.isEnabled());
            tree.setHeaderVisible(treeData.isHeaderVisible());
            tree.setLinesVisible(treeData.isLinesVisible());
            tree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 32 && event.item instanceof TreeItem) {
                        TreeItem item;
                        item.setChecked(!(item = (TreeItem)event.item).getChecked());
                    }
                }
            });
            TreeViewerEditor.create((TreeViewer)viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

                protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                    return super.isEditorActivationEvent(event) && TreeVerificationEditor.this.getVerificationElement().getVerifyStyle().getValue() == 2;
                }
            }, (int)1);
            String[] columnProperties = new String[treeData.getColumns().size()];
            CellEditor[] cellEditors = new CellEditor[treeData.getColumns().size()];
            final Menu excludedColumnsMenu = new Menu((Decorations)tree.getShell(), 8);
            int columnNum = 0;
            while (columnNum < treeData.getColumns().size()) {
                TreeViewerColumn column = new TreeViewerColumn(viewer, 0);
                boolean isExcludedColumn = TreeVerificationUtils.isExcludedColumn((VerifyTreeData)TreeVerificationEditor.this.getVerificationElement(), (int)columnNum);
                Column treeColumn = (Column)treeData.getColumns().get(columnNum);
                column.getColumn().setText(treeColumn.getName());
                column.getColumn().setWidth(treeColumn.getWidth());
                column.getColumn().setToolTipText(treeColumn.getTooltip());
                final int columnIndex = columnNum;
                final MenuItem excludedColumnItem = new MenuItem(excludedColumnsMenu, 32);
                excludedColumnItem.setText(treeColumn.getName());
                excludedColumnItem.setSelection(!isExcludedColumn);
                excludedColumnItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean isExcludedColumn;
                        boolean bl = isExcludedColumn = !excludedColumnItem.getSelection();
                        if (isExcludedColumn) {
                            TreeVerificationUtils.addExcludedColumn((VerifyTreeData)TreeVerificationEditor.this.getVerificationElement(), (int)columnIndex);
                        } else {
                            TreeVerificationUtils.removeExcludedColumn((VerifyTreeData)TreeVerificationEditor.this.getVerificationElement(), (int)columnIndex);
                        }
                        ((TreeTableObservable)TreeTableObservable.this).TreeVerificationEditor.this.enabledColumnsLabel.setText(TreeVerificationEditor.this.getEnabledColumnsLabel());
                        viewer.refresh();
                    }
                });
                String imgPath = TreeVerificationUtils.getDecoratedImagePath((Image)treeColumn.getImage());
                if (images.containsKey(imgPath)) {
                    org.eclipse.swt.graphics.Image img = images.get(imgPath);
                    this.columnImages.add(img);
                    if (TreeVerificationEditor.this.getVerificationElement().isVerifyIcons()) {
                        column.getColumn().setImage(img);
                    }
                } else {
                    this.columnImages.add(null);
                }
                column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
                columnProperties[columnNum] = "" + columnNum;
                cellEditors[columnNum] = new TextCellEditor((Composite)tree);
                ++columnNum;
            }
            tree.addListener(35, new Listener(){

                public void handleEvent(Event event) {
                    Point cursor = tree.getDisplay().map(null, (Control)tree, new Point(event.x, event.y));
                    Rectangle clientArea = tree.getClientArea();
                    boolean isClickInHeader = clientArea.y <= cursor.y && cursor.y < clientArea.y + tree.getHeaderHeight();
                    tree.setMenu(isClickInHeader ? excludedColumnsMenu : null);
                }
            });
            tree.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    excludedColumnsMenu.dispose();
                }
            });
            if (treeData.getColumns().size() == 0) {
                viewer.setColumnProperties(new String[]{"0"});
                viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)tree)});
            } else {
                viewer.setColumnProperties(columnProperties);
                viewer.setCellEditors(cellEditors);
            }
            viewer.setCellModifier(new ICellModifier(){

                public void modify(Object element, String property, Object value) {
                    String newValue = (String)value;
                    int index = Integer.parseInt(property);
                    if (((TreeItem)element).getData() instanceof Row) {
                        Cell cellItem = (Cell)((Row)((TreeItem)element).getData()).getValues().get(index);
                        if (newValue != null && !cellItem.getData().getText().equals(newValue)) {
                            cellItem.getData().setText(newValue);
                            cellItem.getStyle().clear();
                            TreeVerificationEditor.this.getVerificationElement().setEnableVerifyStyle(false);
                            TreeTableObservable.this.updateOutputFormat();
                        }
                    }
                }

                public Object getValue(Object element, String property) {
                    String result = "";
                    if (element instanceof Row) {
                        int index = Integer.parseInt(property);
                        Cell cellItem = (Cell)((Row)element).getValues().get(index);
                        result = WidgetModels.getTextWithoutStyle((Iterable)cellItem.getStyle(), (String)cellItem.getData().getText());
                    }
                    return result;
                }

                public boolean canModify(Object element, String property) {
                    return TreeVerificationEditor.this.getVerificationElement().getVerifyStyle().getValue() == 2;
                }
            });
            GridDataFactory.fillDefaults().grab(true, true).hint(100, 10).applyTo((Control)viewer.getTree());
            parent.layout(true, true);
            return viewer;
        }
    }
}

