/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ProjectSelectionDialog
extends SelectionStatusDialog {
    private TableViewer fTableViewer;
    Set<?> fProjectsWithSpecifics;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private static final String DIALOG_SETTINGS_SHOW_ALL = "ProjectSelectionDialog.show_all";
    private ViewerFilter fFilter;

    public ProjectSelectionDialog(Shell parentShell, Set<?> projectsWithSpecifics) {
        super(parentShell);
        this.setTitle(PreferenceMessages.ProjectSelectionDialog_title);
        this.setMessage(PreferenceMessages.ProjectSelectionDialog_message);
        this.fProjectsWithSpecifics = projectsWithSpecifics;
        this.fFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ProjectSelectionDialog.this.fProjectsWithSpecifics.contains(element);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.createMessageArea(composite);
        this.fTableViewer = new TableViewer(composite, 2816);
        this.fTableViewer.addSelectionChangedListener(event -> this.doSelectionChanged(event.getStructuredSelection().toArray()));
        this.fTableViewer.addDoubleClickListener(event -> this.okPressed());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new ApiJavaElementContentProvider());
        this.fTableViewer.setComparator((ViewerComparator)new JavaElementComparator());
        this.fTableViewer.getControl().setFont(font);
        Button checkbox = SWTFactory.createCheckButton(composite, PreferenceMessages.ProjectSelectionDialog_checkbox_text, null, false, 1);
        checkbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.updateFilter(((Button)e.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.updateFilter(((Button)e.widget).getSelection());
            }
        });
        IDialogSettings dialogSettings = ApiUIPlugin.getDefault().getDialogSettings();
        boolean doFilter = !dialogSettings.getBoolean(DIALOG_SETTINGS_SHOW_ALL) && !this.fProjectsWithSpecifics.isEmpty();
        checkbox.setSelection(doFilter);
        this.updateFilter(doFilter);
        IJavaModel input = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.fTableViewer.setInput((Object)input);
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IApiToolsHelpContextIds.APITOOLS_PROJECT_SPECIFIC_SETTINGS_SELECTION_DIALOG);
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    void doSelectionChanged(Object[] objects) {
        if (objects.length != 1) {
            this.updateStatus((IStatus)new Status(4, ApiUIPlugin.getPluginIdentifier(), ""));
            this.setSelectionResult(null);
        } else {
            this.updateStatus((IStatus)new Status(0, ApiUIPlugin.getPluginIdentifier(), ""));
            this.setSelectionResult(objects);
        }
    }

    protected void updateFilter(boolean selected) {
        if (selected) {
            this.fTableViewer.addFilter(this.fFilter);
        } else {
            this.fTableViewer.removeFilter(this.fFilter);
        }
        ApiUIPlugin.getDefault().getDialogSettings().put(DIALOG_SETTINGS_SHOW_ALL, !selected);
    }

    protected void computeResult() {
    }

    static class ApiJavaElementContentProvider
    extends StandardJavaElementContentProvider {
        ApiJavaElementContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IJavaModel) {
                IJavaModel model = (IJavaModel)element;
                HashSet<IJavaProject> set = new HashSet<IJavaProject>();
                try {
                    IJavaProject[] projects;
                    IJavaProject[] iJavaProjectArray = projects = model.getJavaProjects();
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaProject project = iJavaProjectArray[n2];
                        if (project.getProject().hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) {
                            set.add(project);
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {
                }
                catch (CoreException coreException) {}
                return set.toArray();
            }
            return super.getChildren(element);
        }
    }
}

