/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.loadtime.definition.DocumentParser;
import org.eclipse.equinox.weaving.aspectj.AspectAdmin;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;

public class AspectAdminImpl
implements AspectAdmin,
SynchronousBundleListener {
    private final Map<Bundle, Definition> aspectDefinitions = new ConcurrentHashMap<Bundle, Definition>();
    private final Map<Bundle, Definition> aspectDefinitionsExported = new ConcurrentHashMap<Bundle, Definition>();
    private final Map<Bundle, Map<String, Integer>> aspectPolicies = new ConcurrentHashMap<Bundle, Map<String, Integer>>();

    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() == 32) {
            this.bundleResolved(bundleEvent.getBundle());
        } else if (bundleEvent.getType() == 64) {
            this.bundleUnresolved(bundleEvent.getBundle());
        }
    }

    public void bundleResolved(Bundle bundle) {
        if (!(this.aspectDefinitions.containsKey(bundle) || this.aspectDefinitionsExported.containsKey(bundle) || this.aspectPolicies.containsKey(bundle))) {
            this.parseDefinitions(bundle);
        }
    }

    public void bundleUnresolved(Bundle bundle) {
        this.aspectDefinitions.remove(bundle);
        this.aspectDefinitionsExported.remove(bundle);
        this.aspectPolicies.remove(bundle);
    }

    public Definition getAspectDefinition(Bundle bundle) {
        return this.aspectDefinitions.get(bundle);
    }

    public int getAspectPolicy(Bundle bundle, String string) {
        Integer n;
        Map<String, Integer> map = this.aspectPolicies.get(bundle);
        if (map != null && (n = map.get(string)) != null) {
            return n;
        }
        return 0;
    }

    public String getDefinitionLocation(Bundle bundle) {
        String string = (String)bundle.getHeaders().get("Eclipse-AspectContext");
        if (string != null) {
            string = string.trim();
            return string;
        }
        return "META-INF/aop.xml";
    }

    public Definition getExportedAspectDefinitions(Bundle bundle) {
        return this.aspectDefinitionsExported.get(bundle);
    }

    public void initialize(Bundle[] bundleArray) {
        Bundle[] bundleArray2 = bundleArray;
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray2[n2];
            int n3 = bundle.getState();
            if (n3 != 2 && n3 != 1) {
                this.parseDefinitions(bundle);
            }
            ++n2;
        }
    }

    public Definition resolveImportedPackage(Bundle bundle, String string, int n) {
        if (1 == n) {
            Definition definition = this.getExportedAspectDefinitions(bundle);
            Definition definition2 = new Definition();
            if (definition != null) {
                List list = definition.getAspectClassNames();
                for (String string2 : list) {
                    String string3 = this.getPackage(string2);
                    if (!string3.equals(string)) continue;
                    definition2.getAspectClassNames().add(string2);
                }
                for (String string2 : definition.getConcreteAspects()) {
                    if (((Definition.ConcreteAspect)string2).name == null || !this.getPackage(((Definition.ConcreteAspect)string2).name).equals(string)) continue;
                    definition2.getConcreteAspects().add(string2);
                }
                if (definition.getWeaverOptions().trim().length() > 0) {
                    definition2.appendWeaverOptions(definition.getWeaverOptions());
                }
            }
            if (definition2.getAspectClassNames().size() > 0 || definition2.getConcreteAspects().size() > 0 || definition2.getWeaverOptions().length() > 0) {
                return definition2;
            }
            return null;
        }
        if (2 == n) {
            return null;
        }
        Definition definition = this.getExportedAspectDefinitions(bundle);
        Definition definition3 = new Definition();
        if (definition != null) {
            int n2;
            String string4;
            List list = definition.getAspectClassNames();
            for (String string5 : list) {
                string4 = this.getPackage(string5);
                n2 = this.getAspectPolicy(bundle, string4);
                if (!string4.equals(string) || n2 != 0 && 2 != n2) continue;
                definition3.getAspectClassNames().add(string5);
            }
            for (String string5 : definition.getConcreteAspects()) {
                string4 = this.getPackage(((Definition.ConcreteAspect)string5).name);
                n2 = this.getAspectPolicy(bundle, string4);
                if (!string4.equals(string) || n2 != 0 && 2 != n2) continue;
                definition3.getConcreteAspects().add(string5);
            }
            if (definition.getWeaverOptions().trim().length() > 0) {
                definition3.appendWeaverOptions(definition.getWeaverOptions());
            }
        }
        if (definition3.getAspectClassNames().size() > 0 || definition3.getConcreteAspects().size() > 0 || definition3.getWeaverOptions().length() > 0) {
            return definition3;
        }
        return null;
    }

    public Definition resolveRequiredBundle(Bundle bundle, int n) {
        if (1 == n) {
            return this.getExportedAspectDefinitions(bundle);
        }
        if (2 == n) {
            return null;
        }
        Definition definition = this.getExportedAspectDefinitions(bundle);
        Definition definition2 = new Definition();
        if (definition != null) {
            for (Object object : definition.getAspectClassNames()) {
                String string = this.getPackage((String)object);
                int n2 = this.getAspectPolicy(bundle, string);
                if (n2 != 0 && n2 != 2) continue;
                definition2.getAspectClassNames().add(object);
            }
            for (String string : definition.getConcreteAspects()) {
                String string2 = this.getPackage(((Definition.ConcreteAspect)string).name);
                int n3 = this.getAspectPolicy(bundle, string2);
                if (n3 != 0 && n3 != 2) continue;
                definition2.getConcreteAspects().add(string);
            }
            if (definition.getWeaverOptions().trim().length() > 0) {
                definition2.appendWeaverOptions(definition.getWeaverOptions());
            }
        }
        if (definition2.getAspectClassNames().size() > 0 || definition2.getConcreteAspects().size() > 0 || definition2.getWeaverOptions().length() > 0) {
            return definition2;
        }
        return null;
    }

    protected void parseDefinitions(Bundle bundle) {
        try {
            String string;
            Definition definition = null;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            HashSet<String> hashSet2 = new HashSet<String>();
            String string2 = this.getDefinitionLocation(bundle);
            URL uRL = bundle.getEntry(string2);
            if (uRL != null) {
                definition = DocumentParser.parse((URL)uRL);
            }
            Dictionary dictionary = bundle.getHeaders();
            ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Export-Package", (String)((String)dictionary.get("Export-Package")));
            int n = 0;
            while (manifestElementArray != null && n < manifestElementArray.length) {
                String[] stringArray;
                String string3;
                String string4 = manifestElementArray[n].getValue();
                hashSet2.add(string4);
                string = manifestElementArray[n].getDirective("aspect-policy");
                if (string != null && string.trim().toLowerCase().equals("opt-out")) {
                    hashMap.put(string4, 2);
                }
                if (string != null && string.trim().toLowerCase().equals("opt-in")) {
                    hashMap.put(string4, 1);
                }
                if ((string3 = manifestElementArray[n].getAttribute("aspects")) != null && (stringArray = ManifestElement.getArrayFromList((String)string3)) != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        linkedHashSet.add(String.valueOf(string4) + "." + stringArray[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
            if (definition != null && definition.getAspectClassNames() != null) {
                for (String string4 : definition.getAspectClassNames()) {
                    string = this.getPackage(string4);
                    if (!hashSet2.contains(string)) continue;
                    linkedHashSet.add(string4);
                }
            }
            if (definition != null && definition.getConcreteAspects().size() > 0) {
                for (String string4 : definition.getConcreteAspects()) {
                    if (((Definition.ConcreteAspect)string4).name == null || !hashSet2.contains(this.getPackage(((Definition.ConcreteAspect)string4).name))) continue;
                    hashSet.add(string4);
                }
            }
            if (definition != null) {
                this.aspectDefinitions.put(bundle, definition);
            }
            if (linkedHashSet.size() > 0 || hashSet.size() > 0 || definition != null && definition.getWeaverOptions().length() > 0) {
                Definition definition2 = new Definition();
                definition2.getAspectClassNames().addAll(linkedHashSet);
                definition2.getConcreteAspects().addAll(hashSet);
                if (definition != null && definition.getWeaverOptions().trim().length() > 0) {
                    definition2.appendWeaverOptions(definition.getWeaverOptions());
                }
                this.aspectDefinitionsExported.put(bundle, definition2);
            }
            if (hashMap.size() > 0) {
                this.aspectPolicies.put(bundle, hashMap);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getPackage(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return "";
    }
}

