/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaRootElement;

public class PDESchemaHelper {
    public static Map<String, IConfigurationElement> getValidAttributes(ISchemaAttribute attribute) {
        ISchemaRestriction restriction;
        int n;
        HashMap<String, IConfigurationElement> attributeMap = new HashMap<String, IConfigurationElement>();
        String basedOnValue = attribute.getBasedOn();
        if (basedOnValue != null) {
            String[] basedOnList;
            String[] stringArray = basedOnList = basedOnValue.split(",");
            n = basedOnList.length;
            int n2 = 0;
            while (n2 < n) {
                String basedOn = stringArray[n2];
                PDESchemaHelper.gatherAttributes(attributeMap, basedOn);
                ++n2;
            }
        }
        if ((restriction = attribute.getType().getRestriction()) != null) {
            Object[] children;
            Object[] objectArray = children = restriction.getChildren();
            int n3 = children.length;
            n = 0;
            while (n < n3) {
                ISchemaEnumeration enumeration;
                String value;
                Object child = objectArray[n];
                if (child instanceof ISchemaEnumeration && (value = (enumeration = (ISchemaEnumeration)child).getName()) != null && value.length() > 0) {
                    attributeMap.put(value, null);
                }
                ++n;
            }
        }
        return attributeMap;
    }

    public static String getReferenceIdentifier(ISchemaAttribute attribute) {
        String rootId = attribute.getSchema().getSchemaDescriptor().getPointId();
        String refId = String.valueOf(PDESchemaHelper.buildBasedOnValue(attribute.getParent())) + "/@" + attribute.getName();
        return String.valueOf(rootId) + refId;
    }

    private static void gatherAttributes(Map<String, IConfigurationElement> attributesInfo, String basedOn) {
        if (basedOn == null) {
            return;
        }
        String[] path = basedOn.split("/");
        if (path.length < 2) {
            return;
        }
        IExtension[] extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions(path[0], true);
        ArrayList<IConfigurationElement> members = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (path.length == 2) {
                attributesInfo.put(extension.getUniqueIdentifier(), null);
            } else {
                IConfigurationElement[] elements;
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(path[1])) {
                        members.add(element);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        ArrayList<IConfigurationElement> parents = members;
        int i = 2;
        while (i < path.length) {
            if (path[i].startsWith("@")) {
                String attName = path[i].substring(1);
                for (IConfigurationElement element : parents) {
                    String value = element.getAttribute(attName);
                    if (value == null) continue;
                    String extpt = element.getDeclaringExtension().getExtensionPointUniqueIdentifier();
                    if (value.indexOf(46) == -1 && extpt.equalsIgnoreCase("org.eclipse.core.contenttype.contentTypes")) {
                        attributesInfo.put(String.valueOf(element.getNamespaceIdentifier()) + '.' + value, element);
                    }
                    attributesInfo.put(value, element);
                }
                return;
            }
            members = new ArrayList();
            for (IConfigurationElement element : parents) {
                members.addAll(PDESchemaHelper.keepGoing(element, path[i]));
            }
            parents = members;
            ++i;
        }
    }

    private static List<IConfigurationElement> keepGoing(IConfigurationElement element, String tag) {
        return Arrays.asList(element.getChildren(tag));
    }

    private static String buildBasedOnValue(ISchemaObject object) {
        if (object instanceof ISchemaElement && !(object instanceof ISchemaRootElement)) {
            ISchemaElement[] elements;
            ISchemaElement schemaElement = (ISchemaElement)object;
            ISchema schema = schemaElement.getSchema();
            ISchemaElement[] iSchemaElementArray = elements = schema.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ISchemaElement[] children;
                ISchemaElement element = iSchemaElementArray[n2];
                ISchemaElement[] iSchemaElementArray2 = children = schema.getCandidateChildren(element);
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISchemaElement childElement = iSchemaElementArray2[n4];
                    if (object.getName().equals(childElement.getName())) {
                        return String.valueOf(PDESchemaHelper.buildBasedOnValue(element)) + '/' + object.getName();
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return "";
    }
}

