/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.ui.preference;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.jsch.internal.core.Utils;
import org.eclipse.jsch.internal.ui.JSchUIPlugin;
import org.eclipse.jsch.internal.ui.Messages;
import org.eclipse.jsch.internal.ui.preference.ExportDialog;
import org.eclipse.jsch.internal.ui.preference.PassphraseDialog;
import org.eclipse.jsch.internal.ui.preference.SWTUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class PreferencePage
extends org.eclipse.jface.preference.PreferencePage
implements IWorkbenchPreferencePage {
    private static final String SSH2_PREFERENCE_PAGE_CONTEXT = "org.eclipse.jsch.ui.ssh2_preference_page_context";
    private Label ssh2HomeLabel;
    private Label privateKeyLabel;
    Text ssh2HomeText;
    Text privateKeyText;
    private Button privateKeyAdd;
    private Button ssh2HomeBrowse;
    Button keyGenerateDSA;
    Button keyGenerateRSA;
    private Button keyLoad;
    private Button keyExport;
    Button saveKeyPair;
    private Label keyCommentLabel;
    Text keyCommentText;
    private Label keyFingerPrintLabel;
    Text keyFingerPrintText;
    private Label keyPassphrase1Label;
    Text keyPassphrase1Text;
    private Label keyPassphrase2Label;
    Text keyPassphrase2Text;
    private Label publicKeylabel;
    Text publicKeyText;
    KeyPair kpair = null;
    String kpairComment;
    public static final String AUTH_SCHEME = "";
    private TableViewer viewer;
    private Button removeHostKeyButton;
    Table preferedAuthMethodTable;
    Table preferedSSHAgentTable;
    Table preferedKeyExchangeMethodTable;
    Table preferedMACMethodTable;
    Button up;
    Button down;
    Button kex_up;
    Button kex_down;
    Button mac_up;
    Button mac_down;

    public PreferencePage() {
        this.setDescription(Messages.CVSSSH2PreferencePage_18);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)container);
        CTabFolder tabFolder = new CTabFolder(container, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.CVSSSH2PreferencePage_19);
        tabItem.setControl(this.createGeneralPage((Composite)tabFolder));
        tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.CVSSSH2PreferencePage_21);
        tabItem.setControl(this.createKeyManagementPage((Composite)tabFolder));
        tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.CVSSSH2PreferencePage_133);
        tabItem.setControl(this.createHostKeyManagementPage((Composite)tabFolder));
        tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.CVSSSH2PreferencePage_137);
        tabItem.setControl(this.createPreferredAuthenticationPage((Composite)tabFolder));
        tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.CVSSSH2PreferencePage_144);
        tabItem.setControl(this.createPreferredKeyExchangePage((Composite)tabFolder));
        tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.CVSSSH2PreferencePage_145);
        tabItem.setControl(this.createPreferredMACPage((Composite)tabFolder));
        tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.CVSSSH2PreferencePage_146);
        tabItem.setControl(this.createPreferredSSHAgentPage((Composite)tabFolder));
        tabFolder.setSelection(0);
        this.initControls();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), SSH2_PREFERENCE_PAGE_CONTEXT);
        return container;
    }

    private Control createGeneralPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        this.ssh2HomeLabel = new Label(group, 0);
        this.ssh2HomeLabel.setText(Messages.CVSSSH2PreferencePage_23);
        this.ssh2HomeText = new Text(group, 2052);
        this.ssh2HomeText.setFont(group.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.ssh2HomeText.setLayoutData((Object)gd);
        this.ssh2HomeBrowse = new Button(group, 0);
        this.ssh2HomeBrowse.setText(Messages.CVSSSH2PreferencePage_24);
        gd = new GridData(256);
        gd.horizontalSpan = 1;
        this.ssh2HomeBrowse.setLayoutData((Object)gd);
        this.createSpacer(group, 3);
        this.privateKeyLabel = new Label(group, 0);
        this.privateKeyLabel.setText(Messages.CVSSSH2PreferencePage_25);
        this.privateKeyText = new Text(group, 2052);
        this.privateKeyText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.privateKeyText.setLayoutData((Object)gd);
        this.privateKeyAdd = new Button(group, 0);
        this.privateKeyAdd.setText(Messages.CVSSSH2PreferencePage_26);
        gd = new GridData(256);
        gd.horizontalSpan = 1;
        this.privateKeyAdd.setLayoutData((Object)gd);
        this.ssh2HomeBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String home = PreferencePage.this.ssh2HomeText.getText();
                if (!new File(home).exists()) {
                    int foo;
                    while ((foo = home.lastIndexOf(File.separator, home.length())) != -1 && !new File(home = home.substring(0, foo)).exists()) {
                    }
                }
                DirectoryDialog dd = new DirectoryDialog(PreferencePage.this.getShell());
                dd.setFilterPath(home);
                dd.setMessage(Messages.CVSSSH2PreferencePage_27);
                String dir = dd.open();
                if (dir == null) {
                    return;
                }
                PreferencePage.this.ssh2HomeText.setText(dir);
            }
        });
        this.privateKeyAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String home = PreferencePage.this.ssh2HomeText.getText();
                FileDialog fd = new FileDialog(PreferencePage.this.getShell(), 4098);
                fd.setFilterPath(home);
                String o = fd.open();
                if (o == null) {
                    return;
                }
                String[] files = fd.getFileNames();
                String keys = PreferencePage.this.privateKeyText.getText();
                String dir = fd.getFilterPath();
                dir = dir.equals(home) ? PreferencePage.AUTH_SCHEME : String.valueOf(dir) + File.separator;
                int i = 0;
                while (i < files.length) {
                    String foo = files[i];
                    if (keys.length() != 0) {
                        keys = String.valueOf(keys) + ",";
                    }
                    keys = String.valueOf(keys) + dir + foo;
                    ++i;
                }
                PreferencePage.this.privateKeyText.setText(keys);
            }
        });
        return group;
    }

    private Control createKeyManagementPage(Composite parent) {
        int columnSpan = 3;
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        this.keyGenerateDSA = new Button(group, 0);
        this.keyGenerateDSA.setText(Messages.CVSSSH2PreferencePage_131);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyGenerateDSA.setLayoutData((Object)gd);
        this.keyGenerateRSA = new Button(group, 0);
        this.keyGenerateRSA.setText(Messages.CVSSSH2PreferencePage_132);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyGenerateRSA.setLayoutData((Object)gd);
        this.keyLoad = new Button(group, 0);
        this.keyLoad.setText(Messages.CVSSSH2PreferencePage_128);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyLoad.setLayoutData((Object)gd);
        this.publicKeylabel = new Label(group, 0);
        this.publicKeylabel.setText(Messages.CVSSSH2PreferencePage_39);
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        this.publicKeylabel.setLayoutData((Object)gd);
        this.publicKeyText = new Text(group, 33557058);
        this.publicKeyText.setText(AUTH_SCHEME);
        this.publicKeyText.setEditable(false);
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.publicKeyText.setLayoutData((Object)gd);
        this.keyFingerPrintLabel = new Label(group, 0);
        this.keyFingerPrintLabel.setText(Messages.CVSSSH2PreferencePage_41);
        this.keyFingerPrintText = new Text(group, 33556484);
        this.keyFingerPrintText.setFont(group.getFont());
        this.keyFingerPrintText.setEditable(false);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyFingerPrintText.setLayoutData((Object)gd);
        this.keyCommentLabel = new Label(group, 0);
        this.keyCommentLabel.setText(Messages.CVSSSH2PreferencePage_42);
        this.keyCommentText = new Text(group, 2052);
        this.keyCommentText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyCommentText.setLayoutData((Object)gd);
        this.keyCommentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PreferencePage.this.kpair == null) {
                    return;
                }
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PreferencePage.this.kpairComment = PreferencePage.this.keyCommentText.getText();
                    PreferencePage.this.kpair.writePublicKey((OutputStream)out, PreferencePage.this.kpairComment);
                    out.close();
                    PreferencePage.this.publicKeyText.setText(out.toString());
                }
                catch (IOException iOException) {}
            }
        });
        this.keyPassphrase1Label = new Label(group, 0);
        this.keyPassphrase1Label.setText(Messages.CVSSSH2PreferencePage_43);
        this.keyPassphrase1Text = new Text(group, 2052);
        this.keyPassphrase1Text.setFont(group.getFont());
        this.keyPassphrase1Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase1Text.setLayoutData((Object)gd);
        this.keyPassphrase2Label = new Label(group, 0);
        this.keyPassphrase2Label.setText(Messages.CVSSSH2PreferencePage_44);
        this.keyPassphrase2Text = new Text(group, 2052);
        this.keyPassphrase2Text.setFont(group.getFont());
        this.keyPassphrase2Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase2Text.setLayoutData((Object)gd);
        this.keyPassphrase1Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pass1 = PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = PreferencePage.this.keyPassphrase2Text.getText();
                if (PreferencePage.this.kpair != null && pass1.equals(pass2)) {
                    PreferencePage.this.saveKeyPair.setEnabled(true);
                } else {
                    PreferencePage.this.saveKeyPair.setEnabled(false);
                }
                if (pass2.length() == 0) {
                    PreferencePage.this.setErrorMessage(null);
                    return;
                }
                if (pass1.equals(pass2)) {
                    PreferencePage.this.setErrorMessage(null);
                } else {
                    PreferencePage.this.setErrorMessage(Messages.CVSSSH2PreferencePage_48);
                }
            }
        });
        this.keyPassphrase2Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pass1 = PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = PreferencePage.this.keyPassphrase2Text.getText();
                if (PreferencePage.this.kpair != null && pass1.equals(pass2)) {
                    PreferencePage.this.saveKeyPair.setEnabled(true);
                } else {
                    PreferencePage.this.saveKeyPair.setEnabled(false);
                }
                if (pass2.length() < pass1.length()) {
                    if (pass1.startsWith(pass2)) {
                        PreferencePage.this.setErrorMessage(null);
                    } else {
                        PreferencePage.this.setErrorMessage(Messages.CVSSSH2PreferencePage_48);
                    }
                    return;
                }
                if (pass1.equals(pass2)) {
                    PreferencePage.this.setErrorMessage(null);
                } else {
                    PreferencePage.this.setErrorMessage(Messages.CVSSSH2PreferencePage_48);
                }
            }
        });
        this.keyPassphrase2Text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String pass1 = PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = PreferencePage.this.keyPassphrase2Text.getText();
                if (pass2.length() < pass1.length()) {
                    if (pass1.startsWith(pass2)) {
                        PreferencePage.this.setErrorMessage(null);
                    } else {
                        PreferencePage.this.setErrorMessage(Messages.CVSSSH2PreferencePage_48);
                    }
                    return;
                }
                if (pass1.equals(pass2)) {
                    PreferencePage.this.setErrorMessage(null);
                } else {
                    PreferencePage.this.setErrorMessage(Messages.CVSSSH2PreferencePage_48);
                }
            }

            public void focusLost(FocusEvent e) {
                String pass2;
                String pass1 = PreferencePage.this.keyPassphrase1Text.getText();
                if (pass1.equals(pass2 = PreferencePage.this.keyPassphrase2Text.getText())) {
                    PreferencePage.this.setErrorMessage(null);
                } else {
                    PreferencePage.this.setErrorMessage(Messages.CVSSSH2PreferencePage_48);
                }
            }
        });
        Composite buttons = new Composite(group, 0);
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttons.setLayout((Layout)layout);
        gd = new GridData(128);
        gd.horizontalSpan = columnSpan;
        buttons.setLayoutData((Object)gd);
        this.keyExport = new Button(buttons, 0);
        this.keyExport.setText(Messages.CVSSSH2PreferencePage_105);
        gd = new GridData(1808);
        this.keyExport.setLayoutData((Object)gd);
        this.saveKeyPair = new Button(buttons, 0);
        this.saveKeyPair.setText(Messages.CVSSSH2PreferencePage_45);
        gd = new GridData(1808);
        this.saveKeyPair.setLayoutData((Object)gd);
        SelectionAdapter keygenadapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok = true;
                String _type = PreferencePage.AUTH_SCHEME;
                try {
                    int type = 0;
                    if (e.widget == PreferencePage.this.keyGenerateDSA) {
                        type = 1;
                        _type = "DSA";
                    } else if (e.widget == PreferencePage.this.keyGenerateRSA) {
                        type = 2;
                        _type = "RSA";
                    } else {
                        return;
                    }
                    final KeyPair[] _kpair = new KeyPair[1];
                    final int __type = type;
                    final JSchException[] _e = new JSchException[1];
                    BusyIndicator.showWhile((Display)PreferencePage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                _kpair[0] = KeyPair.genKeyPair((JSch)PreferencePage.this.getJSch(), (int)__type);
                            }
                            catch (JSchException e) {
                                _e[0] = e;
                            }
                        }
                    });
                    if (_e[0] != null) {
                        throw _e[0];
                    }
                    PreferencePage.this.kpair = _kpair[0];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PreferencePage.this.kpairComment = String.valueOf(_type) + "-1024";
                    PreferencePage.this.kpair.writePublicKey((OutputStream)out, PreferencePage.this.kpairComment);
                    out.close();
                    PreferencePage.this.publicKeyText.setText(out.toString());
                    PreferencePage.this.keyFingerPrintText.setText(PreferencePage.this.kpair.getFingerPrint());
                    PreferencePage.this.keyCommentText.setText(PreferencePage.this.kpairComment);
                    PreferencePage.this.keyPassphrase1Text.setText(PreferencePage.AUTH_SCHEME);
                    PreferencePage.this.keyPassphrase2Text.setText(PreferencePage.AUTH_SCHEME);
                    PreferencePage.this.updateControls();
                }
                catch (IOException iOException) {
                    ok = false;
                }
                catch (JSchException jSchException) {
                    ok = false;
                }
                if (!ok) {
                    MessageDialog.openError((Shell)PreferencePage.this.getShell(), (String)Messages.CVSSSH2PreferencePage_error, (String)Messages.CVSSSH2PreferencePage_47);
                }
            }
        };
        this.keyGenerateDSA.addSelectionListener((SelectionListener)keygenadapter);
        this.keyGenerateRSA.addSelectionListener((SelectionListener)keygenadapter);
        this.keyLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok = true;
                String home = PreferencePage.this.ssh2HomeText.getText();
                FileDialog fd = new FileDialog(PreferencePage.this.getShell(), 4096);
                fd.setFilterPath(home);
                String o = fd.open();
                if (o == null) {
                    return;
                }
                String pkey = fd.getFileName();
                String pkeyab = new File(fd.getFilterPath(), pkey).getAbsolutePath();
                try {
                    block19: {
                        KeyPair _kpair = KeyPair.load((JSch)PreferencePage.this.getJSch(), (String)pkeyab);
                        PassphrasePrompt prompt = null;
                        while (_kpair.isEncrypted()) {
                            if (prompt == null) {
                                prompt = new PassphrasePrompt(NLS.bind((String)Messages.CVSSSH2PreferencePage_126, (Object[])new String[]{pkey}));
                            }
                            Display.getDefault().syncExec(prompt);
                            String passphrase = prompt.getPassphrase();
                            if (passphrase == null || _kpair.decrypt(passphrase)) break;
                            MessageDialog.openError((Shell)PreferencePage.this.getShell(), (String)Messages.CVSSSH2PreferencePage_error, (String)NLS.bind((String)Messages.CVSSSH2PreferencePage_129, (Object[])new String[]{pkey}));
                        }
                        if (_kpair.isEncrypted()) {
                            return;
                        }
                        PreferencePage.this.kpair = _kpair;
                        String _type = PreferencePage.this.kpair.getKeyType() == 1 ? "DSA" : "RSA";
                        PreferencePage.this.kpairComment = String.valueOf(_type) + "-1024";
                        FileInputStream fis = null;
                        try {
                            try {
                                File f = new File(String.valueOf(pkeyab) + ".pub");
                                int i = 0;
                                fis = new FileInputStream(f);
                                byte[] buf = new byte[(int)f.length()];
                                while (i < buf.length) {
                                    int j = fis.read(buf, i, buf.length - i);
                                    if (j <= 0) break;
                                    i += j;
                                }
                                String pubkey = new String(buf);
                                if (pubkey.indexOf(32) > 0 && pubkey.indexOf(32, pubkey.indexOf(32) + 1) > 0) {
                                    int j = pubkey.indexOf(32, pubkey.indexOf(32) + 1) + 1;
                                    PreferencePage.this.kpairComment = pubkey.substring(j);
                                    if (PreferencePage.this.kpairComment.indexOf(10) > 0) {
                                        PreferencePage.this.kpairComment = PreferencePage.this.kpairComment.substring(0, PreferencePage.this.kpairComment.indexOf(10));
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                if (fis != null) {
                                    fis.close();
                                }
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            if (fis != null) {
                                fis.close();
                            }
                            throw throwable;
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PreferencePage.this.kpair.writePublicKey((OutputStream)out, PreferencePage.this.kpairComment);
                    out.close();
                    PreferencePage.this.publicKeyText.setText(out.toString());
                    PreferencePage.this.keyFingerPrintText.setText(PreferencePage.this.kpair.getFingerPrint());
                    PreferencePage.this.keyCommentText.setText(PreferencePage.this.kpairComment);
                    PreferencePage.this.keyPassphrase1Text.setText(PreferencePage.AUTH_SCHEME);
                    PreferencePage.this.keyPassphrase2Text.setText(PreferencePage.AUTH_SCHEME);
                    PreferencePage.this.updateControls();
                }
                catch (IOException iOException) {
                    ok = false;
                }
                catch (JSchException jSchException) {
                    ok = false;
                }
                if (!ok) {
                    MessageDialog.openError((Shell)PreferencePage.this.getShell(), (String)Messages.CVSSSH2PreferencePage_error, (String)Messages.CVSSSH2PreferencePage_130);
                }
            }
        });
        this.keyExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PreferencePage.this.kpair == null) {
                    return;
                }
                PreferencePage.this.setErrorMessage(null);
                final String[] target = new String[1];
                final String title = Messages.CVSSSH2PreferencePage_106;
                final String message = Messages.CVSSSH2PreferencePage_107;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Display display = Display.getCurrent();
                        Shell shell = new Shell(display);
                        ExportDialog dialog = new ExportDialog(shell, title, message);
                        dialog.open();
                        shell.dispose();
                        target[0] = dialog.getTarget();
                    }
                });
                if (target[0] == null) {
                    return;
                }
                String user = PreferencePage.AUTH_SCHEME;
                String host = PreferencePage.AUTH_SCHEME;
                int port = 22;
                if (target[0].indexOf(64) > 0) {
                    user = target[0].substring(0, target[0].indexOf(64));
                    host = target[0].substring(target[0].indexOf(64) + 1);
                }
                if (host.indexOf(58) > 0) {
                    try {
                        port = Integer.parseInt(host.substring(host.indexOf(58) + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        port = -1;
                    }
                    host = host.substring(0, host.indexOf(58));
                }
                if (user.length() == 0 || host.length() == 0 || port == -1) {
                    PreferencePage.this.setErrorMessage(NLS.bind((String)Messages.CVSSSH2PreferencePage_108, (Object[])new String[]{target[0]}));
                    return;
                }
                String options = PreferencePage.AUTH_SCHEME;
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    if (options.length() != 0) {
                        try {
                            bos.write((String.valueOf(options) + " ").getBytes());
                        }
                        catch (IOException iOException) {}
                    }
                    PreferencePage.this.kpair.writePublicKey((OutputStream)bos, PreferencePage.this.kpairComment);
                    bos.close();
                    PreferencePage.this.export_via_sftp(user, host, port, bos.toByteArray());
                }
                catch (IOException iOException) {
                }
                catch (JSchException jSchException) {
                    PreferencePage.this.setErrorMessage(Messages.CVSSSH2PreferencePage_111);
                }
            }
        });
        this.saveKeyPair.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PreferencePage.this.kpair == null) {
                    return;
                }
                String pass = PreferencePage.this.keyPassphrase1Text.getText();
                if (pass.length() == 0 && !MessageDialog.openConfirm((Shell)PreferencePage.this.getShell(), (String)Messages.CVSSSH2PreferencePage_confirmation, (String)Messages.CVSSSH2PreferencePage_49)) {
                    return;
                }
                PreferencePage.this.kpair.setPassphrase(pass);
                String home = PreferencePage.this.ssh2HomeText.getText();
                File _home = new File(home);
                if (!_home.exists()) {
                    if (!MessageDialog.openConfirm((Shell)PreferencePage.this.getShell(), (String)Messages.CVSSSH2PreferencePage_confirmation, (String)NLS.bind((String)Messages.CVSSSH2PreferencePage_50, (Object[])new String[]{home}))) {
                        return;
                    }
                    if (!_home.mkdirs()) {
                        PreferencePage.this.setErrorMessage(String.valueOf(Messages.CVSSSH2PreferencePage_100) + home);
                        return;
                    }
                }
                FileDialog fd = new FileDialog(PreferencePage.this.getShell(), 8192);
                fd.setFilterPath(home);
                String file = PreferencePage.this.kpair.getKeyType() == 2 ? "id_rsa" : "id_dsa";
                fd.setFileName(file);
                file = fd.open();
                if (file == null) {
                    return;
                }
                if (new File(file).exists() && !MessageDialog.openConfirm((Shell)PreferencePage.this.getShell(), (String)Messages.CVSSSH2PreferencePage_confirmation, (String)NLS.bind((String)Messages.CVSSSH2PreferencePage_53, (Object[])new String[]{file}))) {
                    return;
                }
                boolean ok = true;
                try {
                    PreferencePage.this.kpair.writePrivateKey(file);
                    PreferencePage.this.kpair.writePublicKey(String.valueOf(file) + ".pub", PreferencePage.this.kpairComment);
                }
                catch (Exception exception) {
                    ok = false;
                }
                if (!ok) {
                    return;
                }
                MessageDialog.openInformation((Shell)PreferencePage.this.getShell(), (String)Messages.CVSSSH2PreferencePage_information, (String)(String.valueOf(Messages.CVSSSH2PreferencePage_55) + "\n" + Messages.CVSSSH2PreferencePage_57 + file + "\n" + Messages.CVSSSH2PreferencePage_59 + file + ".pub"));
                String dir = fd.getFilterPath();
                File mypkey = new File(dir, fd.getFileName());
                String pkeys = PreferencePage.this.privateKeyText.getText();
                String[] pkeysa = pkeys.split(",");
                int i = 0;
                while (i < pkeysa.length) {
                    File pkey = new File(pkeysa[i]);
                    if (!pkey.isAbsolute()) {
                        pkey = new File(home, pkeysa[i]);
                    }
                    if (pkey.equals(mypkey)) {
                        return;
                    }
                    ++i;
                }
                dir = dir.equals(home) ? PreferencePage.AUTH_SCHEME : String.valueOf(dir) + File.separator;
                if (pkeys.length() > 0) {
                    pkeys = String.valueOf(pkeys) + ",";
                }
                pkeys = String.valueOf(pkeys) + dir + fd.getFileName();
                PreferencePage.this.privateKeyText.setText(pkeys);
            }
        });
        return group;
    }

    private Control createHostKeyManagementPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 0);
        label.setText(Messages.CVSSSH2PreferencePage_139);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(group, 68354);
        Table table = this.viewer.getTable();
        new TableEditor(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PreferencePage.this.handleSelection();
            }
        });
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] columns = table.getColumns();
        columns[0].setText(Messages.CVSSSH2PreferencePage_134);
        columns[1].setText(Messages.CVSSSH2PreferencePage_135);
        columns[2].setText(Messages.CVSSSH2PreferencePage_136);
        this.viewer.setColumnProperties(new String[]{Messages.CVSSSH2PreferencePage_134, Messages.CVSSSH2PreferencePage_135, Messages.CVSSSH2PreferencePage_136});
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return null;
                }
                return (Object[])inputElement;
            }
        });
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(70));
        table.setLayout((Layout)tl);
        Composite buttons = new Composite(group, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.removeHostKeyButton = new Button(buttons, 8);
        this.removeHostKeyButton.setText(Messages.CVSSSH2PreferencePage_138);
        int buttonWidth = SWTUtils.calculateControlSize(SWTUtils.createDialogPixelConverter((Control)parent), (Control[])new Button[]{this.removeHostKeyButton});
        this.removeHostKeyButton.setLayoutData((Object)SWTUtils.createGridData(buttonWidth, -1, 0x1000008, 0x1000000, false, false));
        this.removeHostKeyButton.setEnabled(false);
        this.removeHostKeyButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PreferencePage.this.removeHostKey();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        JSchCorePlugin.getPlugin().loadKnownHosts();
        HostKeyRepository hkr = this.getJSch().getHostKeyRepository();
        this.viewer.setInput((Object)hkr.getHostKey());
        this.handleSelection();
        return group;
    }

    private Control createPreferredAuthenticationPage(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        root.setLayout((Layout)layout);
        Label label = new Label(root, 0);
        GridData textLayoutData = new GridData(1, 1, true, false);
        textLayoutData.horizontalSpan = 2;
        label.setLayoutData((Object)textLayoutData);
        label.setText(Messages.CVSSSH2PreferencePage_4);
        this.preferedAuthMethodTable = new Table(root, 2080);
        GridData layoutData = new GridData(4, 1, true, true);
        layoutData.verticalSpan = 3;
        this.preferedAuthMethodTable.setLayoutData((Object)layoutData);
        layoutData.minimumHeight = 150;
        layoutData.minimumWidth = 200;
        this.populateAuthMethods();
        this.up = new Button(root, 8);
        this.up.setText(Messages.CVSSSH2PreferencePage_2);
        this.up.setEnabled(false);
        this.setButtonLayoutData(this.up);
        this.down = new Button(root, 8);
        this.down.setText(Messages.CVSSSH2PreferencePage_3);
        this.down.setEnabled(false);
        this.setButtonLayoutData(this.down);
        this.preferedAuthMethodTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean anySelected = false;
                int i = 0;
                while (i < PreferencePage.this.preferedAuthMethodTable.getItemCount()) {
                    anySelected |= PreferencePage.this.preferedAuthMethodTable.getItem(i).getChecked();
                    ++i;
                }
                if (anySelected) {
                    PreferencePage.this.setErrorMessage(null);
                    PreferencePage.this.setValid(true);
                } else {
                    PreferencePage.this.setErrorMessage(Messages.CVSSSH2PreferencePage_5);
                    PreferencePage.this.setValid(false);
                }
                PreferencePage.this.up.setEnabled(PreferencePage.this.preferedAuthMethodTable.getSelectionIndex() > 0);
                PreferencePage.this.down.setEnabled(PreferencePage.this.preferedAuthMethodTable.getSelectionIndex() < PreferencePage.this.preferedAuthMethodTable.getItemCount() - 1);
            }
        });
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = PreferencePage.this.preferedAuthMethodTable.getSelectionIndex();
                if (selectedIndex == 1) {
                    PreferencePage.this.up.setEnabled(false);
                }
                PreferencePage.this.down.setEnabled(true);
                TableItem sourceItem = PreferencePage.this.preferedAuthMethodTable.getItem(selectedIndex);
                TableItem targetItem = PreferencePage.this.preferedAuthMethodTable.getItem(selectedIndex - 1);
                String stemp = targetItem.getText();
                targetItem.setText(sourceItem.getText());
                sourceItem.setText(stemp);
                boolean btemp = targetItem.getChecked();
                targetItem.setChecked(sourceItem.getChecked());
                sourceItem.setChecked(btemp);
                PreferencePage.this.preferedAuthMethodTable.setSelection(targetItem);
            }
        });
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = PreferencePage.this.preferedAuthMethodTable.getSelectionIndex();
                if (selectedIndex == PreferencePage.this.preferedAuthMethodTable.getItemCount() - 2) {
                    PreferencePage.this.down.setEnabled(false);
                }
                PreferencePage.this.up.setEnabled(true);
                TableItem sourceItem = PreferencePage.this.preferedAuthMethodTable.getItem(selectedIndex);
                TableItem targetItem = PreferencePage.this.preferedAuthMethodTable.getItem(selectedIndex + 1);
                String stemp = targetItem.getText();
                targetItem.setText(sourceItem.getText());
                sourceItem.setText(stemp);
                boolean btemp = targetItem.getChecked();
                targetItem.setChecked(sourceItem.getChecked());
                sourceItem.setChecked(btemp);
                PreferencePage.this.preferedAuthMethodTable.setSelection(targetItem);
            }
        });
        return root;
    }

    private void populateAuthMethods() {
        this.preferedAuthMethodTable.removeAll();
        String[] methods = Utils.getEnabledPreferredAuthMethods().split(",");
        HashSet<String> smethods = new HashSet<String>(Arrays.asList(methods));
        String[] order = Utils.getMethodsOrder().split(",");
        int i = 0;
        while (i < order.length) {
            TableItem tableItem = new TableItem(this.preferedAuthMethodTable, 0);
            tableItem.setText(0, order[i]);
            if (smethods.contains(order[i])) {
                tableItem.setChecked(true);
            }
            ++i;
        }
    }

    private Control createPreferredKeyExchangePage(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        root.setLayout((Layout)layout);
        Label label = new Label(root, 0);
        GridData textLayoutData = new GridData(1, 1, true, false);
        textLayoutData.horizontalSpan = 2;
        label.setLayoutData((Object)textLayoutData);
        label.setText(Messages.CVSSSH2PreferencePage_140);
        this.preferedKeyExchangeMethodTable = new Table(root, 2080);
        GridData layoutData = new GridData(4, 1, true, true);
        layoutData.verticalSpan = 3;
        this.preferedKeyExchangeMethodTable.setLayoutData((Object)layoutData);
        layoutData.minimumHeight = 150;
        layoutData.minimumWidth = 200;
        this.populateAuthMethods();
        this.kex_up = new Button(root, 8);
        this.kex_up.setText(Messages.CVSSSH2PreferencePage_2);
        this.kex_up.setEnabled(false);
        this.setButtonLayoutData(this.kex_up);
        this.kex_down = new Button(root, 8);
        this.kex_down.setText(Messages.CVSSSH2PreferencePage_3);
        this.kex_down.setEnabled(false);
        this.setButtonLayoutData(this.kex_down);
        this.preferedKeyExchangeMethodTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean anySelected = false;
                int i = 0;
                while (i < PreferencePage.this.preferedKeyExchangeMethodTable.getItemCount()) {
                    anySelected |= PreferencePage.this.preferedKeyExchangeMethodTable.getItem(i).getChecked();
                    ++i;
                }
                if (anySelected) {
                    PreferencePage.this.setErrorMessage(null);
                    PreferencePage.this.setValid(true);
                } else {
                    PreferencePage.this.setErrorMessage(Messages.CVSSSH2PreferencePage_142);
                    PreferencePage.this.setValid(false);
                }
                PreferencePage.this.kex_up.setEnabled(PreferencePage.this.preferedKeyExchangeMethodTable.getSelectionIndex() > 0);
                PreferencePage.this.kex_down.setEnabled(PreferencePage.this.preferedKeyExchangeMethodTable.getSelectionIndex() < PreferencePage.this.preferedKeyExchangeMethodTable.getItemCount() - 1);
            }
        });
        this.kex_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = PreferencePage.this.preferedKeyExchangeMethodTable.getSelectionIndex();
                if (selectedIndex == 1) {
                    PreferencePage.this.kex_up.setEnabled(false);
                }
                PreferencePage.this.kex_down.setEnabled(true);
                TableItem sourceItem = PreferencePage.this.preferedKeyExchangeMethodTable.getItem(selectedIndex);
                TableItem targetItem = PreferencePage.this.preferedKeyExchangeMethodTable.getItem(selectedIndex - 1);
                String stemp = targetItem.getText();
                targetItem.setText(sourceItem.getText());
                sourceItem.setText(stemp);
                boolean btemp = targetItem.getChecked();
                targetItem.setChecked(sourceItem.getChecked());
                sourceItem.setChecked(btemp);
                PreferencePage.this.preferedKeyExchangeMethodTable.setSelection(targetItem);
            }
        });
        this.kex_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = PreferencePage.this.preferedKeyExchangeMethodTable.getSelectionIndex();
                if (selectedIndex == PreferencePage.this.preferedKeyExchangeMethodTable.getItemCount() - 2) {
                    PreferencePage.this.kex_down.setEnabled(false);
                }
                PreferencePage.this.kex_up.setEnabled(true);
                TableItem sourceItem = PreferencePage.this.preferedKeyExchangeMethodTable.getItem(selectedIndex);
                TableItem targetItem = PreferencePage.this.preferedKeyExchangeMethodTable.getItem(selectedIndex + 1);
                String stemp = targetItem.getText();
                targetItem.setText(sourceItem.getText());
                sourceItem.setText(stemp);
                boolean btemp = targetItem.getChecked();
                targetItem.setChecked(sourceItem.getChecked());
                sourceItem.setChecked(btemp);
                PreferencePage.this.preferedKeyExchangeMethodTable.setSelection(targetItem);
            }
        });
        return root;
    }

    private void populateKeyExchangeMethods() {
        this.preferedKeyExchangeMethodTable.removeAll();
        String[] methods = Utils.getEnabledPreferredKEXMethods().split(",");
        HashSet<String> smethods = new HashSet<String>(Arrays.asList(methods));
        String[] order = Utils.getKEXMethodsOrder().split(",");
        int i = 0;
        while (i < order.length) {
            TableItem tableItem = new TableItem(this.preferedKeyExchangeMethodTable, 0);
            tableItem.setText(0, order[i]);
            if (smethods.contains(order[i])) {
                tableItem.setChecked(true);
            }
            ++i;
        }
    }

    private Control createPreferredMACPage(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        root.setLayout((Layout)layout);
        Label label = new Label(root, 0);
        GridData textLayoutData = new GridData(1, 1, true, false);
        textLayoutData.horizontalSpan = 2;
        label.setLayoutData((Object)textLayoutData);
        label.setText(Messages.CVSSSH2PreferencePage_141);
        this.preferedMACMethodTable = new Table(root, 2080);
        GridData layoutData = new GridData(4, 1, true, true);
        layoutData.verticalSpan = 3;
        this.preferedMACMethodTable.setLayoutData((Object)layoutData);
        layoutData.minimumHeight = 150;
        layoutData.minimumWidth = 200;
        this.populateMACMethods();
        this.mac_up = new Button(root, 8);
        this.mac_up.setText(Messages.CVSSSH2PreferencePage_2);
        this.mac_up.setEnabled(false);
        this.setButtonLayoutData(this.mac_up);
        this.mac_down = new Button(root, 8);
        this.mac_down.setText(Messages.CVSSSH2PreferencePage_3);
        this.mac_down.setEnabled(false);
        this.setButtonLayoutData(this.mac_down);
        this.preferedMACMethodTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean anySelected = false;
                int i = 0;
                while (i < PreferencePage.this.preferedMACMethodTable.getItemCount()) {
                    anySelected |= PreferencePage.this.preferedMACMethodTable.getItem(i).getChecked();
                    ++i;
                }
                if (anySelected) {
                    PreferencePage.this.setErrorMessage(null);
                    PreferencePage.this.setValid(true);
                } else {
                    PreferencePage.this.setErrorMessage(Messages.CVSSSH2PreferencePage_143);
                    PreferencePage.this.setValid(false);
                }
                PreferencePage.this.mac_up.setEnabled(PreferencePage.this.preferedMACMethodTable.getSelectionIndex() > 0);
                PreferencePage.this.mac_down.setEnabled(PreferencePage.this.preferedMACMethodTable.getSelectionIndex() < PreferencePage.this.preferedMACMethodTable.getItemCount() - 1);
            }
        });
        this.mac_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = PreferencePage.this.preferedMACMethodTable.getSelectionIndex();
                if (selectedIndex == 1) {
                    PreferencePage.this.mac_up.setEnabled(false);
                }
                PreferencePage.this.mac_down.setEnabled(true);
                TableItem sourceItem = PreferencePage.this.preferedMACMethodTable.getItem(selectedIndex);
                TableItem targetItem = PreferencePage.this.preferedMACMethodTable.getItem(selectedIndex - 1);
                String stemp = targetItem.getText();
                targetItem.setText(sourceItem.getText());
                sourceItem.setText(stemp);
                boolean btemp = targetItem.getChecked();
                targetItem.setChecked(sourceItem.getChecked());
                sourceItem.setChecked(btemp);
                PreferencePage.this.preferedMACMethodTable.setSelection(targetItem);
            }
        });
        this.mac_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = PreferencePage.this.preferedMACMethodTable.getSelectionIndex();
                if (selectedIndex == PreferencePage.this.preferedMACMethodTable.getItemCount() - 2) {
                    PreferencePage.this.mac_down.setEnabled(false);
                }
                PreferencePage.this.mac_up.setEnabled(true);
                TableItem sourceItem = PreferencePage.this.preferedMACMethodTable.getItem(selectedIndex);
                TableItem targetItem = PreferencePage.this.preferedMACMethodTable.getItem(selectedIndex + 1);
                String stemp = targetItem.getText();
                targetItem.setText(sourceItem.getText());
                sourceItem.setText(stemp);
                boolean btemp = targetItem.getChecked();
                targetItem.setChecked(sourceItem.getChecked());
                sourceItem.setChecked(btemp);
                PreferencePage.this.preferedMACMethodTable.setSelection(targetItem);
            }
        });
        return root;
    }

    private Control createPreferredSSHAgentPage(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        root.setLayout((Layout)layout);
        Label label = new Label(root, 0);
        GridData textLayoutData = new GridData(1, 1, true, false);
        textLayoutData.horizontalSpan = 2;
        label.setLayoutData((Object)textLayoutData);
        label.setText(Messages.CVSSSH2PreferencePage_147);
        this.preferedSSHAgentTable = new Table(root, 2080);
        GridData layoutData = new GridData(4, 1, true, true);
        layoutData.verticalSpan = 3;
        this.preferedSSHAgentTable.setLayoutData((Object)layoutData);
        layoutData.minimumHeight = 150;
        layoutData.minimumWidth = 200;
        this.populateSSHAgents();
        return root;
    }

    private void populateSSHAgents() {
        this.preferedSSHAgentTable.removeAll();
        String[] methods = Utils.getAvailableSSHAgents().split(",");
        String[] selected = Utils.getSelectedSSHAgent().split(",");
        int i = 0;
        while (i < methods.length) {
            if (methods[i].length() != 0) {
                TableItem tableItem = new TableItem(this.preferedSSHAgentTable, 0);
                tableItem.setText(0, methods[i]);
                int j = 0;
                while (j < selected.length) {
                    if (selected[j].equals(methods[i])) {
                        tableItem.setChecked(true);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void populateMACMethods() {
        this.preferedMACMethodTable.removeAll();
        String[] methods = Utils.getEnabledPreferredMACMethods().split(",");
        HashSet<String> smethods = new HashSet<String>(Arrays.asList(methods));
        String[] order = Utils.getMACMethodsOrder().split(",");
        int i = 0;
        while (i < order.length) {
            TableItem tableItem = new TableItem(this.preferedMACMethodTable, 0);
            tableItem.setText(0, order[i]);
            if (smethods.contains(order[i])) {
                tableItem.setChecked(true);
            }
            ++i;
        }
    }

    void handleSelection() {
        boolean empty = this.viewer.getSelection().isEmpty();
        this.removeHostKeyButton.setEnabled(!empty);
    }

    void removeHostKey() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        HostKeyRepository hkr = this.getJSch().getHostKeyRepository();
        for (HostKey hostkey : selection) {
            hkr.remove(hostkey.getHost(), hostkey.getType());
            this.viewer.remove((Object)hostkey);
        }
    }

    void export_via_sftp(String user, String host, int port, byte[] pkey) throws JSchException {
        try {
            int timeout = 60000;
            IJSchService service = JSchUIPlugin.getPlugin().getJSchService();
            if (service == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.PreferencePage_0, (String)Messages.PreferencePage_1);
                return;
            }
            IJSchLocation location = service.getLocation(user, host, port);
            Session session = service.createSession(location, null);
            session.setTimeout(timeout);
            try {
                service.connect(session, timeout, (IProgressMonitor)new NullProgressMonitor());
                if (session.getServerVersion().indexOf("OpenSSH") == -1) {
                    this.setErrorMessage(Messages.CVSSSH2PreferencePage_110);
                    return;
                }
                Channel channel = session.openChannel("sftp");
                channel.connect();
                ChannelSftp c = (ChannelSftp)channel;
                SftpATTRS attr = null;
                try {
                    attr = c.stat(".ssh");
                }
                catch (SftpException sftpException) {}
                if (attr == null) {
                    try {
                        c.mkdir(".ssh");
                    }
                    catch (SftpException ee) {
                        this.setErrorMessage(ee.getMessage());
                        session.disconnect();
                        return;
                    }
                }
                try {
                    c.cd(".ssh");
                }
                catch (SftpException ee) {
                    this.setErrorMessage(ee.getMessage());
                    session.disconnect();
                    return;
                }
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(pkey);
                    c.put((InputStream)bis, "authorized_keys", null, 2);
                    bis.close();
                    this.checkPermission(c, "authorized_keys");
                    this.checkPermission(c, ".");
                    c.cd("..");
                    this.checkPermission(c, ".");
                }
                catch (SftpException sftpException) {}
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.CVSSSH2PreferencePage_information, (String)NLS.bind((String)Messages.CVSSSH2PreferencePage_109, (Object)(String.valueOf(user) + "@" + host + (port == 22 ? AUTH_SCHEME : ":" + port) + ":~/.ssh/authorized_keys")));
                c.quit();
                c.disconnect();
            }
            finally {
                session.disconnect();
            }
        }
        catch (IOException eee) {
            this.setErrorMessage(eee.toString());
        }
    }

    private void checkPermission(ChannelSftp c, String path) throws SftpException {
        SftpATTRS attr = c.stat(path);
        int permissions = attr.getPermissions();
        if ((permissions & 0x12) != 0) {
            c.chmod(permissions &= 0xFFFFFFED, path);
        }
    }

    void updateControls() {
        boolean enable = this.kpair != null;
        this.publicKeylabel.setEnabled(enable);
        this.publicKeyText.setEnabled(enable);
        this.keyFingerPrintLabel.setEnabled(enable);
        this.keyFingerPrintText.setEnabled(enable);
        this.keyCommentLabel.setEnabled(enable);
        this.keyCommentText.setEnabled(enable);
        this.keyPassphrase1Label.setEnabled(enable);
        this.keyPassphrase1Text.setEnabled(enable);
        this.keyPassphrase2Label.setEnabled(enable);
        this.keyPassphrase2Text.setEnabled(enable);
        this.keyExport.setEnabled(enable);
        this.saveKeyPair.setEnabled(enable);
        this.populateAuthMethods();
        this.populateKeyExchangeMethods();
        this.populateMACMethods();
        this.up.setEnabled(false);
        this.down.setEnabled(false);
        this.kex_up.setEnabled(false);
        this.kex_down.setEnabled(false);
        this.mac_up.setEnabled(false);
        this.mac_down.setEnabled(false);
    }

    public void init(IWorkbench workbench) {
    }

    public void initialize() {
        this.initControls();
    }

    private void initControls() {
        Preferences preferences = JSchCorePlugin.getPlugin().getPluginPreferences();
        this.ssh2HomeText.setText(preferences.getString("SSH2HOME"));
        this.privateKeyText.setText(preferences.getString("PRIVATEKEY"));
        this.updateControls();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.storeAuthenticationMethodSettings();
        this.storeSSHAgentSettings();
        this.storeKeyExchangeMethodSettings();
        this.storeMACMethodSettings();
        if (result) {
            this.setErrorMessage(null);
            String home = this.ssh2HomeText.getText();
            File _home = new File(home);
            if (!_home.exists() && MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.CVSSSH2PreferencePage_question, (String)NLS.bind((String)Messages.CVSSSH2PreferencePage_99, (Object[])new String[]{home})) && !_home.mkdirs()) {
                this.setErrorMessage(String.valueOf(Messages.CVSSSH2PreferencePage_100) + home);
                return false;
            }
            Preferences preferences = JSchCorePlugin.getPlugin().getPluginPreferences();
            preferences.setValue("SSH2HOME", home);
            preferences.setValue("PRIVATEKEY", this.privateKeyText.getText());
        }
        JSchCorePlugin.getPlugin().setNeedToLoadKnownHosts(true);
        JSchCorePlugin.getPlugin().setNeedToLoadKeys(true);
        JSchCorePlugin.getPlugin().setIdentityRepository();
        JSchCorePlugin.getPlugin().savePluginPreferences();
        return result;
    }

    private void storeAuthenticationMethodSettings() {
        String selected = null;
        String order = null;
        int i = 0;
        while (i < this.preferedAuthMethodTable.getItemCount()) {
            TableItem item = this.preferedAuthMethodTable.getItem(i);
            if (item.getChecked()) {
                selected = selected == null ? item.getText() : String.valueOf(selected) + "," + item.getText();
            }
            order = order == null ? item.getText() : String.valueOf(order) + "," + item.getText();
            ++i;
        }
        Utils.setEnabledPreferredAuthMethods(selected, order);
    }

    private void storeSSHAgentSettings() {
        String selected = AUTH_SCHEME;
        int i = 0;
        while (i < this.preferedSSHAgentTable.getItemCount()) {
            TableItem item = this.preferedSSHAgentTable.getItem(i);
            if (item.getChecked()) {
                selected = selected.length() == 0 ? item.getText() : String.valueOf(selected) + "," + item.getText();
            }
            ++i;
        }
        Utils.setSelectedSSHAgents((String)selected);
    }

    private void storeKeyExchangeMethodSettings() {
        String selected = null;
        String order = null;
        int i = 0;
        while (i < this.preferedKeyExchangeMethodTable.getItemCount()) {
            TableItem item = this.preferedKeyExchangeMethodTable.getItem(i);
            if (item.getChecked()) {
                selected = selected == null ? item.getText() : String.valueOf(selected) + "," + item.getText();
            }
            order = order == null ? item.getText() : String.valueOf(order) + "," + item.getText();
            ++i;
        }
        Utils.setEnabledPreferredKEXMethods(selected, order);
    }

    private void storeMACMethodSettings() {
        String selected = null;
        String order = null;
        int i = 0;
        while (i < this.preferedMACMethodTable.getItemCount()) {
            TableItem item = this.preferedMACMethodTable.getItem(i);
            if (item.getChecked()) {
                selected = selected == null ? item.getText() : String.valueOf(selected) + "," + item.getText();
            }
            order = order == null ? item.getText() : String.valueOf(order) + "," + item.getText();
            ++i;
        }
        Utils.setEnabledPreferredMACMethods(selected, order);
    }

    public void performApply() {
        this.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        Utils.setEnabledPreferredAuthMethods((String)Utils.getDefaultAuthMethods(), (String)Utils.getDefaultAuthMethods());
        Preferences preferences = JSchCorePlugin.getPlugin().getPluginPreferences();
        this.ssh2HomeText.setText(preferences.getDefaultString("SSH2HOME"));
        this.privateKeyText.setText(preferences.getDefaultString("PRIVATEKEY"));
        this.updateControls();
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    JSch getJSch() {
        return JSchCorePlugin.getPlugin().getJSch();
    }

    class PassphrasePrompt
    implements Runnable {
        private String message;
        private String passphrase;

        PassphrasePrompt(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            Display display = Display.getCurrent();
            Shell shell = new Shell(display);
            PassphraseDialog dialog = new PassphraseDialog(shell, this.message);
            dialog.open();
            shell.dispose();
            this.passphrase = dialog.getPassphrase();
        }

        public String getPassphrase() {
            return this.passphrase;
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            HostKey entry = (HostKey)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getHost();
                }
                case 1: {
                    return entry.getType();
                }
                case 2: {
                    return entry.getFingerPrint(PreferencePage.this.getJSch());
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

