/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.dispatch.ServiceDispatchingUtils;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.ecl.TeslaErrorStatus;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.ServiceUtil;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;

public abstract class AbstractActionService
implements ICommandService {
    private IProcess context;

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        TeslaErrorStatus failure;
        this.context = context;
        TeslaBridge.waitDelay();
        this.makeScreenshot(false, "");
        try {
            IStatus extensionResult = this.handleWithExtensions(command, context);
            if (extensionResult != null) {
                if (!extensionResult.isOK()) {
                    this.makeScreenshot(true, extensionResult.getMessage());
                    IStatus iStatus = extensionResult;
                    return iStatus;
                }
            } else {
                Object result = this.exec(command);
                if (result != null) {
                    if (!(result instanceof EObject)) {
                        result = this.wrap(result);
                    }
                    context.getOutput().write(result);
                }
            }
            if ((failure = TeslaBridge.getTeslaFailure()) != null) {
                if (TeslaBridge.isAllowScreenshotOnError(context)) {
                    this.makeScreenshot(true, failure.getMessage());
                }
                TeslaErrorStatus teslaErrorStatus = failure;
                return teslaErrorStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            failure = TeslaBridge.getTeslaFailure();
            if (failure != null) {
                TeslaErrorStatus teslaErrorStatus = failure;
                return teslaErrorStatus;
            }
            if (e instanceof CoreException) {
                IStatus iStatus = ((CoreException)((Object)e)).getStatus();
                return iStatus;
            }
            IStatus iStatus = TeslaImplPlugin.err(e.getMessage(), e);
            return iStatus;
        }
        finally {
            TeslaBridge.waitExecution();
        }
    }

    protected IStatus handleWithExtensions(Command command, IProcess context) throws InterruptedException, CoreException {
        return ServiceDispatchingUtils.handleWithExtensions((Command)command, (IProcess)context);
    }

    protected IProcess getContext() {
        return this.context;
    }

    protected void makeScreenshot(boolean onError, String message) {
        TeslaBridge.makeScreenshot(onError, message);
    }

    protected Object wrap(Object object) {
        return ServiceUtil.wrap(object);
    }

    protected abstract Object exec(Command var1) throws CoreException;
}

