/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.ds.internal.annotations.AnnotationVisitor;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationVersion;
import org.eclipse.pde.ds.internal.annotations.DSEnums;
import org.eclipse.pde.ds.internal.annotations.FieldCollectionTypeDescriptor;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.pde.ds.internal.annotations.ProblemReporter;
import org.eclipse.pde.ds.internal.annotations.ValidationErrorLevel;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ReferenceProcessor {
    private static final String COMPONENT_SERVICE_OBJECTS = "org.osgi.service.component.ComponentServiceObjects";
    private static final String ATTRIBUTE_REFERENCE_POLICY_OPTION = "policy-option";
    private static final String ATTRIBUTE_REFERENCE_UPDATED = "updated";
    private static final String ATTRIBUTE_REFERENCE_SCOPE = "scope";
    static final String ATTRIBUTE_REFERENCE_FIELD = "field";
    private static final String ATTRIBUTE_REFERENCE_FIELD_OPTION = "field-option";
    private static final String ATTRIBUTE_REFERENCE_FIELD_COLLECTION_TYPE = "field-collection-type";
    private static final String VALUE_REFERENCE_FIELD_OPTION_REPLACE = DSEnums.getFieldOption("REPLACE");
    private static final String VALUE_REFERENCE_FIELD_OPTION_UPDATE = DSEnums.getFieldOption("UPDATE");
    private final AnnotationVisitor visitor;
    private final DSAnnotationVersion specVersion;
    private final DSAnnotationVersion requiredVersion;
    private final ValidationErrorLevel errorLevel;
    private final ValidationErrorLevel missingUnbindMethodLevel;
    private final ProblemReporter problemReporter;

    public ReferenceProcessor(AnnotationVisitor visitor, DSAnnotationVersion specVersion, DSAnnotationVersion requiredVersion, ValidationErrorLevel errorLevel, ValidationErrorLevel missingUnbindMethodLevel, ProblemReporter problemReporter) {
        this.visitor = visitor;
        this.specVersion = specVersion;
        this.requiredVersion = requiredVersion;
        this.errorLevel = errorLevel;
        this.missingUnbindMethodLevel = missingUnbindMethodLevel;
        this.problemReporter = problemReporter;
    }

    public DSAnnotationVersion processReference(IDSReference reference, MethodDeclaration method, IMethodBinding methodBinding, Annotation annotation, IAnnotationBinding annotationBinding, Map<String, Object> params, Map<String, Annotation> names) {
        String updated;
        String unbind;
        String erasure;
        ITypeBinding argType;
        int n;
        ITypeBinding[] iTypeBindingArray;
        Object serviceType;
        ITypeBinding[] argTypes = methodBinding.getParameterTypes();
        Object value = params.get("service");
        if (value instanceof ITypeBinding) {
            serviceType = (ITypeBinding)value;
            if (!this.errorLevel.isIgnore() && argTypes.length > 0) {
                if (this.specVersion == DSAnnotationVersion.V1_3) {
                    iTypeBindingArray = argTypes;
                    n = argTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        argType = iTypeBindingArray[n2];
                        if (!this.isValidArgumentForService(argType, (ITypeBinding)serviceType)) {
                            this.problemReporter.reportProblem(annotation, "service", NLS.bind((String)Messages.AnnotationProcessor_invalidReference_serviceType, (Object)argType.getName(), (Object)serviceType.getName()), argType.getName(), serviceType.getName());
                            break;
                        }
                        ++n2;
                    }
                } else {
                    ITypeBinding[] typeArgs;
                    erasure = argTypes[0].getErasure().getBinaryName();
                    if (!(ServiceReference.class.getName().equals(erasure) && ((typeArgs = argTypes[0].getTypeArguments()).length == 0 || serviceType.isAssignmentCompatible(typeArgs[0])) || serviceType.isAssignmentCompatible(argTypes[0]))) {
                        this.problemReporter.reportProblem(annotation, "service", NLS.bind((String)Messages.AnnotationProcessor_invalidReference_serviceType, (Object)argTypes[0].getName(), (Object)serviceType.getName()), argTypes[0].getName(), serviceType.getName());
                    }
                }
            }
        } else if (argTypes.length > 0) {
            if (this.specVersion == DSAnnotationVersion.V1_3) {
                serviceType = null;
                iTypeBindingArray = argTypes;
                n = argTypes.length;
                int typeArgs = 0;
                while (typeArgs < n) {
                    argType = iTypeBindingArray[typeArgs];
                    String erasure2 = argType.getErasure().getBinaryName();
                    if (ServiceReference.class.getName().equals(erasure2) || COMPONENT_SERVICE_OBJECTS.equals(erasure2)) {
                        ITypeBinding[] typeArgs2 = argType.getTypeArguments();
                        if (typeArgs2.length > 0) {
                            serviceType = typeArgs2[0];
                            break;
                        }
                    } else if (!Map.class.getName().equals(erasure2)) {
                        serviceType = argType.isPrimitive() ? this.getObjectType(method.getAST(), argType) : argType;
                        break;
                    }
                    ++typeArgs;
                }
            } else {
                ITypeBinding[] typeArgs;
                erasure = argTypes[0].getErasure().getBinaryName();
                serviceType = ServiceReference.class.getName().equals(erasure) ? ((typeArgs = argTypes[0].getTypeArguments()).length > 0 ? typeArgs[0] : null) : (argTypes[0].isPrimitive() ? this.getObjectType(method.getAST(), argTypes[0]) : argTypes[0]);
            }
        } else {
            serviceType = null;
        }
        if (serviceType == null) {
            this.problemReporter.reportProblem(annotation, null, Messages.AnnotationProcessor_invalidReference_serviceUnknown, new String[0]);
            serviceType = method.getAST().resolveWellKnownType(Object.class.getName());
        }
        this.validateReferenceBindMethod(annotation, (ITypeBinding)serviceType, methodBinding);
        String service = serviceType == null ? null : serviceType.getBinaryName();
        String methodName = methodBinding.getName();
        String name = this.getReferenceName(methodName, params);
        this.validateReferenceName(name, annotation, names);
        String cardinality = null;
        value = params.get("cardinality");
        if (value instanceof IVariableBinding) {
            IVariableBinding cardinalityBinding = (IVariableBinding)value;
            cardinality = DSEnums.getReferenceCardinality(cardinalityBinding.getName());
        }
        String policy = null;
        value = params.get("policy");
        if (value instanceof IVariableBinding) {
            IVariableBinding policyBinding = (IVariableBinding)value;
            policy = DSEnums.getReferencePolicy(policyBinding.getName());
        }
        String target = null;
        value = params.get("target");
        if (value instanceof String) {
            target = (String)value;
            this.validateReferenceTarget(annotation, target);
        }
        IMethodBinding unbindMethod = null;
        value = params.get("unbind");
        if (value instanceof String) {
            String unbindValue = (String)value;
            if ("-".equals(unbindValue)) {
                unbind = null;
            } else {
                unbind = unbindValue;
                if (!this.errorLevel.isIgnore() && (unbindMethod = this.findReferenceMethod(methodBinding.getDeclaringClass(), (ITypeBinding)serviceType, unbind, true)) == null) {
                    this.problemReporter.reportProblem(annotation, "unbind", NLS.bind((String)Messages.AnnotationProcessor_invalidReference_unbindMethod, (Object)unbind), unbind);
                }
            }
        } else {
            String unbindCandidate = methodName.startsWith("add") ? "remove" + methodName.substring("add".length()) : "un" + methodName;
            unbindMethod = this.findReferenceMethod(methodBinding.getDeclaringClass(), (ITypeBinding)serviceType, unbindCandidate, false);
            if (unbindMethod == null) {
                unbind = null;
                if ("dynamic".equals(policy)) {
                    this.problemReporter.reportProblem(annotation, null, this.missingUnbindMethodLevel, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_noImplicitUnbind, (Object)unbindCandidate), unbindCandidate);
                }
            } else {
                unbind = unbindMethod.getName();
            }
        }
        String policyOption = null;
        value = params.get("policyOption");
        if (value instanceof IVariableBinding) {
            IVariableBinding policyOptionBinding = (IVariableBinding)value;
            policyOption = DSEnums.getReferencePolicyOption(policyOptionBinding.getName());
        }
        IMethodBinding updatedMethod = null;
        value = params.get(ATTRIBUTE_REFERENCE_UPDATED);
        if (value instanceof String) {
            String updatedValue = (String)value;
            if ("-".equals(updatedValue)) {
                updated = null;
            } else {
                updated = updatedValue;
                if (!this.errorLevel.isIgnore() && (updatedMethod = this.findReferenceMethod(methodBinding.getDeclaringClass(), (ITypeBinding)serviceType, updated, true)) == null) {
                    this.problemReporter.reportProblem(annotation, ATTRIBUTE_REFERENCE_UPDATED, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_updatedMethod, (Object)updated), updated);
                }
            }
        } else {
            String updatedCandidate = ATTRIBUTE_REFERENCE_UPDATED + ReferenceProcessor.getReferenceName(methodName);
            updatedMethod = this.findReferenceMethod(methodBinding.getDeclaringClass(), (ITypeBinding)serviceType, updatedCandidate, false);
            updated = updatedMethod == null ? null : updatedMethod.getName();
        }
        String referenceScope = null;
        if (this.specVersion == DSAnnotationVersion.V1_3) {
            String bind;
            value = params.get(ATTRIBUTE_REFERENCE_SCOPE);
            if (value instanceof IVariableBinding) {
                IVariableBinding referenceScopeBinding = (IVariableBinding)value;
                referenceScope = DSEnums.getReferenceScope(referenceScopeBinding.getName());
            }
            this.processReferenceFieldParams(reference, methodBinding.getDeclaringClass(), annotation, params, (ITypeBinding)serviceType, cardinality, policy);
            if (!this.errorLevel.isIgnore() && (value = params.get("bind")) instanceof String && !methodName.equals(bind = (String)value)) {
                this.problemReporter.reportProblem(annotation, "bind", Messages.AnnotationProcessor_invalidReference_bindMethodNameMismatch, bind);
            }
        } else {
            this.updateFieldAttributes(reference, null, null, null);
        }
        this.updateAttributes(reference, name, service, cardinality, policy, target, policyOption, referenceScope);
        this.updateMethodAttributes(reference, methodName, updated, unbind);
        return this.determineRequiredVersion(reference, methodBinding.getDeclaringClass(), (ITypeBinding)serviceType, new MethodParams(methodName, methodBinding, updated, updatedMethod, unbind, unbindMethod));
    }

    private boolean isValidArgumentForService(ITypeBinding argType, ITypeBinding serviceType) {
        ITypeBinding[] typeArgs;
        String erasure = argType.getErasure().getBinaryName();
        return (ServiceReference.class.getName().equals(erasure) || COMPONENT_SERVICE_OBJECTS.equals(erasure)) && ((typeArgs = argType.getTypeArguments()).length == 0 || serviceType.isAssignmentCompatible(typeArgs[0])) || serviceType.isAssignmentCompatible(argType) || Map.class.getName().equals(erasure);
    }

    public String getReferenceName(String methodName, Map<String, Object> params) {
        Object value = params.get("name");
        if (value instanceof String) {
            return (String)value;
        }
        return ReferenceProcessor.getReferenceName(methodName);
    }

    static String getReferenceName(String bindMethodName) {
        if (bindMethodName.startsWith("bind")) {
            return bindMethodName.substring("bind".length());
        }
        if (bindMethodName.startsWith("set")) {
            return bindMethodName.substring("set".length());
        }
        if (bindMethodName.startsWith("add")) {
            return bindMethodName.substring("add".length());
        }
        return bindMethodName;
    }

    private void validateReferenceName(String name, Annotation annotation, Map<String, Annotation> names) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        if (names.containsKey(name)) {
            this.problemReporter.reportProblem(annotation, "name", NLS.bind((String)Messages.AnnotationProcessor_duplicateReferenceName, (Object)name), name);
            Annotation duplicate = names.put(name, null);
            if (duplicate != null) {
                this.problemReporter.reportProblem(duplicate, "name", NLS.bind((String)Messages.AnnotationProcessor_duplicateReferenceName, (Object)name), name);
            }
        } else {
            names.put(name, annotation);
        }
    }

    private void processReferenceFieldParams(IDSReference reference, ITypeBinding typeBinding, Annotation annotation, Map<String, ?> params, ITypeBinding serviceType, String cardinality, String policy) {
        String field = null;
        IVariableBinding fieldBinding = null;
        FieldCollectionTypeDescriptor collectionType = null;
        Object value = params.get(ATTRIBUTE_REFERENCE_FIELD);
        if (value instanceof String) {
            field = (String)value;
            if (!this.errorLevel.isIgnore()) {
                fieldBinding = this.findReferenceField(field, typeBinding);
                if (fieldBinding == null) {
                    this.problemReporter.reportProblem(annotation, ATTRIBUTE_REFERENCE_FIELD, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_fieldNotFound, (Object)field), field);
                } else if (serviceType != null) {
                    ITypeBinding targetType = fieldBinding.getType();
                    if ("0..n".equals(cardinality) || "1..n".equals(cardinality)) {
                        collectionType = this.determineCollectionType(annotation.getAST(), targetType);
                        targetType = collectionType.getElementType();
                    }
                    if (targetType != null && !this.isValidFieldForService(targetType, serviceType)) {
                        this.problemReporter.reportProblem(annotation, ATTRIBUTE_REFERENCE_FIELD, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_incompatibleFieldType, (Object)targetType.getName(), (Object)serviceType.getName()), targetType.getName(), serviceType.getName());
                    }
                }
            }
        }
        String fieldOption = null;
        value = params.get("fieldOption");
        if (value instanceof IVariableBinding) {
            IVariableBinding fieldOptionBinding = (IVariableBinding)value;
            fieldOption = DSEnums.getFieldOption(fieldOptionBinding.getName());
            if (!this.errorLevel.isIgnore()) {
                if (field == null) {
                    this.problemReporter.reportProblem(annotation, "fieldOption", Messages.AnnotationProcessor_invalidReference_fieldOptionNotApplicable, new String[0]);
                } else if (VALUE_REFERENCE_FIELD_OPTION_REPLACE.equals(fieldOption)) {
                    if (fieldBinding == null) {
                        fieldBinding = this.findReferenceField(field, typeBinding);
                    }
                    if (fieldBinding != null && Modifier.isFinal((int)fieldBinding.getModifiers())) {
                        this.problemReporter.reportProblem(annotation, "fieldOption", Messages.AnnotationProcessor_invalidReference_fieldFinal_fieldOption, fieldOption);
                    }
                } else if (VALUE_REFERENCE_FIELD_OPTION_UPDATE.equals(fieldOption) && (!"dynamic".equals(policy) || !"0..n".equals(cardinality) && !"1..n".equals(cardinality))) {
                    this.problemReporter.reportProblem(annotation, "fieldOption", Messages.AnnotationProcessor_invalidReference_fieldPolicyCardinality_fieldOption, fieldOption);
                }
            }
        }
        String fieldCollectionType = null;
        if (field != null && ("0..n".equals(cardinality) || "1..n".equals(cardinality))) {
            if (fieldBinding == null) {
                fieldBinding = this.findReferenceField(field, typeBinding);
            }
            if (fieldBinding != null) {
                if (collectionType == null) {
                    collectionType = this.determineCollectionType(annotation.getAST(), fieldBinding.getType());
                }
                if (collectionType.getElementType() != null) {
                    fieldCollectionType = this.getFieldCollectionType(collectionType);
                }
            }
        }
        this.updateFieldAttributes(reference, field, fieldOption, fieldCollectionType);
    }

    private void updateAttributes(IDSReference reference, String name, String service, String cardinality, String policy, String target, String policyOption, String scope) {
        if (name == null) {
            this.visitor.removeAttribute((IDSObject)reference, "name", null);
        } else {
            reference.setReferenceName(name);
        }
        if (service == null) {
            this.visitor.removeAttribute((IDSObject)reference, "interface", null);
        } else {
            reference.setReferenceInterface(service);
        }
        if (cardinality == null) {
            this.visitor.removeAttribute((IDSObject)reference, "cardinality", "1..1");
        } else {
            reference.setReferenceCardinality(cardinality);
        }
        if (policy == null) {
            this.visitor.removeAttribute((IDSObject)reference, "policy", "static");
        } else {
            reference.setReferencePolicy(policy);
        }
        if (target == null) {
            this.visitor.removeAttribute((IDSObject)reference, "target", null);
        } else {
            reference.setReferenceTarget(target);
        }
        if (policyOption == null) {
            this.visitor.removeAttribute((IDSObject)reference, ATTRIBUTE_REFERENCE_POLICY_OPTION, null);
        } else {
            reference.setXMLAttribute(ATTRIBUTE_REFERENCE_POLICY_OPTION, policyOption);
        }
        if (scope == null) {
            this.visitor.removeAttribute((IDSObject)reference, ATTRIBUTE_REFERENCE_SCOPE, null);
        } else {
            reference.setXMLAttribute(ATTRIBUTE_REFERENCE_SCOPE, scope);
        }
    }

    private void updateMethodAttributes(IDSReference reference, String bind, String updated, String unbind) {
        if (bind == null) {
            this.visitor.removeAttribute((IDSObject)reference, "bind", null);
        } else {
            reference.setReferenceBind(bind);
        }
        if (updated == null) {
            this.visitor.removeAttribute((IDSObject)reference, ATTRIBUTE_REFERENCE_UPDATED, null);
        } else {
            reference.setXMLAttribute(ATTRIBUTE_REFERENCE_UPDATED, updated);
        }
        if (unbind == null) {
            this.visitor.removeAttribute((IDSObject)reference, "unbind", null);
        } else {
            reference.setReferenceUnbind(unbind);
        }
    }

    private void updateFieldAttributes(IDSReference reference, String field, String fieldOption, String fieldCollectionType) {
        if (field == null) {
            this.visitor.removeAttribute((IDSObject)reference, ATTRIBUTE_REFERENCE_FIELD, null);
        } else {
            reference.setXMLAttribute(ATTRIBUTE_REFERENCE_FIELD, field);
        }
        if (fieldOption == null) {
            this.visitor.removeAttribute((IDSObject)reference, ATTRIBUTE_REFERENCE_FIELD_OPTION, null);
        } else {
            reference.setXMLAttribute(ATTRIBUTE_REFERENCE_FIELD_OPTION, fieldOption);
        }
        if (fieldCollectionType == null) {
            this.visitor.removeAttribute((IDSObject)reference, ATTRIBUTE_REFERENCE_FIELD_COLLECTION_TYPE, null);
        } else {
            reference.setXMLAttribute(ATTRIBUTE_REFERENCE_FIELD_COLLECTION_TYPE, fieldCollectionType);
        }
    }

    public void processReference(IDSReference reference, FieldDeclaration field, IVariableBinding fieldBinding, Annotation annotation, IAnnotationBinding annotationBinding, Map<String, Object> params, Map<String, Annotation> names) {
        String fieldVal;
        ITypeBinding targetType;
        ITypeBinding serviceType;
        String cardinality = null;
        Object value = params.get("cardinality");
        if (value instanceof IVariableBinding) {
            IVariableBinding cardinalityBinding = (IVariableBinding)value;
            cardinality = DSEnums.getReferenceCardinality(cardinalityBinding.getName());
        }
        ITypeBinding fieldType = fieldBinding.getType();
        FieldCollectionTypeDescriptor collectionType = null;
        if (cardinality == null) {
            collectionType = this.determineCollectionType(field.getAST(), fieldType);
            cardinality = collectionType.getElementType() == null ? "1..1" : "0..n";
        } else if (!this.errorLevel.isIgnore() && ("0..n".equals(cardinality) || "1..n".equals(cardinality)) && (collectionType = this.determineCollectionType(field.getAST(), fieldType)).getElementType() == null) {
            this.problemReporter.reportProblem(annotation, "cardinality", Messages.AnnotationProcessor_invalidReference_fieldTypeCardinalityMismatch, cardinality);
        }
        value = params.get("service");
        if (value instanceof ITypeBinding) {
            serviceType = (ITypeBinding)value;
            if (!this.errorLevel.isIgnore()) {
                targetType = fieldType;
                if ("0..n".equals(cardinality) || "1..n".equals(cardinality)) {
                    if (collectionType == null) {
                        collectionType = this.determineCollectionType(field.getAST(), fieldType);
                    }
                    targetType = collectionType.getElementType();
                }
                if (targetType != null && !this.isValidFieldForService(targetType, serviceType)) {
                    this.problemReporter.reportProblem(annotation, "service", NLS.bind((String)Messages.AnnotationProcessor_invalidReference_incompatibleServiceType, (Object)targetType.getName(), (Object)serviceType.getName()), targetType.getName(), serviceType.getName());
                }
            }
        } else {
            targetType = fieldType;
            if ("0..n".equals(cardinality) || "1..n".equals(cardinality)) {
                if (collectionType == null) {
                    collectionType = this.determineCollectionType(field.getAST(), targetType);
                }
                targetType = collectionType.getElementType();
            }
            ITypeBinding iTypeBinding = serviceType = targetType == null ? null : this.getFieldServiceType(field.getAST(), targetType);
        }
        if (serviceType == null) {
            this.problemReporter.reportProblem(annotation, null, Messages.AnnotationProcessor_invalidReference_fieldUnknownServiceType, new String[0]);
            serviceType = field.getAST().resolveWellKnownType(Object.class.getName());
        }
        this.validateReferenceField(annotation, fieldBinding);
        String service = serviceType == null ? null : serviceType.getBinaryName();
        String fieldCollectionType = null;
        if ("0..n".equals(cardinality) || "1..n".equals(cardinality)) {
            if (collectionType == null) {
                collectionType = this.determineCollectionType(field.getAST(), fieldType);
            }
            if (collectionType.getElementType() != null) {
                fieldCollectionType = this.getFieldCollectionType(collectionType);
            }
        }
        String fieldName = fieldBinding.getName();
        value = params.get("name");
        String name = value instanceof String ? (String)value : fieldName;
        this.validateReferenceName(name, annotation, names);
        if (!this.errorLevel.isIgnore() && (value = params.get(ATTRIBUTE_REFERENCE_FIELD)) instanceof String && !fieldName.equals(fieldVal = (String)value)) {
            this.problemReporter.reportProblem(annotation, ATTRIBUTE_REFERENCE_FIELD, Messages.AnnotationProcessor_invalidReference_fieldNameMismatch, fieldVal);
        }
        String policy = null;
        value = params.get("policy");
        if (value instanceof IVariableBinding) {
            IVariableBinding policyBinding = (IVariableBinding)value;
            policy = DSEnums.getReferencePolicy(policyBinding.getName());
        } else if (Modifier.isVolatile((int)field.getModifiers())) {
            policy = "dynamic";
        }
        String target = null;
        value = params.get("target");
        if (value instanceof String) {
            target = (String)value;
            this.validateReferenceTarget(annotation, target);
        }
        String policyOption = null;
        value = params.get("policyOption");
        if (value instanceof IVariableBinding) {
            IVariableBinding policyOptionBinding = (IVariableBinding)value;
            policyOption = DSEnums.getReferencePolicyOption(policyOptionBinding.getName());
        }
        String referenceScope = null;
        value = params.get(ATTRIBUTE_REFERENCE_SCOPE);
        if (value instanceof IVariableBinding) {
            IVariableBinding referenceScopeBinding = (IVariableBinding)value;
            referenceScope = DSEnums.getReferenceScope(referenceScopeBinding.getName());
        }
        String fieldOption = null;
        value = params.get("fieldOption");
        if (value instanceof IVariableBinding) {
            IVariableBinding fieldOptionBinding = (IVariableBinding)value;
            fieldOption = DSEnums.getFieldOption(fieldOptionBinding.getName());
            if (!this.errorLevel.isIgnore()) {
                if (VALUE_REFERENCE_FIELD_OPTION_REPLACE.equals(fieldOption)) {
                    if (Modifier.isFinal((int)field.getModifiers())) {
                        this.problemReporter.reportProblem(annotation, "fieldOption", Messages.AnnotationProcessor_invalidReference_fieldFinal_fieldOption, fieldOption);
                    }
                } else if (VALUE_REFERENCE_FIELD_OPTION_UPDATE.equals(fieldOption) && (!"dynamic".equals(policy) || !"0..n".equals(cardinality) && !"1..n".equals(cardinality))) {
                    this.problemReporter.reportProblem(annotation, "fieldOption", Messages.AnnotationProcessor_invalidReference_fieldPolicyCardinality_fieldOption, fieldOption);
                }
            }
        } else if ("dynamic".equals(policy) && ("0..n".equals(cardinality) || "1..n".equals(cardinality)) && Modifier.isFinal((int)field.getModifiers())) {
            fieldOption = VALUE_REFERENCE_FIELD_OPTION_UPDATE;
        }
        if (!this.errorLevel.isIgnore() && collectionType != null && collectionType.getElementType() != null && !collectionType.isExact()) {
            if (!"dynamic".equals(policy)) {
                this.problemReporter.reportProblem(annotation, policy == null ? null : "policy", Messages.AnnotationProcessor_invalidReference_fieldCardinalityPolicyCollectionType, new String[0]);
            }
            if (!VALUE_REFERENCE_FIELD_OPTION_UPDATE.equals(fieldOption)) {
                this.problemReporter.reportProblem(annotation, fieldOption == null ? null : "fieldOption", Messages.AnnotationProcessor_invalidReference_fieldCollection_fieldOption, new String[0]);
            }
        }
        this.processReferenceMethodParams(reference, fieldBinding.getDeclaringClass(), annotation, params, serviceType);
        this.updateAttributes(reference, name, service, cardinality, policy, target, policyOption, referenceScope);
        this.updateFieldAttributes(reference, fieldName, fieldOption, fieldCollectionType);
    }

    private FieldCollectionTypeDescriptor determineCollectionType(AST ast, ITypeBinding type) {
        HashSet<ITypeBinding> visited = new HashSet<ITypeBinding>();
        LinkedList<ITypeBinding> types = new LinkedList<ITypeBinding>();
        boolean exact = true;
        do {
            if (!visited.add(type)) continue;
            String erasure = type.getErasure().getBinaryName();
            if (Collection.class.getName().equals(erasure) || List.class.getName().equals(erasure)) {
                ITypeBinding[] typeArgs = type.getTypeArguments();
                if (typeArgs.length > 0) {
                    return new FieldCollectionTypeDescriptor(typeArgs[0], exact);
                }
                return new FieldCollectionTypeDescriptor(ast.resolveWellKnownType(Object.class.getName()), exact);
            }
            exact = false;
            ITypeBinding superType = type.getSuperclass();
            if (superType != null && !superType.isEqualTo((IBinding)ast.resolveWellKnownType(Object.class.getName()))) {
                types.add(superType);
            }
            types.addAll(Arrays.asList(type.getInterfaces()));
        } while ((type = (ITypeBinding)types.poll()) != null);
        return new FieldCollectionTypeDescriptor(null, false);
    }

    private boolean isValidFieldForService(ITypeBinding fieldType, ITypeBinding serviceType) {
        ITypeBinding[] typeArgs;
        String erasure = fieldType.getErasure().getBinaryName();
        return (ServiceReference.class.getName().equals(erasure) || COMPONENT_SERVICE_OBJECTS.equals(erasure)) && ((typeArgs = fieldType.getTypeArguments()).length == 0 || serviceType.isAssignmentCompatible(typeArgs[0])) || Map.class.getName().equals(erasure) || Map.Entry.class.getName().equals(erasure) && ((typeArgs = fieldType.getTypeArguments()).length < 2 || Map.class.getName().equals(typeArgs[0].getErasure().getBinaryName()) && serviceType.isAssignmentCompatible(typeArgs[1])) || serviceType.isAssignmentCompatible(fieldType);
    }

    private ITypeBinding getFieldServiceType(AST ast, ITypeBinding type) {
        ITypeBinding[] typeArgs;
        String erasure = type.getErasure().getBinaryName();
        Object serviceType = ServiceReference.class.getName().equals(erasure) || COMPONENT_SERVICE_OBJECTS.equals(erasure) ? ((typeArgs = type.getTypeArguments()).length > 0 ? typeArgs[0] : null) : (Map.Entry.class.getName().equals(erasure) ? ((typeArgs = type.getTypeArguments()).length >= 2 && Map.class.getName().equals(typeArgs[0].getErasure().getBinaryName()) ? typeArgs[1] : null) : (Map.class.getName().equals(erasure) ? null : (type.isPrimitive() ? this.getObjectType(ast, type) : type)));
        return serviceType;
    }

    private ITypeBinding getObjectType(AST ast, ITypeBinding primitive) {
        if (Boolean.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Boolean.class.getName());
        }
        if (Byte.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Byte.class.getName());
        }
        if (Character.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Character.class.getName());
        }
        if (Double.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Double.class.getName());
        }
        if (Float.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Float.class.getName());
        }
        if (Integer.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Integer.class.getName());
        }
        if (Long.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Long.class.getName());
        }
        if (Short.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Short.class.getName());
        }
        return null;
    }

    private String getFieldCollectionType(FieldCollectionTypeDescriptor collectionType) {
        String fieldCollectionType = null;
        String erasure = collectionType.getElementType().getErasure().getBinaryName();
        if (ServiceReference.class.getName().equals(erasure)) {
            fieldCollectionType = "reference";
        } else if (COMPONENT_SERVICE_OBJECTS.equals(erasure)) {
            fieldCollectionType = "serviceobjects";
        } else if (Map.class.getName().equals(erasure)) {
            fieldCollectionType = "properties";
        } else if (Map.Entry.class.getName().equals(erasure)) {
            fieldCollectionType = "tuple";
        }
        return fieldCollectionType;
    }

    private MethodParams processReferenceMethodParams(IDSReference reference, ITypeBinding typeBinding, Annotation annotation, Map<String, ?> params, ITypeBinding serviceType) {
        String bind = null;
        IMethodBinding bindMethod = null;
        Object value = params.get("bind");
        if (value instanceof String) {
            bind = (String)value;
            if (!this.errorLevel.isIgnore() && (bindMethod = this.findReferenceMethod(typeBinding, serviceType, bind, true)) == null) {
                this.problemReporter.reportProblem(annotation, "bind", NLS.bind((String)Messages.AnnotationProcessor_invalidReference_bindMethodNotFound, (Object)bind), bind);
            }
        }
        String unbind = null;
        IMethodBinding unbindMethod = null;
        value = params.get("unbind");
        if (value instanceof String) {
            unbind = (String)value;
            if (!this.errorLevel.isIgnore() && (unbindMethod = this.findReferenceMethod(typeBinding, serviceType, unbind, true)) == null) {
                this.problemReporter.reportProblem(annotation, "unbind", NLS.bind((String)Messages.AnnotationProcessor_invalidReference_unbindMethod, (Object)unbind), unbind);
            }
        }
        String updated = null;
        IMethodBinding updatedMethod = null;
        value = params.get(ATTRIBUTE_REFERENCE_UPDATED);
        if (value instanceof String) {
            updated = (String)value;
            if (!this.errorLevel.isIgnore() && (updatedMethod = this.findReferenceMethod(typeBinding, serviceType, updated, true)) == null) {
                this.problemReporter.reportProblem(annotation, ATTRIBUTE_REFERENCE_UPDATED, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_updatedMethod, (Object)updated), updated);
            }
        }
        this.updateMethodAttributes(reference, bind, updated, unbind);
        return new MethodParams(bind, bindMethod, updated, updatedMethod, unbind, unbindMethod);
    }

    private void validateReferenceField(Annotation annotation, IVariableBinding fieldBinding) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        if (Modifier.isStatic((int)fieldBinding.getModifiers())) {
            this.problemReporter.reportProblem(annotation, null, Messages.AnnotationProcessor_invalidReference_staticField, new String[0]);
        }
    }

    public DSAnnotationVersion processReference(IDSReference reference, ITypeBinding typeBinding, Annotation annotation, IAnnotationBinding annotationBinding, Map<String, Object> params, Map<String, Annotation> names) {
        ITypeBinding serviceType;
        Object value = params.get("service");
        if (value instanceof ITypeBinding) {
            serviceType = (ITypeBinding)value;
        } else {
            serviceType = annotation.getAST().resolveWellKnownType(Object.class.getName());
            if (!this.errorLevel.isIgnore()) {
                this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_missingRequiredParam, (Object)"service"), new String[0]);
            }
        }
        String service = serviceType == null ? null : serviceType.getBinaryName();
        String name = null;
        value = params.get("name");
        if (value instanceof String) {
            name = (String)value;
            this.validateReferenceName(name, annotation, names);
        } else if (!this.errorLevel.isIgnore()) {
            this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_missingRequiredParam, (Object)"name"), new String[0]);
        }
        String cardinality = null;
        value = params.get("cardinality");
        if (value instanceof IVariableBinding) {
            IVariableBinding cardinalityBinding = (IVariableBinding)value;
            cardinality = DSEnums.getReferenceCardinality(cardinalityBinding.getName());
        }
        String policy = null;
        value = params.get("policy");
        if (value instanceof IVariableBinding) {
            IVariableBinding policyBinding = (IVariableBinding)value;
            policy = DSEnums.getReferencePolicy(policyBinding.getName());
        }
        String target = null;
        value = params.get("target");
        if (value instanceof String) {
            target = (String)value;
            this.validateReferenceTarget(annotation, target);
        }
        String policyOption = null;
        value = params.get("policyOption");
        if (value instanceof IVariableBinding) {
            IVariableBinding policyOptionBinding = (IVariableBinding)value;
            policyOption = DSEnums.getReferencePolicyOption(policyOptionBinding.getName());
        }
        String referenceScope = null;
        value = params.get(ATTRIBUTE_REFERENCE_SCOPE);
        if (value instanceof IVariableBinding) {
            IVariableBinding referenceScopeBinding = (IVariableBinding)value;
            referenceScope = DSEnums.getReferenceScope(referenceScopeBinding.getName());
        }
        MethodParams methodParams = this.processReferenceMethodParams(reference, typeBinding, annotation, params, serviceType);
        this.processReferenceFieldParams(reference, typeBinding, annotation, params, serviceType, cardinality, policy);
        this.updateAttributes(reference, name, service, cardinality, policy, target, policyOption, referenceScope);
        return this.determineRequiredVersion(reference, typeBinding, serviceType, methodParams);
    }

    private void validateReferenceBindMethod(Annotation annotation, ITypeBinding serviceType, IMethodBinding methodBinding) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        if (Modifier.isStatic((int)methodBinding.getModifiers())) {
            this.problemReporter.reportProblem(annotation, null, Messages.AnnotationProcessor_invalidReference_staticBindMethod, new String[0]);
        }
        String returnTypeName = methodBinding.getReturnType().getName();
        if (!Void.TYPE.getName().equals(returnTypeName)) {
            this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_invalidBindMethodReturnType, (Object)returnTypeName), returnTypeName);
        }
        ITypeBinding[] argTypes = methodBinding.getParameterTypes();
        if (this.specVersion == DSAnnotationVersion.V1_3) {
            if (argTypes.length == 0) {
                this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_bindMethodNoArgs, (Object)(serviceType == null ? Messages.AnnotationProcessor_unknownServiceTypeLabel : serviceType.getName())), new String[0]);
            } else if (serviceType != null) {
                ITypeBinding[] iTypeBindingArray = argTypes;
                int n = argTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding argType = iTypeBindingArray[n2];
                    String erasure = argType.getErasure().getBinaryName();
                    if (!(ServiceReference.class.getName().equals(erasure) || COMPONENT_SERVICE_OBJECTS.equals(erasure) || serviceType == null || serviceType.isAssignmentCompatible(argType) || Map.class.getName().equals(erasure))) {
                        this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_invalidBindMethodArg, (Object)argType.getName(), (Object)(serviceType == null ? Messages.AnnotationProcessor_unknownServiceTypeLabel : serviceType.getName())), argType.getName());
                    }
                    ++n2;
                }
            }
        } else if (!this.isLegacySignature(methodBinding, serviceType)) {
            String[] args = new String[argTypes.length];
            StringBuilder buf = new StringBuilder(64);
            buf.append('(');
            int i = 0;
            while (i < args.length) {
                args[i] = argTypes[i].getName();
                if (buf.length() > 1) {
                    buf.append(", ");
                }
                buf.append(args[i]);
                ++i;
            }
            buf.append(')');
            this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidReference_invalidBindMethodParameters, (Object)buf, (Object)(serviceType == null ? Messages.AnnotationProcessor_unknownServiceTypeLabel : serviceType.getName())), args);
        }
    }

    private void validateReferenceTarget(Annotation annotation, String target) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        try {
            FrameworkUtil.createFilter((String)target);
        }
        catch (InvalidSyntaxException e) {
            String msg = e.getMessage();
            String suffix = ": " + e.getFilter();
            if (msg.endsWith(suffix)) {
                msg = msg.substring(0, msg.length() - suffix.length());
            }
            this.problemReporter.reportProblem(annotation, "target", msg, target);
        }
    }

    private IMethodBinding findReferenceMethod(ITypeBinding componentClass, ITypeBinding serviceType, String name, boolean recurse) {
        ITypeBinding testedClass = componentClass;
        IMethodBinding candidate = null;
        int priority = 0;
        do {
            IMethodBinding[] iMethodBindingArray = testedClass.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                block18: {
                    IMethodBinding declaredMethod;
                    block30: {
                        ITypeBinding[] paramTypes;
                        block29: {
                            block26: {
                                block28: {
                                    block27: {
                                        block19: {
                                            declaredMethod = iMethodBindingArray[n2];
                                            if (!name.equals(declaredMethod.getName()) || Modifier.isStatic((int)declaredMethod.getModifiers()) || !Void.TYPE.getName().equals(declaredMethod.getReturnType().getName()) || testedClass != componentClass && !Modifier.isPublic((int)declaredMethod.getModifiers()) && !Modifier.isProtected((int)declaredMethod.getModifiers()) && (Modifier.isPrivate((int)declaredMethod.getModifiers()) || !testedClass.getPackage().isEqualTo((IBinding)componentClass.getPackage()))) break block18;
                                            paramTypes = declaredMethod.getParameterTypes();
                                            if (this.specVersion != DSAnnotationVersion.V1_3) break block19;
                                            int i = 0;
                                            while (i < paramTypes.length) {
                                                block25: {
                                                    block21: {
                                                        String erasure;
                                                        int priorityOffset;
                                                        block24: {
                                                            ITypeBinding paramType;
                                                            block23: {
                                                                block22: {
                                                                    block20: {
                                                                        paramType = paramTypes[i];
                                                                        priorityOffset = i == 0 ? 10 : 0;
                                                                        erasure = paramType.getErasure().getBinaryName();
                                                                        if (!ServiceReference.class.getName().equals(erasure)) break block20;
                                                                        if (paramTypes.length == 1) {
                                                                            return declaredMethod;
                                                                        }
                                                                        if (priority < 5) {
                                                                            priority = 5;
                                                                        }
                                                                        break block21;
                                                                    }
                                                                    if (priority >= priorityOffset + 4 || !COMPONENT_SERVICE_OBJECTS.equals(erasure)) break block22;
                                                                    priority = priorityOffset + 4;
                                                                    break block21;
                                                                }
                                                                if (priority >= priorityOffset + 3 || serviceType == null || !serviceType.isEqualTo((IBinding)paramType)) break block23;
                                                                priority = priorityOffset + 3;
                                                                break block21;
                                                            }
                                                            if (priority >= priorityOffset + 2 || serviceType == null || !serviceType.isAssignmentCompatible(paramType)) break block24;
                                                            priority = priorityOffset + 2;
                                                            break block21;
                                                        }
                                                        if (priority >= priorityOffset + 1 || !Map.class.getName().equals(erasure)) break block25;
                                                        priority = priorityOffset + 1;
                                                    }
                                                    candidate = declaredMethod;
                                                }
                                                ++i;
                                            }
                                            break block18;
                                        }
                                        if (paramTypes.length != 1) break block26;
                                        String erasure = paramTypes[0].getErasure().getBinaryName();
                                        if (ServiceReference.class.getName().equals(erasure)) {
                                            return declaredMethod;
                                        }
                                        if (priority >= 3 || serviceType == null || !serviceType.isEqualTo((IBinding)paramTypes[0])) break block27;
                                        priority = 3;
                                        break block28;
                                    }
                                    if (priority >= 2 || serviceType == null || !serviceType.isAssignmentCompatible(paramTypes[0])) break block18;
                                    priority = 2;
                                }
                                candidate = declaredMethod;
                                break block18;
                            }
                            if (paramTypes.length != 2) break block18;
                            if (priority >= true || serviceType == null || !serviceType.isEqualTo((IBinding)paramTypes[0]) || !Map.class.getName().equals(paramTypes[1].getErasure().getBinaryName())) break block29;
                            priority = 1;
                            break block30;
                        }
                        if (candidate != null || serviceType == null || !serviceType.isAssignmentCompatible(paramTypes[0]) || !Map.class.getName().equals(paramTypes[1].getErasure().getBinaryName())) break block18;
                    }
                    candidate = declaredMethod;
                }
                ++n2;
            }
        } while (recurse && (testedClass = testedClass.getSuperclass()) != null);
        return candidate;
    }

    private IVariableBinding findReferenceField(String name, ITypeBinding componentClass) {
        ITypeBinding testedClass = componentClass;
        do {
            IVariableBinding[] iVariableBindingArray = testedClass.getDeclaredFields();
            int n = iVariableBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableBinding declaredField = iVariableBindingArray[n2];
                if (name.equals(declaredField.getName()) && !Modifier.isStatic((int)declaredField.getModifiers()) && (testedClass == componentClass || Modifier.isPublic((int)declaredField.getModifiers()) || Modifier.isProtected((int)declaredField.getModifiers()) || !Modifier.isPrivate((int)declaredField.getModifiers()) && testedClass.getPackage().isEqualTo((IBinding)componentClass.getPackage()))) {
                    return declaredField;
                }
                ++n2;
            }
        } while ((testedClass = testedClass.getSuperclass()) != null);
        return null;
    }

    private DSAnnotationVersion determineRequiredVersion(IDSReference reference, ITypeBinding implType, ITypeBinding serviceType, MethodParams methodParams) {
        if (this.requiredVersion == DSAnnotationVersion.V1_3) {
            return DSAnnotationVersion.V1_3;
        }
        DSAnnotationVersion requiredVersion = this.specVersion == DSAnnotationVersion.V1_3 && (reference.getDocumentAttribute(ATTRIBUTE_REFERENCE_SCOPE) != null || reference.getDocumentAttribute(ATTRIBUTE_REFERENCE_FIELD) != null || reference.getDocumentAttribute(ATTRIBUTE_REFERENCE_FIELD_OPTION) != null || reference.getDocumentAttribute(ATTRIBUTE_REFERENCE_FIELD_COLLECTION_TYPE) != null) ? DSAnnotationVersion.V1_3 : (reference.getDocumentAttribute(ATTRIBUTE_REFERENCE_POLICY_OPTION) != null || reference.getDocumentAttribute(ATTRIBUTE_REFERENCE_UPDATED) != null ? DSAnnotationVersion.V1_2 : DSAnnotationVersion.V1_1);
        if (this.specVersion == DSAnnotationVersion.V1_3 && requiredVersion != DSAnnotationVersion.V1_3) {
            String bind = methodParams.getBind();
            IMethodBinding bindMethod = methodParams.getBindMethod();
            String updated = methodParams.getUpdated();
            IMethodBinding updatedMethod = methodParams.getUpdatedMethod();
            String unbind = methodParams.getUnbind();
            IMethodBinding unbindMethod = methodParams.getUnbindMethod();
            if (bind != null) {
                if (bindMethod == null) {
                    bindMethod = this.findReferenceMethod(implType, serviceType, bind, true);
                }
                if (bindMethod != null && !this.isLegacySignature(bindMethod, serviceType)) {
                    requiredVersion = DSAnnotationVersion.V1_3;
                }
            }
            if (requiredVersion != DSAnnotationVersion.V1_3 && unbind != null) {
                if (unbindMethod == null) {
                    unbindMethod = this.findReferenceMethod(implType, serviceType, unbind, true);
                }
                if (unbindMethod != null && !this.isLegacySignature(bindMethod, serviceType)) {
                    requiredVersion = DSAnnotationVersion.V1_3;
                }
            }
            if (requiredVersion != DSAnnotationVersion.V1_3 && updated != null) {
                if (updatedMethod == null) {
                    updatedMethod = this.findReferenceMethod(implType, serviceType, updated, true);
                }
                if (updatedMethod != null && !this.isLegacySignature(updatedMethod, serviceType)) {
                    requiredVersion = DSAnnotationVersion.V1_3;
                }
            }
        }
        return requiredVersion;
    }

    private boolean isLegacySignature(IMethodBinding methodBinding, ITypeBinding serviceType) {
        ITypeBinding[] argTypes = methodBinding.getParameterTypes();
        return argTypes.length == 1 && (ServiceReference.class.getName().equals(argTypes[0].getErasure().getBinaryName()) || serviceType == null || serviceType.isAssignmentCompatible(argTypes[0])) || argTypes.length == 2 && (serviceType == null || serviceType.isAssignmentCompatible(argTypes[0])) && Map.class.getName().equals(argTypes[1].getErasure().getBinaryName());
    }

    private static class MethodParams {
        private final String bind;
        private final IMethodBinding bindMethod;
        private final String updated;
        private final IMethodBinding updatedMethod;
        private final String unbind;
        private final IMethodBinding unbindMethod;

        public MethodParams(String bind, IMethodBinding bindMethod, String updated, IMethodBinding updatedMethod, String unbind, IMethodBinding unbindMethod) {
            this.bind = bind;
            this.bindMethod = bindMethod;
            this.updated = updated;
            this.updatedMethod = updatedMethod;
            this.unbind = unbind;
            this.unbindMethod = unbindMethod;
        }

        public String getBind() {
            return this.bind;
        }

        public IMethodBinding getBindMethod() {
            return this.bindMethod;
        }

        public String getUpdated() {
            return this.updated;
        }

        public IMethodBinding getUpdatedMethod() {
            return this.updatedMethod;
        }

        public String getUnbind() {
            return this.unbind;
        }

        public IMethodBinding getUnbindMethod() {
            return this.unbindMethod;
        }
    }
}

