/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

class WebkitGDBus {
    private static String DBUS_SERVICE_NAME;
    private static final String DBUS_OBJECT_NAME = "/org/eclipse/swt/gdbus";
    private static final String INTERFACE_NAME = "org.eclipse.swt.gdbusInterface";
    private static final String webkit2callJava;
    private static final String dbus_introspection_xml;
    private static final byte SWT_DBUS_MAGIC_NUMBER_EMPTY_ARRAY = 101;
    private static final byte SWT_DBUS_MAGIC_NUMBER_NULL = 48;
    private static Callback onBusAcquiredCallback;
    private static Callback onNameAcquiredCallback;
    private static Callback onNameLostCallback;
    private static Callback handleMethodCallback;
    private static boolean initialized;

    static {
        webkit2callJava = WebKit.Webkit2Extension.getJavaScriptFunctionName();
        dbus_introspection_xml = "<node>  <interface name='org.eclipse.swt.gdbusInterface'>    <method name='" + webkit2callJava + "'>" + "      <arg type='" + "s" + "' name='webViewPtr' direction='in'/>" + "      <arg type='" + "d" + "' name='index' direction='in'/>" + "      <arg type='" + "s" + "' name='token' direction='in'/>" + "      <arg type='" + "*" + "' name='arguments' direction='in'/>" + "      <arg type='" + "*" + "' name='result' direction='out'/>" + "    </method>" + "  </interface>" + "</node>";
        onBusAcquiredCallback = new Callback(WebkitGDBus.class, "onBusAcquiredCallback", 3);
        if (onBusAcquiredCallback.getAddress() == 0) {
            SWT.error(3);
        }
        if ((onNameAcquiredCallback = new Callback(WebkitGDBus.class, "onNameAcquiredCallback", 3)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((onNameLostCallback = new Callback(WebkitGDBus.class, "onNameLostCallback", 3)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((handleMethodCallback = new Callback(WebkitGDBus.class, "handleMethodCallback", 8)).getAddress() == 0) {
            SWT.error(3);
        }
    }

    WebkitGDBus() {
    }

    static void init(String uniqueId) {
        if (initialized) {
            return;
        }
        initialized = true;
        DBUS_SERVICE_NAME = "org.eclipse.swt" + uniqueId;
        int owner_id = OS.g_bus_own_name(2, Converter.javaStringToCString(DBUS_SERVICE_NAME), 3, onBusAcquiredCallback.getAddress(), onNameAcquiredCallback.getAddress(), onNameLostCallback.getAddress(), 0, 0);
        if (owner_id == 0) {
            System.err.println("SWT WebkitGDBus: Failed to aquire bus name: " + DBUS_SERVICE_NAME);
        }
    }

    private static void teardown_gdbus() {
    }

    private static int onBusAcquiredCallback(int connection, int name, int user_data) {
        int[] error = new int[1];
        int gdBusNodeInfo = OS.g_dbus_node_info_new_for_xml(Converter.javaStringToCString(dbus_introspection_xml), error);
        if (gdBusNodeInfo == 0 || error[0] != 0) {
            System.err.println("SWT WebkitGDBus: Failed to get introspection data");
        }
        assert (gdBusNodeInfo != 0) : "SWT WebkitGDBus: introspection data should not be 0";
        error = new int[1];
        int interface_info = OS.g_dbus_node_info_lookup_interface(gdBusNodeInfo, Converter.javaStringToCString(INTERFACE_NAME));
        int[] nArray = new int[3];
        nArray[0] = handleMethodCallback.getAddress();
        int[] vtable = nArray;
        OS.g_dbus_connection_register_object(connection, Converter.javaStringToCString(DBUS_OBJECT_NAME), interface_info, vtable, 0, 0, error);
        if (error[0] != 0) {
            System.err.println("SWT WebkitGDBus: Failed to register object: /org/eclipse/swt/gdbus");
            return 0;
        }
        return 0;
    }

    private static int onNameAcquiredCallback(int connection, int name, int user_data) {
        return 0;
    }

    private static int onNameLostCallback(int connection, int name, int user_data) {
        assert (false) : "This code should never have executed";
        System.err.println("SWT WebkitGDBus.java: Lost GDBus name. This should never occur");
        return 0;
    }

    private static int handleMethodCallback(int connection, int sender, int object_path, int interface_name, int method_name, int gvar_parameters, int invocation, int user_data) {
        String java_method_name = Converter.cCharPtrToJavaString(method_name, false);
        Object result = null;
        if (java_method_name != null && java_method_name.equals(webkit2callJava)) {
            try {
                Object[] java_parameters = (Object[])WebkitGDBus.convertGVariantToJava(gvar_parameters);
                result = WebKit.Webkit2Extension.webkit2callJavaCallback(java_parameters);
            }
            catch (Exception e) {
                result = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                System.err.println("SWT Webkit: Exception occured in Webkit2 callback logic. Bug?");
            }
        } else {
            result = "SWT Webkit: Gdbus called an unknown method?";
            System.err.println("SWT WebkitGDBus: Received a call from an unknown method: " + java_method_name);
        }
        int resultGVariant = 0;
        try {
            resultGVariant = WebkitGDBus.convertJavaToGVariant(new Object[]{result});
        }
        catch (SWTException e) {
            String errMsg = WebBrowser.CreateErrorString(e.getLocalizedMessage());
            resultGVariant = WebkitGDBus.convertJavaToGVariant(new Object[]{errMsg});
        }
        OS.g_dbus_method_invocation_return_value(invocation, resultGVariant);
        return 0;
    }

    private static Object convertGVariantToJava(int gVariant) {
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_BOOLEAN)) {
            return new Boolean(OS.g_variant_get_boolean(gVariant));
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_BYTE)) {
            byte byteVal = OS.g_variant_get_byte(gVariant);
            switch (byteVal) {
                case 48: {
                    return null;
                }
                case 101: {
                    return new Object[0];
                }
            }
            System.err.println("SWT Error, received unsupported byte type via gdbus: " + byteVal);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_DOUBLE)) {
            return new Double(OS.g_variant_get_double(gVariant));
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_STRING)) {
            return Converter.cCharPtrToJavaString(OS.g_variant_get_string(gVariant, null), false);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_TUPLE)) {
            int length = (int)OS.g_variant_n_children(gVariant);
            Object[] result = new Object[length];
            int i = 0;
            while (i < length) {
                result[i] = WebkitGDBus.convertGVariantToJava(OS.g_variant_get_child_value(gVariant, i));
                ++i;
            }
            return result;
        }
        String typeString = Converter.cCharPtrToJavaString(OS.g_variant_get_type_string(gVariant), false);
        SWT.error(5, new Throwable("Unhandled variant type " + typeString));
        return null;
    }

    private static int convertJavaToGVariant(Object javaObject) throws SWTException {
        if (javaObject == null) {
            return OS.g_variant_new_byte((byte)48);
        }
        if (javaObject instanceof String) {
            return OS.g_variant_new_string(Converter.javaStringToCString((String)javaObject));
        }
        if (javaObject instanceof Boolean) {
            return OS.g_variant_new_boolean((Boolean)javaObject);
        }
        if (javaObject instanceof Number) {
            return OS.g_variant_new_double(((Number)javaObject).doubleValue());
        }
        if (javaObject instanceof Object[]) {
            Object[] arrayValue = (Object[])javaObject;
            int length = arrayValue.length;
            if (length == 0) {
                return OS.g_variant_new_byte((byte)101);
            }
            int[] variants = new int[length];
            int i = 0;
            while (i < length) {
                variants[i] = WebkitGDBus.convertJavaToGVariant(arrayValue[i]);
                ++i;
            }
            return OS.g_variant_new_tuple(variants, length);
        }
        System.err.println("SWT Webkit: Invalid object being returned to javascript: " + javaObject.toString() + "\n" + "Only the following are supported: null, String, Boolean, Number(Long,Integer,Double...), Object[] of basic types");
        throw new SWTException(5, "Given object is not valid: " + javaObject.toString());
    }
}

