/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.nature;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class RcpttNature
implements IProjectNature {
    public static final String NATURE_ID = "org.eclipse.rcptt.core.rcpttnature";
    public static final String LEGACY_NATURE_ID = "com.xored.q7.core.q7nature";
    public static final String BUILDER_ID = "org.eclipse.rcptt.core.builder.q7Builder";
    public static final String LEGACY_BUILDER_ID = "com.xored.q7.core.builder.q7Builder";
    private IProject project;

    public void configure() throws CoreException {
        if (!RcpttNature.hasBuilder(this.project)) {
            RcpttNature.enableFor(this.project);
        }
    }

    public void deconfigure() throws CoreException {
    }

    public static boolean isRcpttProject(IProject project) throws CoreException {
        return project.hasNature(NATURE_ID);
    }

    public static void updateProjectNature(IProject project, boolean add) throws CoreException {
        List<String> natures = RcpttNature.getNewNatures(project, add);
        if (natures != null) {
            IProjectDescription description = project.getDescription();
            String[] naturesArray = natures.toArray(new String[natures.size()]);
            description.setNatureIds(naturesArray);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static List<String> getNewNatures(IProject project, boolean add) throws CoreException {
        String[] natures;
        ArrayList<String> newNatures = new ArrayList<String>();
        IProjectDescription description = project.getDescription();
        String[] stringArray = natures = description.getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (NATURE_ID.equals(nature)) {
                if (add) {
                    return null;
                }
            } else {
                newNatures.add(nature);
            }
            ++n2;
        }
        if (add) {
            newNatures.add(NATURE_ID);
        } else if (newNatures.size() == natures.length) {
            return null;
        }
        return newNatures;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private static boolean hasBuilder(IProject iProject) throws CoreException {
        ICommand[] buildSpec;
        IProjectDescription description = iProject.getDescription();
        ICommand[] iCommandArray = buildSpec = description.getBuildSpec();
        int n = buildSpec.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand iCommand = iCommandArray[n2];
            if (iCommand.getBuilderName().equals(BUILDER_ID)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void enableFor(IProject iProject) throws CoreException {
        IProjectDescription description = iProject.getDescription();
        ICommand[] buildSpec = description.getBuildSpec();
        ICommand[] newSpecs = new ICommand[buildSpec.length + 1];
        System.arraycopy(buildSpec, 0, newSpecs, 0, buildSpec.length);
        newSpecs[buildSpec.length] = description.newCommand();
        newSpecs[buildSpec.length].setBuilderName(BUILDER_ID);
        description.setBuildSpec(newSpecs);
        iProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
    }
}

