/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.equinox.internal.p2.importexport.P2ImportExport;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.AbstractImportPage;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUPatternFilter;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractPage
extends WizardPage
implements Listener {
    protected String currentMessage;
    protected Button destinationBrowseButton;
    protected Button includeAllButton;
    protected Combo destinationNameField;
    protected P2ImportExport importexportService = null;
    protected CheckboxTreeViewer viewer = null;
    protected Exception finishException;
    protected boolean entryChanged = false;
    protected static IProfileRegistry profileRegistry = null;
    static IProvisioningAgent agent = null;
    private static final String STORE_DESTINATION_NAMES_ID = "P2ImportExportPage.STORE_DESTINATION_NAMES_ID";
    protected static final int COMBO_HISTORY_LENGTH = 5;

    static {
        BundleContext context = Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport").getBundleContext();
        ServiceTracker tracker = new ServiceTracker(context, IProvisioningAgent.class, null);
        tracker.open();
        agent = (IProvisioningAgent)tracker.getService();
        tracker.close();
        if (agent != null) {
            profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        }
    }

    public AbstractPage(String pageName) {
        super(pageName);
    }

    public AbstractPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected IProfile getSelfProfile() {
        if (profileRegistry != null) {
            String selfID = System.getProperty("eclipse.p2.profile");
            if (selfID == null) {
                selfID = "_SELF_";
            }
            return profileRegistry.getProfile(selfID);
        }
        return null;
    }

    private void createColumns(TreeViewer treeViewer) {
        String[] titles = new String[]{Messages.Column_Name, Messages.Column_Version, Messages.Column_Id};
        int i = 0;
        while (i < titles.length) {
            TreeViewerColumn column = new TreeViewerColumn(treeViewer, 0);
            column.getColumn().setText(titles[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            if (Messages.Column_Name.equals(titles[i])) {
                this.updateTableSorting(i);
            }
            int columnIndex = i++;
            column.getColumn().addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.updateTableSorting(columnIndex)));
        }
    }

    protected void updateTableSorting(int columnIndex) {
        TreeViewerComparator comparator = (TreeViewerComparator)this.viewer.getComparator();
        if (columnIndex == comparator.getSortColumn()) {
            comparator.setAscending(!comparator.isAscending());
        }
        comparator.setSortColumn(columnIndex);
        this.viewer.getTree().setSortColumn(this.viewer.getTree().getColumn(columnIndex));
        this.viewer.getTree().setSortDirection(comparator.isAscending() ? 128 : 1024);
        this.viewer.refresh(false);
    }

    protected abstract void createContents(Composite var1);

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.initializeService();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        this.createContents(composite);
        if (!this.validDestination() || !this.validateOptionsGroup()) {
            this.setPageComplete(false);
        }
        this.setControl((Control)composite);
        this.giveFocusToDestination();
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createDestinationGroup(Composite parent, boolean includeButton) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(composite, 0);
        label.setText(this.getDestinationLabel());
        this.destinationNameField = new Combo(composite, 2052);
        this.restoreWidgetValues();
        GridData data = new GridData(768);
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.handleDestinationChanged(this.getDestinationValue())));
        this.destinationNameField.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.character == '\r') {
                this.entryChanged = false;
                this.modifyDestinationValue(this.getDestinationValue());
                this.handleDestinationChanged(this.getDestinationValue());
            }
        }));
        this.destinationNameField.addModifyListener(e -> {
            boolean bl = this.entryChanged = true;
        });
        this.destinationNameField.addFocusListener(FocusListener.focusLostAdapter(e -> {
            if (this.entryChanged) {
                this.entryChanged = false;
                this.handleDestinationChanged(this.getDestinationValue());
            }
        }));
        this.destinationBrowseButton = new Button(composite, 8);
        this.destinationBrowseButton.setText(Messages.Page_BUTTON_BROWSER);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setLayoutData((Object)new GridData(256));
        if (includeButton) {
            this.includeAllButton = new Button(composite, 32);
            this.includeAllButton.setText(Messages.ExportPage_EntriesNotInRepo);
            this.includeAllButton.setSelection(this.allowExportWithoutRepositoryReference());
            GridData dataIncludeButton = new GridData();
            dataIncludeButton.horizontalSpan = 3;
            this.includeAllButton.setLayoutData((Object)dataIncludeButton);
        }
    }

    private boolean allowExportWithoutRepositoryReference() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.equinox.p2.ui.importexport", "allowIUWithoutRepository", false, new IScopeContext[]{DefaultScope.INSTANCE});
    }

    protected IUColumnConfig[] getColumnConfig() {
        return new IUColumnConfig[]{new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, 60), new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, 20), new IUColumnConfig(ProvUIMessages.ProvUI_IdColumnTitle, 0, 40)};
    }

    protected void createInstallationTable(final Composite parent) {
        Group group = new Group(parent, 0);
        GridData griddata = new GridData(4, 4, true, true);
        griddata.horizontalSpan = 0;
        griddata.verticalSpan = 0;
        group.setLayoutData((Object)griddata);
        group.setLayout((Layout)new GridLayout(1, false));
        PatternFilter filter = this.getPatternFilter();
        filter.setIncludeLeadingWildcard(true);
        ImportExportFilteredTree filteredTree = new ImportExportFilteredTree((Composite)group, 68354, filter, true);
        this.viewer = (CheckboxTreeViewer)filteredTree.getViewer();
        final Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(false);
        this.viewer.setComparator((ViewerComparator)new TreeViewerComparator());
        this.viewer.setComparer((IElementComparer)new ProvElementComparer());
        this.createColumns((TreeViewer)this.viewer);
        ITreeContentProvider contentProvider = this.getContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.addCheckStateListener(event -> {
            if (!event.getChecked() && importExportFilteredTree.checkState != null) {
                ArrayList<Object> toRemove = new ArrayList<Object>(1);
                if (contentProvider.hasChildren(event.getElement())) {
                    HashSet<Object> unchecked = new HashSet<Object>();
                    Object[] children = contentProvider.getChildren(event.getElement());
                    int i = 0;
                    while (i < children.length) {
                        unchecked.add(children[i]);
                        ++i;
                    }
                    for (Object current : importExportFilteredTree.checkState) {
                        if (current == null || !unchecked.contains(current)) continue;
                        toRemove.add(current);
                    }
                } else {
                    for (Object element : importExportFilteredTree.checkState) {
                        if (!this.viewer.getComparer().equals(element, event.getElement())) continue;
                        toRemove.add(element);
                    }
                }
                importExportFilteredTree.checkState.removeAll(toRemove);
            }
        });
        parent.addControlListener((ControlListener)new ControlAdapter(){
            private final int[] columnRate = new int[]{6, 2, 2};

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point size = tree.computeSize(-1, -1);
                ScrollBar vBar = tree.getVerticalBar();
                int width = area.width - tree.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                if (size.y > area.height + tree.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tree.getSize();
                TreeColumn[] columns = tree.getColumns();
                int hasUsed = 0;
                int i = 0;
                if (oldSize.x > area.width) {
                    while (i < columns.length - 1) {
                        columns[i].setWidth(width * this.columnRate[i] / 10);
                        hasUsed += columns[i].getWidth();
                        ++i;
                    }
                    columns[columns.length - 1].setWidth(width - hasUsed);
                    tree.setSize(area.width, area.height);
                } else {
                    tree.setSize(area.width, area.height);
                    while (i < columns.length - 1) {
                        columns[i].setWidth(width * this.columnRate[i] / 10);
                        hasUsed += columns[i].getWidth();
                        ++i;
                    }
                    columns[columns.length - 1].setWidth(width - hasUsed);
                }
            }
        });
        ICheckStateProvider provider = this.getViewerDefaultState();
        if (provider != null) {
            this.viewer.setCheckStateProvider(provider);
        } else {
            this.viewer.addSelectionChangedListener(event -> this.updatePageCompletion());
        }
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getControl().setSize(300, 200);
        this.viewer.setInput(this.getInput());
        Composite buttons = new Composite((Composite)group, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        buttons.setLayout((Layout)new RowLayout(256));
        Button selectAll = new Button(buttons, 8);
        selectAll.setText(Messages.AbstractPage_ButtonSelectAll);
        selectAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TreeItem[] treeItemArray = this.viewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (!item.getChecked()) {
                    item.setChecked(true);
                    Event event = new Event();
                    event.widget = item.getParent();
                    event.detail = 32;
                    event.item = item;
                    event.type = 13;
                    this.viewer.getTree().notifyListeners(13, event);
                }
                ++n2;
            }
            this.updatePageCompletion();
        }));
        Button deselectAll = new Button(buttons, 8);
        deselectAll.setText(Messages.AbstractPage_ButtonDeselectAll);
        deselectAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TreeItem[] treeItemArray = this.viewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                this.viewer.setSubtreeChecked(item.getData(), false);
                ++n2;
            }
            this.updatePageCompletion();
        }));
    }

    protected PatternFilter getPatternFilter() {
        return new AvailableIUPatternFilter(this.getColumnConfig());
    }

    protected ICheckStateProvider getViewerDefaultState() {
        return null;
    }

    protected ITableLabelProvider getLabelProvider() {
        return new IUDetailsLabelProvider(null, this.getColumnConfig(), null);
    }

    protected ITreeContentProvider getContentProvider() {
        ProvElementContentProvider provider = new ProvElementContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof InstalledIUElement) {
                    return false;
                }
                return super.hasChildren(element);
            }

            public Object[] getChildren(Object parent) {
                if (parent instanceof InstalledIUElement) {
                    return new Object[0];
                }
                return super.getChildren(parent);
            }
        };
        return provider;
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        this.currentMessage = null;
        boolean bl = complete = this.validateDestinationGroup() && this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(this.currentMessage);
        }
        return complete;
    }

    protected abstract void doFinish() throws Exception;

    protected int getBrowseDialogStyle() {
        return 4096;
    }

    protected abstract String getDestinationLabel();

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected abstract String getDialogTitle();

    protected abstract Object getInput();

    protected abstract String getInvalidDestinationMessage();

    protected String getNoOptionsMessage() {
        return Messages.PAGE_NOINSTALLTION_ERROR;
    }

    protected abstract void giveFocusToDestination();

    protected void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), this.getBrowseDialogStyle() | 0x10000000);
        dialog.setText(this.getDialogTitle());
        dialog.setFilterPath(this.getDestinationValue());
        dialog.setFilterExtensions(new String[]{Messages.EXTENSION_p2F, Messages.EXTENSION_ALL});
        dialog.setFilterNames(new String[]{Messages.EXTENSION_p2F_NAME, Messages.EXTENSION_ALL_NAME});
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            if (!selectedFileName.endsWith(Messages.EXTENSION_p2F.substring(1))) {
                selectedFileName = String.valueOf(selectedFileName) + Messages.EXTENSION_p2F.substring(1);
            }
            this.setDestinationValue(selectedFileName);
            this.handleDestinationChanged(selectedFileName);
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected void handleDestinationChanged(String newDestination) {
    }

    protected void initializeService() {
        ServiceTracker tracker = new ServiceTracker(Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport").getBundleContext(), P2ImportExport.class.getName(), null);
        tracker.open();
        this.importexportService = (P2ImportExport)tracker.getService();
        tracker.close();
    }

    protected void setDestinationValue(String selectedFileName) {
        this.destinationNameField.setText(selectedFileName);
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            if (this instanceof AbstractImportPage) {
                this.saveWidgetValues();
            }
            this.setMessage(null);
        }
    }

    protected boolean validateDestinationGroup() {
        if (!this.validDestination()) {
            this.currentMessage = this.getInvalidDestinationMessage();
            return false;
        }
        return true;
    }

    protected boolean validateOptionsGroup() {
        if (this.viewer == null || this.viewer.getCheckedElements().length > 0) {
            return true;
        }
        this.currentMessage = this.getNoOptionsMessage();
        return false;
    }

    protected boolean validDestination() {
        if (this.destinationNameField == null) {
            return true;
        }
        File file = new File(this.getDestinationValue());
        return file.getPath().length() > 0 && !file.isDirectory();
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
        }
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    protected void restoreWidgetValues() {
        String[] directoryNames;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID)) != null) {
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
            this.setDestinationValue("");
        }
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    void modifyDestinationValue(String destinationValue) {
    }

    final class ImportExportFilteredTree
    extends FilteredTree {
        ArrayList<Object> checkState;

        ImportExportFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
            super(parent, treeStyle, filter, useNewLook);
            this.checkState = new ArrayList();
        }

        protected TreeViewer doCreateTreeViewer(Composite composite, int style) {
            return new CheckboxTreeViewer(composite, style);
        }

        protected WorkbenchJob doCreateRefreshJob() {
            WorkbenchJob job = super.doCreateRefreshJob();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void aboutToRun(IJobChangeEvent event) {
                    Display.getDefault().syncExec(() -> {
                        Object[] checked = ((ImportExportFilteredTree)ImportExportFilteredTree.this).AbstractPage.this.viewer.getCheckedElements();
                        if (ImportExportFilteredTree.this.checkState == null) {
                            ImportExportFilteredTree.this.checkState = new ArrayList(checked.length);
                        }
                        int i = 0;
                        while (i < checked.length) {
                            if (!((ImportExportFilteredTree)ImportExportFilteredTree.this).AbstractPage.this.viewer.getGrayed(checked[i]) && !ImportExportFilteredTree.this.checkState.contains(checked[i])) {
                                ImportExportFilteredTree.this.checkState.add(checked[i]);
                            }
                            ++i;
                        }
                    });
                }

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        Display.getDefault().asyncExec(() -> {
                            if (((ImportExportFilteredTree)ImportExportFilteredTree.this).AbstractPage.this.viewer == null || ((ImportExportFilteredTree)ImportExportFilteredTree.this).AbstractPage.this.viewer.getTree().isDisposed()) {
                                return;
                            }
                            if (ImportExportFilteredTree.this.checkState == null) {
                                return;
                            }
                            ((ImportExportFilteredTree)ImportExportFilteredTree.this).AbstractPage.this.viewer.setCheckedElements(new Object[0]);
                            ((ImportExportFilteredTree)ImportExportFilteredTree.this).AbstractPage.this.viewer.setGrayedElements(new Object[0]);
                            Iterator<Object> iter = ImportExportFilteredTree.this.checkState.iterator();
                            while (iter.hasNext()) {
                                ((ImportExportFilteredTree)ImportExportFilteredTree.this).AbstractPage.this.viewer.setChecked(iter.next(), true);
                            }
                            AbstractPage.this.updatePageCompletion();
                        });
                    }
                }
            });
            return job;
        }
    }

    class TreeViewerComparator
    extends ViewerComparator {
        private int sortColumn = 0;
        private int lastSortColumn = 0;
        private boolean ascending = false;
        private boolean lastAscending = false;

        TreeViewerComparator() {
        }

        public int compare(Viewer viewer1, Object e1, Object e2) {
            IInstallableUnit iu1 = (IInstallableUnit)ProvUI.getAdapter((Object)e1, IInstallableUnit.class);
            IInstallableUnit iu2 = (IInstallableUnit)ProvUI.getAdapter((Object)e2, IInstallableUnit.class);
            if (iu1 != null && iu2 != null) {
                TreeViewer treeViewer;
                IBaseLabelProvider baseLabel;
                if (viewer1 instanceof TreeViewer && (baseLabel = (treeViewer = (TreeViewer)viewer1).getLabelProvider()) instanceof ITableLabelProvider) {
                    ITableLabelProvider tableProvider = (ITableLabelProvider)baseLabel;
                    String e1p = tableProvider.getColumnText(e1, this.getSortColumn());
                    String e2p = tableProvider.getColumnText(e2, this.getSortColumn());
                    int result = this.getComparator().compare(e1p, e2p);
                    if (result == 0) {
                        e1p = tableProvider.getColumnText(e1, this.lastSortColumn);
                        e2p = tableProvider.getColumnText(e2, this.lastSortColumn);
                        int result2 = this.getComparator().compare(e1p, e2p);
                        return this.lastAscending ? result2 : -1 * result2;
                    }
                    return this.isAscending() ? result : -1 * result;
                }
                return 0;
            }
            return super.compare(viewer1, e1, e2);
        }

        public int getSortColumn() {
            return this.sortColumn;
        }

        public void setSortColumn(int sortColumn) {
            if (this.sortColumn != sortColumn) {
                this.lastSortColumn = this.sortColumn;
                this.lastAscending = this.ascending;
                this.sortColumn = sortColumn;
            }
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }
}

