/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.internal.resources;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.search.Matcher;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceContext;
import org.eclipse.rcptt.workspace.util.WorkspaceSwitch;

public class WorkspaceContextMatcher
implements Matcher {
    public boolean matches(IQ7NamedElement object, String query, SubMonitor monitor) {
        if (!(object instanceof IContext)) {
            return false;
        }
        String type = Q7SearchCore.findContextTypeByDocument((IContext)((IContext)object));
        if (type == null && object instanceof IContext) {
            try {
                type = ((IContext)object).getType().getId();
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
        if (type != null && !type.equals("org.eclipse.rcptt.ctx.workspace")) {
            return false;
        }
        try {
            NamedElement ctx = object.getNamedElement();
            if (ctx instanceof WorkspaceContext) {
                WorkspaceContext context = (WorkspaceContext)ctx;
                SearchSwitch sw = new SearchSwitch(query, (IProgressMonitor)monitor);
                try {
                    return (Boolean)sw.doSwitch((EObject)context.getContent());
                }
                catch (OperationCanceledException operationCanceledException) {
                    return false;
                }
            }
            return false;
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return false;
        }
    }

    private static class SearchSwitch
    extends WorkspaceSwitch<Boolean> {
        private final String query;
        private final IProgressMonitor monitor;

        public SearchSwitch(String query, IProgressMonitor monitor) {
            this.query = query.toLowerCase();
            this.monitor = monitor;
        }

        public Boolean caseWSFile(WSFile object) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            return object.getName().toLowerCase().contains(this.query);
        }

        public Boolean caseWSFolder(WSFolder object) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (object.getName().toLowerCase().contains(this.query)) {
                return true;
            }
            for (WSFile file : object.getFiles()) {
                if (!this.caseWSFile(file).booleanValue()) continue;
                return true;
            }
            for (WSFile file : object.getFolders()) {
                if (!this.caseWSFolder((WSFolder)file).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public Boolean caseWSProject(WSProject object) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (object.getName().toLowerCase().contains(this.query)) {
                return true;
            }
            for (WSFile file : object.getFiles()) {
                if (!this.caseWSFile(file).booleanValue()) continue;
                return true;
            }
            for (WSFile file : object.getFolders()) {
                if (!this.caseWSFolder((WSFolder)file).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public Boolean caseWSRoot(WSRoot object) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            for (WSProject project : object.getProjects()) {
                if (!this.caseWSProject(project).booleanValue()) continue;
                return true;
            }
            return false;
        }
    }
}

