/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.StorageLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class JavaElementLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public static final int SHOW_RETURN_TYPE = 1;
    public static final int SHOW_PARAMETERS = 2;
    @Deprecated
    public static final int SHOW_CONTAINER = 4;
    @Deprecated
    public static final int SHOW_CONTAINER_QUALIFICATION = 8;
    public static final int SHOW_OVERLAY_ICONS = 16;
    public static final int SHOW_TYPE = 32;
    public static final int SHOW_ROOT = 64;
    @Deprecated
    public static final int SHOW_POSTIFIX_QUALIFICATION = 128;
    public static final int SHOW_SMALL_ICONS = 256;
    public static final int SHOW_VARIABLE = 512;
    public static final int SHOW_QUALIFIED = 1024;
    public static final int SHOW_POST_QUALIFIED = 2048;
    public static final int SHOW_BASICS = 0;
    public static final int SHOW_DEFAULT = new Integer(18);
    private JavaElementImageProvider fImageLabelProvider = new JavaElementImageProvider();
    private StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private int fFlags;
    private int fImageFlags;
    private long fTextFlags;

    public JavaElementLabelProvider() {
        this(SHOW_DEFAULT);
    }

    public JavaElementLabelProvider(int flags) {
        this.fFlags = flags;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    private boolean getFlag(int flag) {
        return (this.fFlags & flag) != 0;
    }

    public void turnOn(int flags) {
        this.fFlags |= flags;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    public void turnOff(int flags) {
        this.fFlags &= ~flags;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    private void updateImageProviderFlags() {
        this.fImageFlags = 0;
        if (this.getFlag(16)) {
            this.fImageFlags |= 1;
        }
        if (this.getFlag(256)) {
            this.fImageFlags |= 2;
        }
    }

    private void updateTextProviderFlags() {
        this.fTextFlags = 0x200000L;
        if (this.getFlag(1)) {
            this.fTextFlags |= 0x20L;
        }
        if (this.getFlag(2)) {
            this.fTextFlags |= 1L;
        }
        if (this.getFlag(4)) {
            this.fTextFlags |= 0x1110520100L;
        }
        if (this.getFlag(128)) {
            this.fTextFlags |= 0x110100000L;
        } else if (this.getFlag(8)) {
            this.fTextFlags |= 0x88040000L;
        }
        if (this.getFlag(32)) {
            this.fTextFlags |= 0x4000L;
        }
        if (this.getFlag(64)) {
            this.fTextFlags |= 0x80000000000L;
        }
        if (this.getFlag(512)) {
            this.fTextFlags |= 0x10000000000L;
        }
        if (this.getFlag(1024)) {
            this.fTextFlags |= 0x89050480L;
        }
        if (this.getFlag(2048)) {
            this.fTextFlags |= 0x112520900L;
        }
    }

    public Image getImage(Object element) {
        Image result = this.fImageLabelProvider.getImageLabel(element, this.fImageFlags);
        if (result != null) {
            return result;
        }
        if (element instanceof IStorage) {
            return this.fStorageLabelProvider.getImage(element);
        }
        return result;
    }

    public String getText(Object element) {
        return JavaElementLabels.getTextLabel(element, this.fTextFlags);
    }

    public StyledString getStyledText(Object element) {
        return JavaElementLabels.getStyledTextLabel(element, this.fTextFlags);
    }

    public void dispose() {
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }
}

