/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.search.JavaMatchFilter;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;

abstract class GenericTypeFilter
extends JavaMatchFilter {
    GenericTypeFilter() {
    }

    @Override
    public boolean isApplicable(JavaSearchQuery query) {
        List<QuerySpecification> specList = query.getSpecification();
        boolean isApplicable = false;
        for (QuerySpecification spec : specList) {
            if (spec instanceof ElementQuerySpecification) {
                ElementQuerySpecification elementSpec = (ElementQuerySpecification)spec;
                IJavaElement element = elementSpec.getElement();
                isApplicable = GenericTypeFilter.isParameterizedElement(element);
                if (isApplicable) continue;
                return false;
            }
            return false;
        }
        return isApplicable;
    }

    private static boolean isParameterizedElement(IJavaElement element) {
        while (element != null) {
            ITypeParameter[] typeParameters = null;
            try {
                if (element instanceof IType) {
                    typeParameters = ((IType)element).getTypeParameters();
                } else if (element instanceof IMethod) {
                    typeParameters = ((IMethod)element).getTypeParameters();
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
            if (typeParameters == null) {
                return false;
            }
            if (typeParameters.length > 0) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }
}

