/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.JavaObjectValueEditor;
import org.eclipse.jdt.internal.debug.ui.actions.JavaPrimitiveValueEditor;
import org.eclipse.swt.widgets.Shell;

public class JavaVariableValueEditor
implements IVariableValueEditor {
    public boolean editVariable(IVariable variable, Shell shell) {
        String signature = null;
        try {
            signature = JavaVariableValueEditor.getSignature(variable);
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.errorDialog(shell, ActionMessages.JavaVariableValueEditor_0, ActionMessages.JavaVariableValueEditor_1, e);
        }
        if (signature == null) {
            return false;
        }
        Object editor = JDIModelPresentation.isObjectValue(signature) ? new JavaObjectValueEditor() : new JavaPrimitiveValueEditor(signature);
        return editor.editVariable(variable, shell);
    }

    public boolean saveVariable(IVariable variable, String expression, Shell shell) {
        if (expression.length() == 1 && variable instanceof IJavaVariable) {
            IJavaVariable javaVariable = (IJavaVariable)variable;
            try {
                if (javaVariable.getJavaType() != null && javaVariable.getJavaType().getSignature() == "C") {
                    javaVariable.setValue(expression);
                    return true;
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.statusDialog(e.getStatus());
            }
        }
        JavaObjectValueEditor editor = new JavaObjectValueEditor();
        return editor.saveVariable(variable, expression, shell);
    }

    public static String getSignature(IVariable variable) throws DebugException {
        String signature = null;
        IJavaVariable javaVariable = (IJavaVariable)variable.getAdapter(IJavaVariable.class);
        if (javaVariable != null) {
            signature = javaVariable.getSignature();
        }
        return signature;
    }
}

