/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.gef.describers;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.ui.describers.IWidgetDescriber;
import org.eclipse.rcptt.tesla.ui.describers.WidgetDescriber;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class EditPartDescriber
implements IWidgetDescriber {
    private final EditPart part;
    private final GraphicalViewer viewer;

    public EditPartDescriber(EditPart editPart, GraphicalViewer graphicalViewer) {
        this.part = editPart;
        this.viewer = graphicalViewer;
    }

    public Rectangle getBounds() {
        if (this.part instanceof GraphicalEditPart) {
            org.eclipse.draw2d.geometry.Rectangle bounds = ((GraphicalEditPart)this.part).getFigure().getBounds().getCopy();
            ((GraphicalEditPart)this.part).getFigure().translateToAbsolute((Translatable)bounds);
            return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        return null;
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    public Display getDisplay() {
        return this.part.getViewer().getControl().getDisplay();
    }

    public Point getPoint() {
        if (this.part instanceof GraphicalEditPart) {
            org.eclipse.draw2d.geometry.Rectangle bounds = ((GraphicalEditPart)this.part).getFigure().getBounds().getCopy();
            ((GraphicalEditPart)this.part).getFigure().translateToAbsolute((Translatable)bounds);
            RootEditPart root = this.part.getRoot();
            FigureCanvas canvas = null;
            if (root != null) {
                canvas = (FigureCanvas)root.getViewer().getControl();
            }
            if (canvas == null) {
                canvas = (FigureCanvas)this.viewer.getControl();
            }
            if (canvas != null) {
                return this.getDisplay().map((Control)canvas, null, bounds.x, bounds.y);
            }
        }
        return null;
    }

    public Point getRealPoint() {
        return this.getPoint();
    }

    public Widget getWidget() {
        return this.part.getViewer().getControl();
    }

    public Widget getItemWidget() {
        return null;
    }

    public void redraw() {
    }

    public EditPart getPart() {
        return this.part;
    }

    public IWidgetDescriber getControl() {
        return new WidgetDescriber((Widget)this.part.getViewer().getControl());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.part == null ? 0 : this.part.hashCode());
        result = 31 * result + (this.viewer == null ? 0 : this.viewer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditPartDescriber other = (EditPartDescriber)obj;
        if (this.part == null ? other.part != null : !this.part.equals(other.part)) {
            return false;
        }
        return !(this.viewer == null ? other.viewer != null : !this.viewer.equals(other.viewer));
    }

    public Image captureImage() {
        Widget widget = this.getControl().getWidget();
        Rectangle bounds = this.getBounds();
        if (widget instanceof Control) {
            return SWTUIPlayer.captureControlImageRaw((Control)((Control)widget), (Rectangle)bounds);
        }
        return null;
    }

    public boolean supportsDND() {
        return true;
    }
}

