/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.correction.java.FindClassResolutionsOperation;
import org.eclipse.pde.internal.ui.correction.java.JavaResolutionFactory;

public class UnresolvedImportFixProcessor
extends ClasspathFixProcessor {
    public ClasspathFixProcessor.ClasspathFixProposal[] getFixImportProposals(IJavaProject project, String name) throws CoreException {
        if (!WorkspaceModelManager.isPluginProject((IProject)project.getProject())) {
            return new ClasspathFixProcessor.ClasspathFixProposal[0];
        }
        ClasspathFixCollector collector = new ClasspathFixCollector();
        FindClassResolutionsOperation findOperation = new FindClassResolutionsOperation(project.getProject(), name, collector);
        try {
            findOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return collector.getProposals();
    }

    private class ClasspathFixCollector
    extends FindClassResolutionsOperation.AbstractClassResolutionCollector {
        private ArrayList<Object> fList = new ArrayList();

        private ClasspathFixCollector() {
        }

        @Override
        public void addResolutionModification(IProject project, ExportPackageDescription desc) {
            this.addResolutionModification(project, desc, null, "");
        }

        @Override
        public void addResolutionModification(IProject project, ExportPackageDescription desc, CompilationUnit cu, String qualifiedTypeToImport) {
            if (desc.getSupplier() == null) {
                return;
            }
            Object proposal = JavaResolutionFactory.createRequireBundleProposal(project, desc, 2, 16, cu, qualifiedTypeToImport);
            if (proposal != null) {
                this.fList.add(proposal);
            }
        }

        public ClasspathFixProcessor.ClasspathFixProposal[] getProposals() {
            return this.fList.toArray(new ClasspathFixProcessor.ClasspathFixProposal[this.fList.size()]);
        }
    }
}

