/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class InlineConstantWizard
extends RefactoringWizard {
    private static final String MESSAGE = RefactoringMessages.InlineConstantWizard_message;

    public InlineConstantWizard(InlineConstantRefactoring ref) {
        super((Refactoring)ref, 36);
        this.setDefaultPageTitle(RefactoringMessages.InlineConstantWizard_Inline_Constant);
    }

    protected void addUserInputPages() {
        String message = null;
        message = !this.getInlineConstantRefactoring().isInitializerAllStaticFinal() ? RefactoringMessages.InlineConstantWizard_initializer_refers_to_fields : MESSAGE;
        this.addPage((IWizardPage)new InlineConstantInputPage(message));
    }

    private InlineConstantRefactoring getInlineConstantRefactoring() {
        return (InlineConstantRefactoring)this.getRefactoring();
    }

    private static class InlineConstantInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "InlineConstantInputPage";
        private InlineConstantRefactoring fRefactoring;
        private Button fRemove;

        public InlineConstantInputPage(String description) {
            super(PAGE_NAME);
            this.setDescription(description);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            this.fRefactoring = (InlineConstantRefactoring)this.getRefactoring();
            this.fRefactoring.setReplaceAllReferences(this.fRefactoring.isDeclarationSelected());
            this.fRefactoring.setRemoveDeclaration(true);
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            result.setLayout((Layout)layout);
            GridData gd = null;
            Label label = new Label(result, 0);
            String constantLabel = JavaElementLabels.getElementLabel(this.fRefactoring.getField(), JavaElementLabels.ALL_DEFAULT | JavaElementLabels.ALL_FULLY_QUALIFIED);
            label.setText(Messages.format(RefactoringMessages.InlineConstantInputPage_Inline_constant, constantLabel));
            label.setLayoutData((Object)new GridData(768));
            Composite separator = new Composite(result, 0);
            separator.setLayoutData((Object)new GridData(0, 0));
            Button all = new Button(result, 16);
            all.setLayoutData((Object)new GridData(768));
            all.setText(RefactoringMessages.InlineConstantInputPage_All_references);
            all.setSelection(this.fRefactoring.getReplaceAllReferences());
            all.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    fRefactoring.setReplaceAllReferences(true);
                    fRemove.setEnabled(true);
                }
            });
            this.fRemove = new Button(result, 32);
            gd = new GridData(768);
            gd.horizontalIndent = LayoutUtil.getIndent();
            this.fRemove.setLayoutData((Object)gd);
            this.fRemove.setText(RefactoringMessages.InlineConstantInputPage_Delete_constant);
            this.fRemove.setEnabled(all.getSelection());
            this.fRemove.setSelection(this.fRefactoring.getRemoveDeclaration());
            this.fRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fRefactoring.setRemoveDeclaration(fRemove.getSelection());
                }
            });
            Button onlySelected = new Button(result, 16);
            onlySelected.setLayoutData((Object)new GridData(768));
            onlySelected.setText(RefactoringMessages.InlineConstantInputPage_Only_selected);
            onlySelected.setSelection(!this.fRefactoring.getReplaceAllReferences());
            if (this.fRefactoring.isDeclarationSelected()) {
                onlySelected.setEnabled(false);
                all.setFocus();
            } else {
                onlySelected.setFocus();
            }
            onlySelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    fRefactoring.setReplaceAllReferences(false);
                    fRemove.setEnabled(false);
                }
            });
            Dialog.applyDialogFont((Control)result);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.inline_constant_wizard_page_context");
        }
    }
}

