/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallSearchResultCollector;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;

class CalleeAnalyzerVisitor
extends HierarchicalASTVisitor {
    private final CallSearchResultCollector fSearchResults = new CallSearchResultCollector();
    private final IMember fMember;
    private final CompilationUnit fCompilationUnit;
    private final IProgressMonitor fProgressMonitor;
    private int fMethodEndPosition;
    private int fMethodStartPosition;

    CalleeAnalyzerVisitor(IMember member, CompilationUnit compilationUnit, IProgressMonitor progressMonitor) {
        this.fMember = member;
        this.fCompilationUnit = compilationUnit;
        this.fProgressMonitor = progressMonitor;
        try {
            ISourceRange sourceRange = member.getSourceRange();
            this.fMethodStartPosition = sourceRange.getOffset();
            this.fMethodEndPosition = this.fMethodStartPosition + sourceRange.getLength();
        }
        catch (JavaModelException jme) {
            JavaPlugin.log(jme);
        }
    }

    public Map<String, MethodCall> getCallees() {
        return this.fSearchResults.getCallers();
    }

    public boolean visit(ClassInstanceCreation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveConstructorBinding(), (ASTNode)node);
        }
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveConstructorBinding(), (ASTNode)node);
        }
        return true;
    }

    public boolean visit(AbstractTypeDeclaration node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            List bodyDeclarations = node.bodyDeclarations();
            for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                MethodDeclaration child;
                if (!(bodyDeclaration instanceof MethodDeclaration) || !(child = (MethodDeclaration)bodyDeclaration).isConstructor()) continue;
                this.addMethodCall(child.resolveBinding(), (ASTNode)child.getName());
            }
            return false;
        }
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        this.progressMonitorWorked(1);
        return this.isFurtherTraversalNecessary((ASTNode)node);
    }

    public boolean visit(MethodInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveMethodBinding(), (ASTNode)node);
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveConstructorBinding(), (ASTNode)node);
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveMethodBinding(), (ASTNode)node);
        }
        return true;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return this.isNodeEnclosingMethod((ASTNode)node);
    }

    protected void addMethodCall(IMethodBinding calledMethodBinding, ASTNode node) {
        try {
            if (calledMethodBinding != null) {
                this.fProgressMonitor.worked(1);
                ITypeBinding calledTypeBinding = calledMethodBinding.getDeclaringClass();
                IType calledType = null;
                calledType = !calledTypeBinding.isAnonymous() ? (IType)calledTypeBinding.getJavaElement() : (!"java.lang.Object".equals(calledTypeBinding.getSuperclass().getQualifiedName()) ? (IType)calledTypeBinding.getSuperclass().getJavaElement() : (IType)calledTypeBinding.getInterfaces()[0].getJavaElement());
                IMethod calledMethod = CalleeAnalyzerVisitor.findIncludingSupertypes(calledMethodBinding, calledType, this.fProgressMonitor);
                IType referencedMember = null;
                if (calledMethod == null) {
                    if (calledMethodBinding.isConstructor() && calledMethodBinding.getParameterTypes().length == 0) {
                        referencedMember = calledType;
                    }
                } else {
                    if (calledType.isInterface()) {
                        calledMethod = this.findImplementingMethods(calledMethod);
                    }
                    if (!this.isIgnoredBySearchScope(calledMethod)) {
                        referencedMember = calledMethod;
                    }
                }
                int position = node.getStartPosition();
                int number = this.fCompilationUnit.getLineNumber(position);
                this.fSearchResults.addMember(this.fMember, (IMember)referencedMember, position, position + node.getLength(), number < 1 ? 1 : number);
            }
        }
        catch (JavaModelException jme) {
            JavaPlugin.log(jme);
        }
    }

    private static IMethod findIncludingSupertypes(IMethodBinding method, IType type, IProgressMonitor pm) throws JavaModelException {
        IMethod inThisType = Bindings.findMethod((IMethodBinding)method, (IType)type);
        if (inThisType != null) {
            return inThisType;
        }
        IType[] superTypes = JavaModelUtil.getAllSuperTypes((IType)type, (IProgressMonitor)pm);
        int i = 0;
        while (i < superTypes.length) {
            IMethod m = Bindings.findMethod((IMethodBinding)method, (IType)superTypes[i]);
            if (m != null) {
                return m;
            }
            ++i;
        }
        return null;
    }

    private boolean isIgnoredBySearchScope(IMethod enclosingElement) {
        if (enclosingElement != null) {
            return !this.getSearchScope().encloses((IJavaElement)enclosingElement);
        }
        return false;
    }

    private IJavaSearchScope getSearchScope() {
        return CallHierarchy.getDefault().getSearchScope();
    }

    private boolean isNodeWithinMethod(ASTNode node) {
        int nodeStartPosition = node.getStartPosition();
        int nodeEndPosition = nodeStartPosition + node.getLength();
        if (nodeStartPosition < this.fMethodStartPosition) {
            return false;
        }
        return nodeEndPosition <= this.fMethodEndPosition;
    }

    private boolean isNodeEnclosingMethod(ASTNode node) {
        int nodeStartPosition = node.getStartPosition();
        int nodeEndPosition = nodeStartPosition + node.getLength();
        return nodeStartPosition < this.fMethodStartPosition && nodeEndPosition > this.fMethodEndPosition;
    }

    private boolean isFurtherTraversalNecessary(ASTNode node) {
        return this.isNodeWithinMethod(node) || this.isNodeEnclosingMethod(node);
    }

    private IMethod findImplementingMethods(IMethod calledMethod) {
        Collection<IJavaElement> implementingMethods = CallHierarchy.getDefault().getImplementingMethods(calledMethod);
        if (implementingMethods.size() == 0 || implementingMethods.size() > 1) {
            return calledMethod;
        }
        return (IMethod)implementingMethods.iterator().next();
    }

    private void progressMonitorWorked(int work) {
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.worked(work);
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }
}

