/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class TestTab
extends AbstractLaunchConfigurationTab {
    private ILaunchConfigurationDialog fLaunchConfigurationDialog;
    private final JUnitLaunchConfigurationTab junitLaunchTab = new JUnitLaunchConfigurationTab();
    private Button runInUIThread;

    public void createControl(Composite parent) {
        this.junitLaunchTab.createControl(parent);
        Composite composite = (Composite)this.getControl();
        this.createSpacer(composite);
        this.createRunInUIThreadGroup(composite);
    }

    private void createRunInUIThreadGroup(Composite comp) {
        this.runInUIThread = new Button(comp, 32);
        this.runInUIThread.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        this.runInUIThread.setText(PDEUIMessages.PDEJUnitLaunchConfigurationTab_Run_Tests_In_UI_Thread);
        GridDataFactory.fillDefaults().span(2, 0).grab(true, false).applyTo((Control)this.runInUIThread);
    }

    private void createSpacer(Composite comp) {
        Label label = new Label(comp, 0);
        GridDataFactory.fillDefaults().span(3, 0).applyTo((Control)label);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.junitLaunchTab.initializeFrom(config);
        this.updateRunInUIThreadGroup(config);
    }

    private void updateRunInUIThreadGroup(ILaunchConfiguration config) {
        boolean shouldRunInUIThread = true;
        try {
            shouldRunInUIThread = config.getAttribute("run_in_ui_thread", true);
        }
        catch (CoreException coreException) {}
        this.runInUIThread.setSelection(shouldRunInUIThread);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.junitLaunchTab.performApply(config);
        boolean selection = this.runInUIThread.getSelection();
        config.setAttribute("run_in_ui_thread", selection);
    }

    public String getId() {
        return "org.eclipse.pde.ui.launch.tab.test";
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.junitLaunchTab.activated(workingCopy);
    }

    public boolean canSave() {
        return this.junitLaunchTab.canSave();
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.junitLaunchTab.deactivated(workingCopy);
    }

    public void dispose() {
        this.junitLaunchTab.dispose();
    }

    public String getErrorMessage() {
        return this.junitLaunchTab.getErrorMessage();
    }

    public Image getImage() {
        return this.junitLaunchTab.getImage();
    }

    public String getMessage() {
        return this.junitLaunchTab.getMessage();
    }

    public String getName() {
        return this.junitLaunchTab.getName();
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.junitLaunchTab.isValid(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.junitLaunchTab.setDefaults(config);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        this.junitLaunchTab.setLaunchConfigurationDialog(dialog);
        this.fLaunchConfigurationDialog = dialog;
    }

    public Control getControl() {
        return this.junitLaunchTab.getControl();
    }

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fLaunchConfigurationDialog;
    }
}

