/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.wizards;

import java.net.URL;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryImages;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryUi;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class DiscoveryResources {
    private final ResourceManager resourceManager;
    private final FontDescriptor h1FontDescriptor;
    private final Display display;
    private final FontDescriptor h2FontDescriptor;
    private final RGB disabledColorDescriptor;

    public DiscoveryResources(Display display) {
        this.display = display;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)display));
        this.h1FontDescriptor = this.createFontDescriptor(1, 1.35f);
        this.h2FontDescriptor = this.createFontDescriptor(1, 1.25f);
        this.disabledColorDescriptor = new RGB(105, 105, 105);
    }

    public Cursor getHandCursor() {
        return this.display.getSystemCursor(21);
    }

    private FontDescriptor createFontDescriptor(int style, float heightMultiplier) {
        Font baseFont = JFaceResources.getDialogFont();
        FontData[] fontData = baseFont.getFontData();
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < newFontData.length) {
            newFontData[i] = new FontData(fontData[i].getName(), (int)((float)fontData[i].getHeight() * heightMultiplier), fontData[i].getStyle() | style);
            ++i;
        }
        return FontDescriptor.createFrom((FontData[])newFontData);
    }

    public void dispose() {
        this.resourceManager.dispose();
    }

    public Font getHeaderFont() {
        return this.resourceManager.createFont(this.h1FontDescriptor);
    }

    public Font getSmallHeaderFont() {
        return this.resourceManager.createFont(this.h2FontDescriptor);
    }

    public Image getInfoImage() {
        return this.resourceManager.createImage(DiscoveryImages.MESSAGE_INFO);
    }

    public Image getIconImage(AbstractCatalogSource discoverySource, Icon icon, int dimension, boolean fallback) {
        URL resource;
        String imagePath;
        switch (dimension) {
            case 64: {
                imagePath = icon.getImage64();
                if (imagePath != null || !fallback) break;
            }
            case 48: {
                imagePath = icon.getImage48();
                if (imagePath != null || !fallback) break;
            }
            case 32: {
                imagePath = icon.getImage32();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (imagePath != null && imagePath.length() > 0 && (resource = discoverySource.getResource(imagePath)) != null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)resource);
            return this.resourceManager.createImage(descriptor);
        }
        return null;
    }

    public Color getGradientBeginColor() {
        return DiscoveryUi.getCommonsColors().getGradientBegin();
    }

    public Color getGradientEndColor() {
        return DiscoveryUi.getCommonsColors().getGradientEnd();
    }

    public Color getColorDisabled() {
        return this.resourceManager.createColor(this.disabledColorDescriptor);
    }

    public Image getUpdateImage() {
        return this.resourceManager.createImage(DiscoveryImages.IU_UPDATABLE);
    }
}

