/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.events;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.tesla.core.am.RecordingModeFeature;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.swt.events.ITeslaEventListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeslaEventManager {
    private static TeslaEventManager manager = new TeslaEventManager();
    private static Shell activeShell;
    private Set<ITeslaEventListener> listeners = new HashSet<ITeslaEventListener>();
    private List<WeakReference<Menu>> popupMenus = new ArrayList<WeakReference<Menu>>();
    private Map<Menu, Control> popupMenuParents = new WeakHashMap<Menu, Control>();
    private Widget lastWidget;
    private int lastWidgetX;
    private int lastWidgetY;
    private List<ContextManagement.Context> syncExecs = new ArrayList<ContextManagement.Context>();
    private WeakReference<Control> forceFocusControl;
    private boolean ignoreMenuShow = false;
    private Map<Shell, String> shellMethodsMap = new WeakHashMap<Shell, String>();
    private boolean statusDialogModeAllowed = false;
    private boolean showingAlert = false;
    private IUnhandledNativeDialogHandler unhandledNativeDialogHandler;
    private volatile boolean unfreeze;
    private boolean noWaitForJob = false;

    public void setShowingAlert(boolean showing) {
        this.showingAlert = showing;
    }

    public boolean getShowingAlert() {
        return this.showingAlert;
    }

    public boolean isUnfreeze() {
        return this.unfreeze;
    }

    public void setUnfreeze(boolean unfreeze) {
        this.unfreeze = unfreeze;
    }

    private TeslaEventManager() {
    }

    public static TeslaEventManager getManager() {
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(ITeslaEventListener listener) {
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(ITeslaEventListener listener) {
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            this.listeners.clear();
        }
    }

    public boolean doProcessing(ContextManagement.Context currentContext) {
        boolean hasEvent = false;
        List<ITeslaEventListener> copy = this.getListeners();
        for (ITeslaEventListener listener : copy) {
            if (!listener.doProcessing(currentContext)) continue;
            hasEvent = true;
        }
        return hasEvent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasTimerProces() {
        Class<?> class1 = Display.getCurrent().getClass();
        try {
            Field field = class1.getDeclaredField("timerList");
            field.setAccessible(true);
            Runnable[] runnables = (Runnable[])field.get(Display.getCurrent());
            Field timerIds = class1.getDeclaredField("timerIds");
            timerIds.setAccessible(true);
            int[] timers = (int[])timerIds.get(Display.getCurrent());
            if (runnables == null) return false;
            if (runnables.length <= 0) return false;
            int i = 0;
            while (true) {
                if (i >= runnables.length) {
                    return false;
                }
                if (runnables[i] != null && timers[i] <= 200) {
                    System.out.println("Wait for timer proc:" + runnables[i].getClass().getName());
                    return true;
                }
                ++i;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITeslaEventListener> getListeners() {
        ArrayList<ITeslaEventListener> copy = null;
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            copy = new ArrayList<ITeslaEventListener>(this.listeners);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            return !this.listeners.isEmpty();
        }
    }

    public synchronized boolean proceedMenu(Menu menu, boolean value) {
        if (this.hasListeners() && !this.isUnfreeze()) {
            if (value) {
                if ((menu.getStyle() & 6) != 0) {
                    return false;
                }
                this.popupMenus.clear();
                this.popupMenus.add(new WeakReference<Menu>(menu));
            } else {
                this.popupMenus.clear();
            }
            return true;
        }
        return false;
    }

    public List<WeakReference<Menu>> getPopupMenus() {
        return this.popupMenus;
    }

    public Map<Menu, Control> getPopupMenuParents() {
        return this.popupMenuParents;
    }

    public Point getCursotLocation(Point point) {
        if (this.listeners.size() == 0) {
            return point;
        }
        if (this.lastWidget != null && this.lastWidget instanceof Control && !this.lastWidget.isDisposed()) {
            Control ctrl = (Control)this.lastWidget;
            return ctrl.toDisplay(this.lastWidgetX, this.lastWidgetY);
        }
        return point;
    }

    public void setLastWidget(Widget widget, int x, int y) {
        this.lastWidget = widget;
        this.lastWidgetX = x;
        this.lastWidgetY = y;
    }

    public void addMenuControl(Menu menu, Control parent) {
        this.popupMenuParents.put(menu, parent);
    }

    public synchronized void syncExecCalled(ContextManagement.Context ctx) {
        this.syncExecs.add(ctx);
    }

    public void hasEvent(HasEventKind hasEventKind, String name) {
        List<ITeslaEventListener> copy = this.getListeners();
        for (ITeslaEventListener listener : copy) {
            listener.hasEvent(hasEventKind, name);
        }
    }

    public synchronized void syncExecEnd(ContextManagement.Context ctx) {
        this.syncExecs.remove(ctx);
    }

    public synchronized List<ContextManagement.Context> getSyncExecs() {
        return new ArrayList<ContextManagement.Context>(this.syncExecs);
    }

    public static void setActiveShell(Shell shell) {
        activeShell = shell;
        TeslaEventManager.updateActiveShell();
    }

    public static void updateActiveShell() {
    }

    public static Shell getActiveShell() {
        return activeShell;
    }

    public synchronized boolean isJobInSyncExec(Job job, ContextManagement.Context context) {
        for (ContextManagement.Context context2 : this.syncExecs) {
            String clName;
            if (!context2.containsClass(clName = job.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isFiltering() {
        return TeslaEventManager.getManager().hasListeners() && !RecordingModeFeature.isRecordingModeActive() && !this.isUnfreeze();
    }

    public Control getForceFocusControl() {
        Control ctrl;
        Control control = ctrl = this.forceFocusControl == null ? null : (Control)this.forceFocusControl.get();
        if (ctrl != null && ctrl.isDisposed()) {
            return null;
        }
        return ctrl;
    }

    public boolean setForceFocusControl(Control focusControl) {
        if (this.forceFocusControl == null || focusControl != this.forceFocusControl.get()) {
            this.forceFocusControl = new WeakReference<Control>(focusControl);
            return true;
        }
        return false;
    }

    public void ignoreMenuShow(boolean b) {
        this.ignoreMenuShow = b;
    }

    public boolean isIgnoreMenuShow() {
        return this.ignoreMenuShow;
    }

    public void setShellCreationMethod(Shell shell, String clName, String methodName) {
        for (Shell sh : new HashSet(this.shellMethodsMap.keySet())) {
            if (sh == null || !sh.isDisposed()) continue;
            this.shellMethodsMap.remove(sh);
        }
        this.shellMethodsMap.put(shell, String.valueOf(clName) + "." + methodName);
    }

    public String getShellCreationMethod(Shell shell) {
        return this.shellMethodsMap.get(shell);
    }

    public boolean isStatusDialogModeAllowed() {
        return this.statusDialogModeAllowed;
    }

    public void setStatusDialogModeAllowed(boolean value) {
        this.statusDialogModeAllowed = value;
    }

    public void setNoWaitForJobs(boolean disableJobWaiting) {
        this.noWaitForJob = disableJobWaiting;
    }

    public boolean isNoWaitForJob() {
        return this.noWaitForJob;
    }

    public void unhandledNativeDialog(Class clazz, String message) {
        if (this.unhandledNativeDialogHandler != null) {
            this.unhandledNativeDialogHandler.handle(clazz, message);
        }
    }

    public void setUnhandledNativeDialogHandler(IUnhandledNativeDialogHandler unhandledNativeDialogHandler) {
        this.unhandledNativeDialogHandler = unhandledNativeDialogHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HasEventKind {
        async,
        sync,
        timer;

    }

    public static interface IUnhandledNativeDialogHandler {
        public void handle(Class var1, String var2);
    }
}

