/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.java7;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.NativeHandler;

public class PosixHandler
extends NativeHandler {
    private static final int ATTRIBUTES = 2143289446;

    public FileInfo fetchFileInfo(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        boolean exists = Files.exists(path, new LinkOption[0]);
        FileInfo info = new FileInfo();
        info.setExists(exists);
        boolean isSymbolicLink = Files.isSymbolicLink(path);
        if (isSymbolicLink) {
            info.setAttribute(32, true);
            try {
                info.setStringAttribute(64, Files.readSymbolicLink(path).toString());
            }
            catch (IOException iOException) {
                info.setError(5);
            }
        }
        File file = new File(fileName);
        final String lastName = file.getName();
        if (!info.exists() || EFS.getLocalFileSystem().isCaseSensitive() || lastName.toLowerCase().equals(lastName.toUpperCase())) {
            info.setName(lastName);
        } else {
            String[] names = file.getParentFile().list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String n) {
                    return n.equalsIgnoreCase(lastName);
                }
            });
            if (names.length == 1) {
                info.setName(names[0]);
            } else {
                info.setName(lastName);
            }
        }
        if (!exists) {
            return info;
        }
        try {
            PosixFileAttributes attrs = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
            info.setLastModified(attrs.lastModifiedTime().toMillis());
            info.setLength(attrs.size());
            info.setDirectory(attrs.isDirectory());
            Set<PosixFilePermission> perms = attrs.permissions();
            info.setAttribute(0x400000, perms.contains((Object)PosixFilePermission.OWNER_READ));
            info.setAttribute(0x800000, perms.contains((Object)PosixFilePermission.OWNER_WRITE));
            info.setAttribute(0x1000000, perms.contains((Object)PosixFilePermission.OWNER_EXECUTE));
            info.setAttribute(0x2000000, perms.contains((Object)PosixFilePermission.GROUP_READ));
            info.setAttribute(0x4000000, perms.contains((Object)PosixFilePermission.GROUP_WRITE));
            info.setAttribute(0x8000000, perms.contains((Object)PosixFilePermission.GROUP_EXECUTE));
            info.setAttribute(0x10000000, perms.contains((Object)PosixFilePermission.OTHERS_READ));
            info.setAttribute(0x20000000, perms.contains((Object)PosixFilePermission.OTHERS_WRITE));
            info.setAttribute(0x40000000, perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        }
        catch (IOException iOException) {
            info.setError(5);
        }
        return info;
    }

    public int getSupportedAttributes() {
        return 2143289446;
    }

    public boolean putFileInfo(String fileName, IFileInfo info, int options) {
        Path path = Paths.get(fileName, new String[0]);
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if (info.getAttribute(0x400000)) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if (info.getAttribute(0x800000)) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if (info.getAttribute(0x1000000)) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (info.getAttribute(0x2000000)) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if (info.getAttribute(0x4000000)) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if (info.getAttribute(0x8000000)) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (info.getAttribute(0x10000000)) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if (info.getAttribute(0x20000000)) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (info.getAttribute(0x40000000)) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        PosixFileAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        try {
            view.setPermissions(perms);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

