/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.SWTUtil;
import org.eclipse.pde.internal.ds.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.editor.sections.DSPropertiesSection;
import org.eclipse.pde.internal.ds.ui.parts.FormEntry;
import org.eclipse.pde.internal.ds.ui.wizards.DSNewClassCreationWizard;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DSEditPropertiesDialog
extends FormDialog {
    private IDSProperties fProperties;
    private DSPropertiesSection fPropertiesSection;
    private FormEntry fEntry;

    public DSEditPropertiesDialog(Shell parentShell, IDSProperties properties, DSPropertiesSection provideSection) {
        super(parentShell);
        this.fProperties = properties;
        this.fPropertiesSection = provideSection;
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText(Messages.DSEditPropertiesDialog_dialog_title);
        Composite container = mform.getForm().getBody();
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        FormToolkit toolkit = mform.getToolkit();
        toolkit.decorateFormHeading(mform.getForm().getForm());
        Composite entryContainer = toolkit.createComposite(container);
        entryContainer.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        entryContainer.setLayoutData((Object)new GridData(1808));
        this.fEntry = new FormEntry(entryContainer, toolkit, Messages.DSPropertiesDetails_entry, Messages.DSPropertiesDetails_browse, false, 0);
        GridData gd = new GridData(768);
        gd.widthHint = 20;
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 3;
        toolkit.paintBordersFor(entryContainer);
        this.updateFields();
        this.setEntryListeners();
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.handleOKPressed();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void handleOKPressed() {
        this.fEntry.commit();
        if (!(this.fEntry.getValue().equals("") && this.fProperties.getEntry() == null || this.fEntry.getValue().equals(this.fProperties.getEntry()))) {
            this.fProperties.setEntry(this.fEntry.getValue());
        }
    }

    private void updateFields() {
        if (this.fProperties == null) {
            return;
        }
        if (this.fProperties.getEntry() == null) {
            this.fEntry.setValue("");
        } else {
            this.fEntry.setValue(this.fProperties.getEntry(), true);
        }
        this.fEntry.setEditable(true);
    }

    public void setEntryListeners() {
        this.fEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this.fPropertiesSection){

            public void textValueChanged(FormEntry entry) {
            }

            public void textDirty(FormEntry entry) {
            }

            public void linkActivated(HyperlinkEvent e) {
                String value = DSEditPropertiesDialog.this.fEntry.getValue();
                if ((value = DSEditPropertiesDialog.this.handleLinkActivated(value, false)) != null) {
                    DSEditPropertiesDialog.this.fEntry.setValue(value);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                DSEditPropertiesDialog.this.doOpenSelectionDialog(DSEditPropertiesDialog.this.fEntry);
            }
        });
    }

    private String handleLinkActivated(String value, boolean isInter) {
        IProject project = this.getProject();
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType element = javaProject.findType(value.replace('$', '.'));
                if (element != null) {
                    JavaUI.openInEditor((IJavaElement)element);
                } else {
                    DSNewClassCreationWizard wizard = new DSNewClassCreationWizard(project, isInter, value);
                    WizardDialog dialog = new WizardDialog(Activator.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    if (dialog.open() == 0) {
                        return wizard.getQualifiedName();
                    }
                }
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    private IProject getProject() {
        PDEFormEditor editor = (PDEFormEditor)this.fPropertiesSection.getPage().getEditor();
        return editor.getCommonProject();
    }

    private void doOpenSelectionDialog(FormEntry entry) {
        final IProject project = this.getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Activator.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)project.getWorkspace());
        IResource resource = this.getFile();
        if (resource != null) {
            dialog.setInitialSelection((Object)resource);
        }
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals((Object)project);
                }
                return true;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.DSPropertiesDetails_dialogTitle);
        dialog.setMessage(Messages.DSPropertiesDetails_dialogMessage);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && (selection[0] instanceof IFile || selection[0] instanceof IContainer)) {
                    return new Status(0, "org.eclipse.pde.ds.ui", 0, "", null);
                }
                return new Status(4, "org.eclipse.pde.ds.ui", 4, "", null);
            }
        });
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            IPath path = res.getProjectRelativePath();
            if (res instanceof IContainer) {
                path = path.addTrailingSeparator();
            }
            String value = path.toString();
            this.fEntry.setValue(value);
        }
    }

    private IResource getFile() {
        String value = this.fEntry.getValue();
        if (value.length() == 0) {
            return null;
        }
        IProject project = this.getProject();
        IPath path = project.getFullPath().append(value);
        return project.getWorkspace().getRoot().findMember(path);
    }
}

